/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import unity.annotation.SourceField;
import unity.operators.Operator;
import unity.query.GQFieldRef;
import unity.query.GQTableRef;
import unity.query.GlobalQuery;
import unity.query.LQExprNode;
import unity.query.LQNode;
import unity.query.Optimizer;
import unity.query.SubQuery;

public class LQInsertNode
extends LQNode
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private GQTableRef sourceTable;
    private ArrayList<GQFieldRef> insertFields;
    private ArrayList<Object> insertValues;
    private GlobalQuery nestedQuery;

    public LQInsertNode() {
        this.type = 22;
        this.insertFields = new ArrayList();
        this.insertValues = new ArrayList();
        this.nestedQuery = null;
    }

    public void setNestedQuery(GlobalQuery globalQuery) {
        this.nestedQuery = globalQuery;
    }

    public void addField(GQFieldRef gQFieldRef) {
        this.insertFields.add(gQFieldRef);
    }

    public void addFields(GQTableRef gQTableRef, HashMap<String, GQFieldRef> hashMap) {
        String string = gQTableRef.getReferenceName();
        Iterator<SourceField> iterator = gQTableRef.getTable().fieldIterator();
        while (iterator.hasNext()) {
            SourceField sourceField = iterator.next();
            String string2 = (string + '.' + sourceField.getColumnName()).toLowerCase();
            GQFieldRef gQFieldRef = hashMap.get(string2);
            this.addField(gQFieldRef);
        }
    }

    public void addValue(LQExprNode lQExprNode) {
        this.insertValues.add(lQExprNode);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.generateSQL());
        stringBuffer.append('\n');
        stringBuffer.append(this.generateSubQuerySQL());
        return stringBuffer.toString();
    }

    public String generateSubQuerySQL() {
        if (this.nestedQuery != null) {
            return Optimizer.buildSQL(this.nestedQuery.getLogicalQueryTree().getRoot());
        }
        return "";
    }

    @Override
    public String generateSQL() {
        int n;
        String string = "";
        if (this.sourceTable != null) {
            string = this.sourceTable.getLocalName();
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(string);
        if (this.insertFields != null && this.insertFields.size() > 0) {
            stringBuffer.append(" (");
            for (n = 0; n < this.insertFields.size() - 1; ++n) {
                stringBuffer.append(this.insertFields.get(n).getName());
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.insertFields.get(this.insertFields.size() - 1).getName());
            stringBuffer.append(')');
        }
        if (this.insertValues != null && this.insertValues.size() > 0) {
            stringBuffer.append(" VALUES (");
            for (n = 0; n < this.insertValues.size() - 1; ++n) {
                stringBuffer.append(((LQExprNode)this.insertValues.get(n)).generateSQL());
                stringBuffer.append(", ");
            }
            stringBuffer.append(((LQExprNode)this.insertValues.get(this.insertValues.size() - 1)).generateSQL());
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    @Override
    public Operator buildOperator(Operator[] operatorArray, GlobalQuery globalQuery, SubQuery subQuery) throws SQLException {
        return null;
    }

    public GQTableRef getSourceTable() {
        return this.sourceTable;
    }

    public void setSourceTable(GQTableRef gQTableRef) {
        this.sourceTable = gQTableRef;
    }

    @Override
    public void computeCost() {
        long l = this.getChild(0).getRows();
        int n = this.getChild(0).tupleSize();
        this.cost = (double)l * (1.0 + 0.005 * (double)n);
        this.rows = l * 1L;
    }

    public ArrayList<GQFieldRef> getInsertFields() {
        return this.insertFields;
    }

    public ArrayList<Object> getInsertValues() {
        return this.insertValues;
    }
}

