/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import unity.operators.Operator;
import unity.query.GQFieldRef;
import unity.query.GlobalQuery;
import unity.query.LQNode;
import unity.query.Optimizer;
import unity.query.SubQuery;

public class LQCreateViewNode
extends LQNode
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private ArrayList<GQFieldRef> viewFields;
    private GlobalQuery nestedQuery;
    private String viewName;
    private String query;

    public LQCreateViewNode() {
        this.type = 50;
        this.viewFields = new ArrayList();
        this.nestedQuery = null;
    }

    public ArrayList<GQFieldRef> getViewFields() {
        return this.viewFields;
    }

    public void setNestedQuery(GlobalQuery globalQuery) {
        this.nestedQuery = globalQuery;
    }

    public void addField(GQFieldRef gQFieldRef) {
        this.viewFields.add(gQFieldRef);
    }

    public void setFields(ArrayList<GQFieldRef> arrayList) {
        this.viewFields = arrayList;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.generateSQL());
        stringBuffer.append('\n');
        stringBuffer.append(this.generateSubQuerySQL());
        return stringBuffer.toString();
    }

    public String generateSubQuerySQL() {
        if (this.nestedQuery != null) {
            return Optimizer.buildSQL(this.nestedQuery.getLogicalQueryTree().getRoot());
        }
        return "";
    }

    @Override
    public String generateSQL() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("CREATE VIEW ");
        stringBuffer.append(this.viewName);
        if (this.viewFields != null && this.viewFields.size() > 0) {
            stringBuffer.append(" (");
            for (int i = 0; i < this.viewFields.size() - 1; ++i) {
                stringBuffer.append(this.viewFields.get(i).getName());
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.viewFields.get(this.viewFields.size() - 1).getName());
            stringBuffer.append(')');
        }
        stringBuffer.append(" AS ");
        stringBuffer.append(this.generateSubQuerySQL());
        return stringBuffer.toString();
    }

    @Override
    public Operator buildOperator(Operator[] operatorArray, GlobalQuery globalQuery, SubQuery subQuery) throws SQLException {
        return null;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String string) {
        this.viewName = string;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    @Override
    public void computeCost() {
        this.setCost(0.0);
    }
}

