/*
 * Decompiled with CFR 0.152.
 */
package unity.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.GlobalSchema;
import unity.annotation.SourceDatabase;
import unity.cache.Cache;
import unity.cache.CacheEntry;
import unity.jdbc.UnityDatabaseMetaData;
import unity.jdbc.UnityDriver;
import unity.jdbc.UnityPreparedStatement;
import unity.jdbc.UnityStatement;
import unity.query.GlobalQuery;
import unity.query.LimitInfo;

public class UnityConnection
implements Connection {
    public static final int NO_CACHE = 0;
    public static final int RW_CACHE = 1;
    public static final int READ_CACHE = 2;
    public static final int AUTO_CONNECT_ON = 1;
    public static final int AUTO_CONNECT_OFF = 0;
    private static int connectionNum = 0;
    private boolean CLOSED = false;
    private boolean READONLY = true;
    private GlobalSchema schema;
    private Statement currentStatement = null;
    private int cacheType;
    private int cacheRowLimit;
    private int cachePostfetch;
    private int autoConnect;
    private Cache cache;
    private HashMap<String, Connection> connections;
    private SQLWarning firstWarning = null;
    private boolean autoCommit = true;
    private int rsHoldability = 2;
    private Properties clientInfo;
    private Map<String, Class<?>> typemap;
    private long sortBufferSize;
    private long joinBufferSize;
    private Properties properties;

    public UnityConnection(GlobalSchema globalSchema, Properties properties) throws SQLException {
        this.schema = globalSchema;
        if (connectionNum >= UnityDriver.getConnectionLimit() && UnityDriver.isClientVersion()) {
            throw new SQLException(UnityDriver.i18n.getString("UnityConnection.NumberConnections") + UnityDriver.getConnectionLimit() + ' ' + UnityDriver.i18n.getString("UnityConnection.NumberConnectionsInClientVersion"));
        }
        if (UnityDriver.DEBUG) {
            System.out.println("Connection num: " + ++connectionNum);
        }
        this.cacheType = 0;
        this.autoConnect = 0;
        this.cachePostfetch = 100;
        this.cacheRowLimit = 10000;
        this.sortBufferSize = 20000000L;
        this.joinBufferSize = 20000000L;
        this.properties = new Properties();
        this.properties.put("pushdownjoin", "0");
        Set<String> set = properties.stringPropertyNames();
        for (String arrayList : set) {
            String string = (String)properties.get(arrayList);
            this.properties.put(arrayList, string);
            if (arrayList.equals("cache")) {
                if (string.equals("0") || string.equalsIgnoreCase("F")) {
                    this.cacheType = 0;
                } else if (string.equals("1") || string.equalsIgnoreCase("T") || string.equalsIgnoreCase("TRUE")) {
                    this.cacheType = 1;
                } else if (string.equals("2")) {
                    this.cacheType = 2;
                }
                if (this.cacheType != 0) {
                    UnityDriver.createCache();
                }
                if (!UnityDriver.DEBUG) continue;
                System.out.println("Connection cache type: " + this.cacheType);
                continue;
            }
            if (arrayList.equals("debug")) {
                if (!string.equalsIgnoreCase("T") && !string.equalsIgnoreCase("TRUE")) continue;
                UnityDriver.DEBUG = true;
                continue;
            }
            if (arrayList.equals("autoconnect")) {
                if (!string.equalsIgnoreCase("T") && !string.equalsIgnoreCase("TRUE") && !string.equals("1")) continue;
                this.autoConnect = 1;
                continue;
            }
            if (arrayList.equals("cachetime")) {
                try {
                    int exception = Integer.parseInt(string);
                    this.cache.setExpiryTime(exception);
                    continue;
                }
                catch (Exception exception) {
                    throw new SQLException(UnityDriver.i18n.getString("UnityConnection.InvalidTime") + string + ' ' + UnityDriver.i18n.getString("UnityConnection.CacheTimeMilliSeconds"));
                }
            }
            if (arrayList.equals("sort_buffer_size")) {
                try {
                    this.sortBufferSize = Long.parseLong(string);
                    continue;
                }
                catch (Exception annotatedSourceDatabase) {
                    throw new SQLException(UnityDriver.i18n.getString("UnityConnection.InvalidValue") + string + ' ' + UnityDriver.i18n.getString("UnityConnection.InvalidValueSortBufferSize"));
                }
            }
            if (!arrayList.equals("join_buffer_size")) continue;
            try {
                this.joinBufferSize = Long.parseLong(string);
            }
            catch (Exception exception) {
                throw new SQLException(UnityDriver.i18n.getString("UnityConnection.InvalidValue") + string + ' ' + UnityDriver.i18n.getString("UnityConnection.InvalidValueJoinBufferSize"));
            }
        }
        this.connections = new HashMap();
        if (this.autoConnect == 1) {
            ArrayList arrayList = new ArrayList();
            ArrayList<SourceDatabase> arrayList2 = globalSchema.getAnnotatedDatabases();
            for (int i = 0; i < arrayList2.size(); ++i) {
                AnnotatedSourceDatabase annotatedSourceDatabase = (AnnotatedSourceDatabase)arrayList2.get(i);
                this.getConnection(annotatedSourceDatabase.getDatabaseName());
            }
        }
        this.clientInfo = properties;
        if (this.clientInfo == null) {
            this.clientInfo = new Properties();
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.firstWarning = null;
    }

    @Override
    public void close() throws SQLException {
        this.CLOSED = true;
        --connectionNum;
        if (this.currentStatement != null) {
            this.currentStatement.close();
        }
        this.currentStatement = null;
        String string = "";
        Iterator<Connection> iterator = this.connections.values().iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().close();
            }
            catch (Exception exception) {
                string = string + exception.toString() + " ";
            }
        }
        if (!string.equals("")) {
            throw new SQLException(string);
        }
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new SQLException(UnityDriver.i18n.getString("UnityConnection.ErrorAutoCommit"));
        }
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        this.checkClosed();
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 2);
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement(n, n2, 2);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (n == 1005) {
            throw new SQLException(UnityDriver.i18n.getString("UnityConnection.ErrorNoScrollSensitive"));
        }
        if (n2 == 1008) {
            throw new SQLException(UnityDriver.i18n.getString("UnityConnection.ErrorNoConcurUpdatable"));
        }
        if (this.currentStatement != null) {
            this.currentStatement.close();
        }
        this.currentStatement = new UnityStatement(this, n, n2, this.schema, this.sortBufferSize, this.joinBufferSize);
        return this.currentStatement;
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        this.checkClosed();
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        return this.clientInfo;
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        this.checkClosed();
        return this.clientInfo.getProperty(string);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.rsHoldability;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new UnityDatabaseMetaData(this.schema, this);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.typemap;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.firstWarning;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.CLOSED;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.READONLY;
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException(UnityDriver.i18n.getString("UnityConnection.ErrorInvalidTimeout") + n);
        }
        return !this.CLOSED;
    }

    public boolean isTrial() {
        return UnityDriver.isTrial();
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007, 2);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(string, n, n2, this.getHoldability());
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return new UnityPreparedStatement(this, n, n2, this.schema, string, this.sortBufferSize, this.joinBufferSize);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return new UnityPreparedStatement(this, 1003, 1007, this.schema, string, this.sortBufferSize, this.joinBufferSize);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new SQLException(UnityDriver.i18n.getString("UnityConnection.ErrorAutoCommit"));
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.autoCommit = bl;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.rsHoldability = n;
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.READONLY = bl;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        return null;
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.typemap = map;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw new SQLException(UnityDriver.i18n.getString("UnityConnection.ErrorNullExecutorAbort"));
        }
        this.close();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public void setSchema(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    public void initCache(Cache cache) {
        this.cache = cache;
    }

    public void addCache(GlobalQuery globalQuery, byte[][] byArray, int n, boolean bl) throws SQLException {
    }

    public CacheEntry getCache(String string) throws SQLException {
        LimitInfo limitInfo = LimitInfo.parse(string);
        if (limitInfo.hasLimit) {
            int n;
            CacheEntry cacheEntry;
            if (UnityDriver.DEBUG) {
                System.out.println("Searching cache for: " + string);
            }
            if ((cacheEntry = this.cache.get(string)) != null) {
                n = limitInfo.startRow;
                int n2 = limitInfo.startRow + limitInfo.rowCount;
                if (cacheEntry.getStartTupleNum() <= n && cacheEntry.getLastTupleNum() >= n2) {
                    CacheEntry cacheEntry2 = new CacheEntry(cacheEntry, n, n2);
                    return cacheEntry2;
                }
            }
            n = string.toUpperCase().lastIndexOf("LIMIT");
            String string2 = "L" + string.substring(0, n).trim();
            if (UnityDriver.DEBUG) {
                System.out.println("Searching cache for: " + string2);
            }
            if ((cacheEntry = this.cache.get(string2)) != null) {
                int n3 = limitInfo.startRow;
                int n4 = limitInfo.startRow + limitInfo.rowCount;
                if (cacheEntry.getStartTupleNum() <= n3 && cacheEntry.getLastTupleNum() >= n4) {
                    CacheEntry cacheEntry3 = new CacheEntry(cacheEntry, n3, n4);
                    return cacheEntry3;
                }
            }
        } else {
            CacheEntry cacheEntry;
            if (UnityDriver.DEBUG) {
                System.out.println("Searching cache for: " + string);
            }
            if ((cacheEntry = this.cache.get(string)) != null) {
                return cacheEntry;
            }
        }
        return null;
    }

    public int getCacheRowLimit() {
        return this.cacheRowLimit;
    }

    public void setCacheRowLimit(int n) {
        this.cacheRowLimit = n;
    }

    public int getCachePostfetch() {
        return this.cachePostfetch;
    }

    public void setCachePostfetch(int n) {
        this.cachePostfetch = n;
    }

    public void setCacheExpiryTime(int n) {
        this.cache.setExpiryTime(n);
    }

    public int getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(int n) {
        this.cacheType = n;
    }

    protected void checkClosed() throws SQLException {
        if (this.CLOSED) {
            throw new SQLException(UnityDriver.i18n.getString("UnityConnection.ErrorConnectionClosed"));
        }
    }

    public ArrayList<SourceDatabase> getDatabases() {
        return this.schema.getAnnotatedDatabases();
    }

    public SourceDatabase getDatabase(String string) {
        return this.schema.getDB(string);
    }

    public GlobalSchema getGlobalSchema() {
        return this.schema;
    }

    public void setGlobalSchema(GlobalSchema globalSchema) {
        this.schema = globalSchema;
    }

    public void setConnection(String string, Connection connection) {
        this.connections.put(string, connection);
    }

    public Connection getConnection(String string) throws SQLException {
        Object object;
        Connection connection = this.connections.get(string);
        boolean bl = false;
        if (connection != null) {
            try {
                object = connection.createStatement();
                String string2 = "SELECT 1";
                AnnotatedSourceDatabase annotatedSourceDatabase = this.schema.getDB(string);
                if (annotatedSourceDatabase.getDatabaseProductName().toLowerCase().contains("oracle")) {
                    string2 = "SELECT 1 FROM dual";
                }
                object.executeQuery(string2);
                object.close();
                bl = true;
            }
            catch (Exception exception) {
                try {
                    connection.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        if (connection == null || !bl) {
            if (UnityDriver.DEBUG) {
                System.out.println("Getting connection for database: " + string);
            }
            if ((object = this.schema.getDB(string)) == null) {
                throw new SQLException(UnityDriver.i18n.getString("UnityConnection.ErrorGetConnectionUnknownDB") + string);
            }
            try {
                Class.forName(((SourceDatabase)object).getJavaDriverClassName()).newInstance();
            }
            catch (Exception exception) {
                throw new SQLException(UnityDriver.i18n.getString("UnityConnection.ConnectionError") + exception.toString());
            }
            connection = DriverManager.getConnection(((SourceDatabase)object).getURL(), ((SourceDatabase)object).getUserId(), ((SourceDatabase)object).getPassword());
            if (!((SourceDatabase)object).getJavaDriverClassName().contains("BigSQLDriver")) {
                this.connections.put(((SourceDatabase)object).getDatabaseName(), connection);
            }
        }
        return connection;
    }

    public String getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(string);
    }

    public void setProperty(String string, String string2) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(string, string2);
    }
}

