/*
 * Decompiled with CFR 0.152.
 */
package unity.generic.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.ResourceBundle;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.util.StringFunc;

public class ResultSetMetaDataImpl
implements ResultSetMetaData {
    protected static final Locale locale = Locale.getDefault();
    protected static ResourceBundle resources = ResourceBundle.getBundle("resources/generic/ResultSetMetaDataImpl", locale);
    protected String[] columnHeaders;
    protected Relation relation;

    public ResultSetMetaDataImpl(Relation relation) throws SQLException {
        if (relation == null || relation.getNumAttributes() == 0) {
            Attribute[] attributeArray = new Attribute[]{new Attribute("CollectionDoesNotExist_OR_EmptyCollection", 12, 0)};
            this.relation = new Relation(attributeArray);
        } else {
            this.relation = relation;
        }
        this.columnHeaders = new String[this.relation.getNumAttributes()];
        for (int i = 0; i < this.relation.getNumAttributes(); ++i) {
            this.columnHeaders[i] = this.relation.getAttribute(i).getName();
        }
    }

    public String[] getColumnHeaders() {
        return this.columnHeaders;
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        return "";
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        throw new SQLException(resources.getString("featureError"));
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnHeaders.length;
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        return this.relation.getAttribute(n - 1).getLength();
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        return this.columnHeaders[n - 1];
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        return StringFunc.undelimitName(this.columnHeaders[n - 1], '\"');
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        return this.relation.getAttribute(n - 1).getType();
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        return Attribute.getTypeName(this.relation.getAttribute(n - 1).getType());
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        return 2;
    }

    @Override
    public int getScale(int n) throws SQLException {
        return 0;
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        return "";
    }

    @Override
    public String getTableName(int n) throws SQLException {
        return "";
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        throw new SQLException(resources.getString("featureError"));
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        return 2;
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        throw new SQLException(resources.getString("featureError"));
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }
}

