/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;
import unity.jdbc.UnityDriver;

public class Minus
extends Expression {
    private static final long serialVersionUID = 1L;

    public Minus(Expression expression, Expression expression2) throws SQLException {
        this.children = new ArrayList(2);
        this.children.add(expression);
        this.children.add(expression2);
        int n = expression.getReturnType();
        int n2 = expression2.getReturnType();
        boolean bl = Attribute.isDoubleType(n);
        boolean bl2 = Attribute.isDoubleType(n2);
        boolean bl3 = Attribute.isStringType(n);
        boolean bl4 = Attribute.isStringType(n2);
        if (bl3 || bl4) {
            throw new SQLException(UnityDriver.i18n.getString("Minus.StringSubtractError") + expression.toString() + ", " + expression2.toString());
        }
        this.returnType = bl || bl2 ? 8 : (n == 3 || n2 == 3 ? 3 : 4);
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        Expression expression = (Expression)this.children.get(0);
        Expression expression2 = (Expression)this.children.get(1);
        Object object = expression.evaluate(tuple);
        if (object == null) {
            return null;
        }
        Object object2 = expression2.evaluate(tuple);
        if (object2 == null) {
            return null;
        }
        Object object3 = object;
        Object object4 = object2;
        Number number = null;
        if (this.returnType == 4) {
            int n = ((Number)object3).intValue();
            int n2 = ((Number)object4).intValue();
            number = new Integer(n - n2);
        } else if (this.returnType == 8) {
            double d = ((Number)object3).doubleValue();
            double d2 = ((Number)object4).doubleValue();
            number = new Double(d - d2);
        } else if (this.returnType == 3) {
            BigDecimal bigDecimal = new BigDecimal(object3.toString());
            BigDecimal bigDecimal2 = new BigDecimal(object4.toString());
            number = bigDecimal.subtract(bigDecimal2);
        }
        return number;
    }

    @Override
    public String toString(Relation relation) {
        return ((Expression)this.children.get(0)).toString(relation) + " - " + ((Expression)this.children.get(1)).toString(relation);
    }
}

