/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;

public class F_Dayname
extends Expression {
    private static final long serialVersionUID = 1L;
    private Expression dateExpr;

    public F_Dayname(Expression expression) {
        this.dateExpr = expression;
        this.returnType = this.getReturnType();
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        Object object = this.dateExpr.evaluate(tuple);
        if (object == null) {
            return null;
        }
        if (object instanceof java.sql.Date || object instanceof Date) {
            Date date = (Date)object;
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            return gregorianCalendar.getDisplayName(7, 2, Locale.US);
        }
        return null;
    }

    @Override
    public int getReturnType() {
        return 12;
    }

    public static int[] getParamListTypes() {
        return new int[]{91};
    }

    public static String getFunctionName() {
        return "DAYNAME";
    }

    @Override
    public String toString(Relation relation) {
        return "DAYNAME(" + this.dateExpr.toString(relation) + ")";
    }
}

