/*
 * Decompiled with CFR 0.152.
 */
package unity.cache;

import java.util.ArrayList;
import unity.engine.Tuple;

public class CacheEntry {
    private String key;
    private long expiryTime;
    private Object query;
    private ArrayList<Tuple> tuples;
    private int startTupleNum;
    private int lastTupleNum;

    public CacheEntry(String string, long l) {
        this.key = string;
        this.expiryTime = l;
    }

    public CacheEntry(CacheEntry cacheEntry, int n, int n2) {
        this.key = cacheEntry.key;
        this.expiryTime = cacheEntry.expiryTime;
        this.query = cacheEntry.query;
        this.tuples = new ArrayList(n2 - n + 1);
        for (int i = n - this.startTupleNum; i < cacheEntry.tuples.size() && i < n2; ++i) {
            this.tuples.add(cacheEntry.tuples.get(i));
        }
    }

    public CacheEntry(CacheEntry cacheEntry) {
        this.key = cacheEntry.key;
        this.expiryTime = cacheEntry.expiryTime;
        this.startTupleNum = cacheEntry.startTupleNum;
        this.lastTupleNum = cacheEntry.lastTupleNum;
        this.query = cacheEntry.query;
        this.tuples = new ArrayList(cacheEntry.tuples.size());
        this.tuples.addAll(cacheEntry.tuples);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(long l) {
        this.expiryTime = l;
    }

    public Object getQuery() {
        return this.query;
    }

    public void setQuery(Object object) {
        this.query = object;
    }

    public ArrayList<Tuple> getTuples() {
        return this.tuples;
    }

    public void setTuples(ArrayList<Tuple> arrayList) {
        this.tuples = arrayList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("Key: " + this.key);
        stringBuffer.append(" Query: " + this.query);
        stringBuffer.append(" Tuple count: " + this.tuples.size() + " Start row: " + this.startTupleNum + " Last row: " + this.lastTupleNum);
        stringBuffer.append(" Tuples: ");
        for (int i = 0; i < this.tuples.size(); ++i) {
            stringBuffer.append(this.tuples.get(i).toString());
        }
        return stringBuffer.toString();
    }

    public int getStartTupleNum() {
        return this.startTupleNum;
    }

    public void setStartTupleNum(int n) {
        this.startTupleNum = n;
    }

    public int getLastTupleNum() {
        return this.lastTupleNum;
    }

    public void setLastTupleNum(int n) {
        this.lastTupleNum = n;
    }
}

