/*
 * Decompiled with CFR 0.152.
 */
package pig.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import pig.query.PigOperation;

public class PigQuery {
    private ArrayList<PigOperation> statements;
    private String outputPath;

    public PigQuery(ArrayList<PigOperation> arrayList) {
        this.statements = arrayList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(1000);
        if (this.statements != null) {
            for (PigOperation pigOperation : this.statements) {
                stringBuilder.append(pigOperation.toString());
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public void execute() throws SQLException {
        System.out.println("Executing Pig Query script");
        Properties properties = new Properties();
        properties.put("fs.default.name", "hdfs://gpu1.ddl.ok.ubc.ca");
        properties.put("mapred.job.tracker", "gpu1.ddl.ok.ubc.ca:9001");
        try {
            PigServer pigServer = new PigServer(ExecType.MAPREDUCE, properties);
            Date date = new Date();
            this.outputPath = "/tmp/pig_" + date.getTime();
            pigServer.deleteFile(this.outputPath);
            String string = "";
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.statements.size(); ++i) {
                stringBuilder.append(this.statements.get(i));
                stringBuilder.append("\n");
                string = this.statements.get(i).getAlias();
            }
            pigServer.registerQuery(stringBuilder.toString());
            pigServer.store(string, this.outputPath);
            pigServer.shutdown();
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    public void close() throws SQLException {
        Properties properties = new Properties();
        properties.put("fs.default.name", "hdfs://gpu1.ddl.ok.ubc.ca");
        properties.put("mapred.job.tracker", "gpu1.ddl.ok.ubc.ca:9001");
        try {
            PigServer pigServer = new PigServer(ExecType.MAPREDUCE, properties);
            pigServer.deleteFile(this.outputPath);
            pigServer.shutdown();
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    public String getOutputPath() {
        return this.outputPath;
    }
}

