/*
 * Decompiled with CFR 0.152.
 */
package pig.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;
import pig.conn.ServerConnection;
import pig.jdbc.PigConnection;
import pig.query.PigQuery;
import unity.engine.IServerConnection;
import unity.generic.jdbc.StatementImpl;
import unity.query.LimitInfo;
import unity.util.StringFunc;

public class PigStatement
extends StatementImpl {
    private PigQuery query;

    public PigStatement(PigConnection pigConnection, IServerConnection iServerConnection, int n, int n2) {
        super(pigConnection, iServerConnection, n, n2);
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        if (this._results != null) {
            this._results.close();
        }
        this.queryActive = false;
        this._results = null;
        this.query = null;
        if (this._maxRows > 0) {
            LimitInfo limitInfo = LimitInfo.parse(string);
            limitInfo.rowCount = limitInfo.hasLimit ? Math.min(limitInfo.rowCount, this._maxRows) : this._maxRows;
            limitInfo.hasLimit = true;
            string = StringFunc.replaceLimit(string, limitInfo);
        }
        this._results = ((ServerConnection)this.con).executeQuery(string, this._resultSetType, this);
        this.queryActive = true;
        return this._results;
    }

    public String getOutputPath() {
        if (this.query != null) {
            return this.query.getOutputPath();
        }
        return "";
    }

    public String getQueryString() {
        if (this.query == null) {
            return "";
        }
        try {
            return this.query.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void setQuery(PigQuery pigQuery) {
        this.query = pigQuery;
    }

    static {
        resources = ResourceBundle.getBundle("resources/pig/PigStatement", locale);
    }
}

