/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.wikiTableConfiguration;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.IWikiTableConfiguration;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.IWikiTableConfigurationFactory;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.WikiTableConfigurationFactory;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.WikiTableConfigurationStorage;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.plugins.wikiTableConfiguration.configurations.JIRAConfluenceTableConfiguration;
import net.sourceforge.squirrel_sql.plugins.wikiTableConfiguration.configurations.MediaWikiTableConfiguration;
import net.sourceforge.squirrel_sql.plugins.wikiTableConfiguration.configurations.TiddlyWikiTableConfiguration;

public class WikiTableConfigurationPlugin
extends DefaultSessionPlugin {
    private static final String BUILD_IN_CONFIGURATIONS_XML = "buildInConfigurations.xml";
    private static final ILogger log = LoggerController.createLogger(WikiTableConfigurationPlugin.class);
    private FileWrapper _userSettingsFolder;
    private IWikiTableConfigurationFactory wikiTableConfigFactory;

    public PluginSessionCallback sessionStarted(ISession session) {
        return null;
    }

    public String getInternalName() {
        return "wiki tables";
    }

    public String getDescriptiveName() {
        return "Configurations for exporting the result table as a WIKI table";
    }

    public String getAuthor() {
        return "Stefan Willinger";
    }

    public String getContributors() {
        return "Thomas Hackel";
    }

    public String getVersion() {
        return "0.2";
    }

    public void load(IApplication app) throws PluginException {
        super.load(app);
        this.wikiTableConfigFactory = app.getWikiTableConfigFactory();
    }

    private void addBuildInConfigs() {
        this.wikiTableConfigFactory.addBuilInConfiguration((IWikiTableConfiguration)new MediaWikiTableConfiguration());
        this.wikiTableConfigFactory.addBuilInConfiguration((IWikiTableConfiguration)new TiddlyWikiTableConfiguration());
        this.wikiTableConfigFactory.addBuilInConfiguration((IWikiTableConfiguration)new JIRAConfluenceTableConfiguration());
    }

    public synchronized void initialize() throws PluginException {
        super.initialize();
        try {
            this._userSettingsFolder = this.getPluginUserSettingsFolder();
        }
        catch (IOException ex) {
            throw new PluginException((Exception)ex);
        }
        this.addBuildInConfigs();
        this.loadPrefs();
    }

    private void loadPrefs() {
        try {
            XMLBeanReader doc = new XMLBeanReader();
            FileWrapper file = this.fileWrapperFactory.create(this._userSettingsFolder, BUILD_IN_CONFIGURATIONS_XML);
            doc.load(file, ((Object)((Object)this)).getClass().getClassLoader());
            Iterator it = doc.iterator();
            if (it.hasNext()) {
                WikiTableConfigurationStorage data = (WikiTableConfigurationStorage)it.next();
                List savedBuildIn = data.configurationsAsList();
                List currentBuildIn = this.wikiTableConfigFactory.getBuildInConfigurations();
                List mergedBuildInConfigs = WikiTableConfigurationFactory.merge((List)savedBuildIn, (List)currentBuildIn);
                this.wikiTableConfigFactory.replaceBuilInConfiguration(mergedBuildInConfigs);
            }
        }
        catch (FileNotFoundException doc) {
        }
        catch (Exception ex) {
            String msg = "Error occurred reading from preferences file: buildInConfigurations.xml";
            log.error((Object)"Error occurred reading from preferences file: buildInConfigurations.xml", (Throwable)ex);
        }
    }

    private void savePrefs() {
        try {
            WikiTableConfigurationStorage storage = new WikiTableConfigurationStorage(this.wikiTableConfigFactory.getBuildInConfigurations());
            XMLBeanWriter wtr = new XMLBeanWriter((Object)storage);
            wtr.save(this.fileWrapperFactory.create(this._userSettingsFolder, BUILD_IN_CONFIGURATIONS_XML));
        }
        catch (Exception ex) {
            String msg = "Error occurred writing to preferences file: buildInConfigurations.xml";
            log.error((Object)"Error occurred writing to preferences file: buildInConfigurations.xml", (Throwable)ex);
        }
    }

    public void unload() {
        this.savePrefs();
        super.unload();
    }
}

