/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mysql.action;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.util.BaseException;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.mysql.MysqlPlugin;

class CreateMysqlTableScriptCommand
implements ICommand {
    private static final ILogger s_log = LoggerController.createLogger(CreateMysqlTableScriptCommand.class);
    private ISession _session;
    private final MysqlPlugin _plugin;

    public CreateMysqlTableScriptCommand(ISession session, MysqlPlugin plugin) {
        this._session = session;
        this._plugin = plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BaseException {
        ISQLConnection conn = this._session.getSQLConnection();
        StringBuffer buf = new StringBuffer(2048);
        String sep = " " + this._session.getQueryTokenizer().getSQLStatementSeparator();
        try {
            Statement stmt = conn.createStatement();
            try {
                IObjectTreeAPI api = this._session.getSessionInternalFrame().getObjectTreeAPI();
                IDatabaseObjectInfo[] dbObjs = api.getSelectedDatabaseObjects();
                for (int i = 0; i < dbObjs.length; ++i) {
                    try (ResultSet rs = stmt.executeQuery("show create table " + dbObjs[i].getQualifiedName());){
                        if (!rs.next()) continue;
                        buf.append(rs.getString(2)).append(sep).append('\n');
                        continue;
                    }
                }
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Exception ex) {
                    s_log.error((Object)"Error occurred closing PreparedStatement", (Throwable)ex);
                }
            }
            this._session.getSessionInternalFrame().getMainSQLPanelAPI().appendSQLScript(buf.toString(), true);
            this._session.selectMainTab(1);
        }
        catch (SQLException ex) {
            throw new BaseException((Throwable)ex);
        }
    }
}

