/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring;

import javax.swing.Action;
import javax.swing.JMenu;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResources;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.resources.Resources;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.refactoring.SQLPluginResources;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.AddAutoIncrementAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.AddColumnAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.AddForeignKeyAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.AddIndexAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.AddLookupTableAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.AddPrimaryKeyAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.AddSequenceAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.AddUniqueConstraintAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.AddViewAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.DropColumnAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.DropForeignKeyAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.DropIndexTableAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.DropPrimaryKeyAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.DropSelectedTablesAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.DropSequenceAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.DropUniqueConstraintAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.DropViewAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.MergeColumnAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.MergeTableAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.ModifyColumnAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.ModifySequenceAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.RenameTableAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.actions.RenameViewAction;
import net.sourceforge.squirrel_sql.plugins.refactoring.prefs.RefactoringPreferencesManager;
import net.sourceforge.squirrel_sql.plugins.refactoring.prefs.RefactoringPreferencesTab;
import net.sourceforge.squirrel_sql.plugins.refactoring.tab.SupportedRefactoringsTab;

public class RefactoringPlugin
extends DefaultSessionPlugin {
    public static final String BUNDLE_BASE_NAME = "net.sourceforge.squirrel_sql.plugins.refactoring.refactoring";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RefactoringPlugin.class);
    private PluginResources _resources;
    private JMenu _tableNodeMenu;
    private JMenu _tableObjectMenu;
    private JMenu _indexObjectMenu;
    private JMenu _viewNodeMenu;
    private JMenu _viewObjectMenu;
    private JMenu _sequenceNodeMenu;
    private JMenu _sessionNodeMenu;
    private JMenu _sequenceObjectMenu;

    public String getInternalName() {
        return "refactoring";
    }

    public String getDescriptiveName() {
        return "Refactoring Plugin";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getAuthor() {
        return "Rob Manning";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public String getContributors() {
        return "Daniel Regli, Yannick Winiger";
    }

    public IGlobalPreferencesPanel[] getGlobalPreferencePanels() {
        RefactoringPreferencesTab tab = new RefactoringPreferencesTab();
        return new IGlobalPreferencesPanel[]{tab};
    }

    public synchronized void initialize() throws PluginException {
        super.initialize();
        IApplication app = this.getApplication();
        this._resources = new SQLPluginResources(BUNDLE_BASE_NAME, (IPlugin)this);
        ActionCollection coll = app.getActionCollection();
        coll.add((Action)((Object)new AddAutoIncrementAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new AddColumnAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new AddForeignKeyAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new AddIndexAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new AddLookupTableAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new AddPrimaryKeyAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new AddSequenceAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new AddUniqueConstraintAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new AddViewAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new DropForeignKeyAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new DropIndexTableAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new DropPrimaryKeyAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new DropSelectedTablesAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new DropSequenceAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new DropUniqueConstraintAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new DropViewAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new MergeColumnAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new MergeTableAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new ModifyColumnAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new ModifySequenceAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new DropColumnAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new RenameTableAction(app, (Resources)this._resources)));
        coll.add((Action)((Object)new RenameViewAction(app, (Resources)this._resources)));
        RefactoringPreferencesManager.initialize((IPlugin)this);
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public PluginSessionCallback sessionStarted(final ISession session) {
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                RefactoringPlugin.this.addActionsToPopup(session);
            }
        });
        return new PluginSessionCallback(){

            public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
            }

            public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
                RefactoringPlugin.this.addMenusToObjectTree(objectTreeInternalFrame.getObjectTreeAPI());
            }

            public void additionalSQLTabOpened(AdditionalSQLTab additionalSQLTab) {
            }
        };
    }

    private void addActionsToPopup(ISession session) {
        ActionCollection col = this.getApplication().getActionCollection();
        try {
            IObjectTreeAPI _treeAPI = session.getSessionInternalFrame().getObjectTreeAPI();
            _treeAPI.addDetailTab(DatabaseObjectType.SESSION, (IObjectTab)new SupportedRefactoringsTab(session));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._tableNodeMenu = this._resources.createMenu("refactoring");
        this._resources.addToMenu(col.get(AddViewAction.class), this._tableNodeMenu);
        this._tableObjectMenu = this._resources.createMenu("refactoring");
        JMenu tableMenu = new JMenu(IMenuResourceKeys.TABLE);
        this._resources.addToMenu(col.get(RenameTableAction.class), tableMenu);
        this._resources.addToMenu(col.get(MergeTableAction.class), tableMenu);
        this._resources.addToMenu(col.get(DropSelectedTablesAction.class), tableMenu);
        JMenu columnMenu = new JMenu(IMenuResourceKeys.COLUMN);
        this._resources.addToMenu(col.get(AddColumnAction.class), columnMenu);
        this._resources.addToMenu(col.get(ModifyColumnAction.class), columnMenu);
        this._resources.addToMenu(col.get(MergeColumnAction.class), columnMenu);
        this._resources.addToMenu(col.get(DropColumnAction.class), columnMenu);
        JMenu dataQualityMenu = new JMenu(IMenuResourceKeys.DATA_QUALITY);
        this._resources.addToMenu(col.get(AddLookupTableAction.class), dataQualityMenu);
        this._resources.addToMenu(col.get(AddAutoIncrementAction.class), dataQualityMenu);
        this._resources.addToMenu(col.get(AddUniqueConstraintAction.class), dataQualityMenu);
        this._resources.addToMenu(col.get(DropUniqueConstraintAction.class), dataQualityMenu);
        JMenu referentialMenu = new JMenu(IMenuResourceKeys.REFERENTIAL_INTEGRITY);
        this._resources.addToMenu(col.get(AddPrimaryKeyAction.class), referentialMenu);
        this._resources.addToMenu(col.get(AddForeignKeyAction.class), referentialMenu);
        this._resources.addToMenu(col.get(DropPrimaryKeyAction.class), referentialMenu);
        this._resources.addToMenu(col.get(DropForeignKeyAction.class), referentialMenu);
        JMenu tableIndexMenu = new JMenu(IMenuResourceKeys.INDEX);
        this._resources.addToMenu(col.get(AddIndexAction.class), tableIndexMenu);
        this._resources.addToMenu(col.get(DropIndexTableAction.class), tableIndexMenu);
        this._tableObjectMenu.add(tableMenu);
        this._tableObjectMenu.add(columnMenu);
        this._tableObjectMenu.add(tableIndexMenu);
        this._tableObjectMenu.add(dataQualityMenu);
        this._tableObjectMenu.add(referentialMenu);
        this._indexObjectMenu = this._resources.createMenu("refactoring");
        this._resources.addToMenu(col.get(DropIndexTableAction.class), this._indexObjectMenu);
        this._viewNodeMenu = this._resources.createMenu("refactoring");
        this._resources.addToMenu(col.get(AddViewAction.class), this._viewNodeMenu);
        this._viewObjectMenu = this._resources.createMenu("refactoring");
        this._resources.addToMenu(col.get(DropViewAction.class), this._viewObjectMenu);
        this._resources.addToMenu(col.get(RenameViewAction.class), this._viewObjectMenu);
        this._sequenceNodeMenu = this._resources.createMenu("refactoring");
        this._resources.addToMenu(col.get(AddSequenceAction.class), this._sequenceNodeMenu);
        this._sequenceObjectMenu = this._resources.createMenu("refactoring");
        this._resources.addToMenu(col.get(DropSequenceAction.class), this._sequenceObjectMenu);
        this._resources.addToMenu(col.get(ModifySequenceAction.class), this._sequenceObjectMenu);
        this._sessionNodeMenu = this._resources.createMenu("refactoring");
        this._resources.addToMenu(col.get(AddSequenceAction.class), this._sessionNodeMenu);
        this.addMenusToObjectTree(session.getObjectTreeAPIOfActiveSessionWindow());
    }

    private void addMenusToObjectTree(IObjectTreeAPI api) {
        api.addToPopup(DatabaseObjectType.TABLE_TYPE_DBO, this._tableNodeMenu);
        api.addToPopup(DatabaseObjectType.TABLE, this._tableObjectMenu);
        api.addToPopup(DatabaseObjectType.INDEX, this._indexObjectMenu);
        api.addToPopup(DatabaseObjectType.VIEW, this._viewObjectMenu);
        api.addToPopup(DatabaseObjectType.SEQUENCE_TYPE_DBO, this._sequenceNodeMenu);
        api.addToPopup(DatabaseObjectType.SEQUENCE, this._sequenceObjectMenu);
        if (this._sessionNodeMenu != null) {
            api.addToPopup(DatabaseObjectType.SESSION, this._sessionNodeMenu);
        }
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface IMenuResourceKeys {
        public static final String REFACTORING = "refactoring";
        public static final String TABLE = RefactoringPlugin.access$000().getString("RefactoringPlugin.tableMenuItemLabel");
        public static final String COLUMN = RefactoringPlugin.access$000().getString("RefactoringPlugin.columnMenuItemLabel");
        public static final String INDEX = RefactoringPlugin.access$000().getString("RefactoringPlugin.indexMenuItemLabel");
        public static final String DATA_QUALITY = RefactoringPlugin.access$000().getString("RefactoringPlugin.dataQualityMenuItemLabel");
        public static final String REFERENTIAL_INTEGRITY = RefactoringPlugin.access$000().getString("RefactoringPlugin.referentialIntegrityMenuItemLabel");
    }
}

