/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates;

import java.awt.Color;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.DuplicateConsecutiveRowsHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.DuplicateConsecutiveValuesInColumnsHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.DuplicateHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.DuplicateRowsHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.DuplicateValuesInColumnsHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.MarkDuplicatesMode;

public class MarkDuplicatesHandler {
    private ArrayList<DuplicateHandler> _duplicateHandlers = new ArrayList();
    private DataSetViewerTable _dataSetViewerTable;
    private DuplicateHandler _currentDuplicateHandler;

    public MarkDuplicatesHandler(DataSetViewerTable dataSetViewerTable) {
        this._dataSetViewerTable = dataSetViewerTable;
        this._duplicateHandlers.add(new DuplicateValuesInColumnsHandler(this._dataSetViewerTable));
        this._duplicateHandlers.add(new DuplicateConsecutiveValuesInColumnsHandler(this._dataSetViewerTable));
        this._duplicateHandlers.add(new DuplicateRowsHandler(this._dataSetViewerTable));
        this._duplicateHandlers.add(new DuplicateConsecutiveRowsHandler(this._dataSetViewerTable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDuplicates(MarkDuplicatesMode mode) {
        try {
            if (null == mode) {
                this._duplicateHandlers.forEach(dh -> dh.markDuplicates(false));
                this._currentDuplicateHandler = null;
                return;
            }
            for (DuplicateHandler duplicateHandler : this._duplicateHandlers) {
                if (duplicateHandler.getMode() == mode) {
                    this._currentDuplicateHandler = duplicateHandler;
                    this._currentDuplicateHandler.markDuplicates(true);
                    continue;
                }
                duplicateHandler.markDuplicates(false);
            }
        }
        finally {
            this._dataSetViewerTable.repaint();
        }
    }

    public Color getBackgroundForCell(int row, int column, Object value) {
        if (null == this._currentDuplicateHandler) {
            return null;
        }
        int columnModelIndex = this._dataSetViewerTable.getColumnModel().getColumn(column).getModelIndex();
        if (-42 == columnModelIndex) {
            return null;
        }
        return this._currentDuplicateHandler.getBackgroundForCell(row, column, value);
    }

    public MarkDuplicatesMode getMarkDuplicatesMode() {
        if (null == this._currentDuplicateHandler) {
            return null;
        }
        return this._currentDuplicateHandler.getMode();
    }
}

