/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.sourceforge.squirrel_sql.client.session.DataModelImplementationDetails;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.RowDataInputFrame;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.gui.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.gui.TablePopupMenu;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DataSetViewerEditableTablePanel
extends DataSetViewerTablePanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataSetViewerEditableTablePanel.class);
    TablePopupMenu cellPopupMenu = null;

    @Override
    public void init(IDataSetUpdateableModel updateableModel, DataModelImplementationDetails dataModelImplementationDetails, ISession session) {
        super.init(updateableModel, dataModelImplementationDetails, session);
        this.setUpdateableModelReference(updateableModel);
    }

    @Override
    public boolean isTableEditable() {
        return true;
    }

    @Override
    public boolean isColumnEditable(int col, Object originalValue) {
        if (this.getColDefs() == null) {
            return false;
        }
        if (-42 == col) {
            return false;
        }
        if (((IDataSetUpdateableTableModel)this.getUpdateableModel()).getRowidCol() == col) {
            return false;
        }
        return CellComponentFactory.isEditableInCell(this.getColDefs()[col], originalValue);
    }

    @Override
    public void setCellEditors(DataSetViewerTable table) {
        this.cellPopupMenu = new TablePopupMenu(this.getUpdateableModel(), this, table);
        for (int i = 0; i < this.getColDefs().length; ++i) {
            DefaultCellEditor editor = CellComponentFactory.getInCellEditor(table, this.getColDefs()[i]);
            editor.getComponent().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        DataSetViewerEditableTablePanel.this.cellPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        DataSetViewerEditableTablePanel.this.cellPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                }
            });
            this.getColumnForModelIndex(i, table.getColumnModel()).setCellEditor(editor);
        }
    }

    private TableColumn getColumnForModelIndex(int modelIndex, TableColumnModel columnModel) {
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            if (columnModel.getColumn(i).getModelIndex() != modelIndex) continue;
            return columnModel.getColumn(i);
        }
        throw new IllegalArgumentException("No column for model index " + modelIndex);
    }

    @Override
    public int[] changeUnderlyingValueAt(int row, int col, Object newValue, Object oldValue) {
        int option;
        String message = null;
        if (this.getUpdateableModelReference() == null) {
            return new int[0];
        }
        if (newValue == oldValue) {
            return new int[0];
        }
        if (oldValue != null && newValue != null && CellComponentFactory.areEqual(this.getColDefs()[col], oldValue, newValue)) {
            return new int[0];
        }
        if (this.getUpdateableModelReference() != null) {
            message = ((IDataSetUpdateableTableModel)this.getUpdateableModelReference()).getWarningOnCurrentData(this.getRow(row), this.getColDefs(), col, oldValue);
        }
        if (message != null && (option = JOptionPane.showConfirmDialog(SwingUtilities.windowForComponent(this.getComponent()), message, s_stringMgr.getString("baseDataSetViewerDestination.warning"), 0, 2)) != 0) {
            return new int[0];
        }
        if (this.getUpdateableModelReference() != null) {
            message = ((IDataSetUpdateableTableModel)this.getUpdateableModelReference()).getWarningOnProjectedUpdate(this.getRow(row), this.getColDefs(), col, newValue);
        }
        if (message != null && (option = JOptionPane.showConfirmDialog(SwingUtilities.windowForComponent(this.getComponent()), message, s_stringMgr.getString("baseDataSetViewerDestination.warning2"), 0, 2)) != 0) {
            return new int[0];
        }
        message = ((IDataSetUpdateableTableModel)this.getUpdateableModelReference()).updateTableComponent(this.getRow(row), this.getColDefs(), col, oldValue, newValue);
        if (message != null) {
            JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this.getComponent()), message, s_stringMgr.getString("baseDataSetViewerDestination.error"), 0);
            return new int[0];
        }
        ArrayList<Integer> buf = new ArrayList<Integer>();
        for (int i = 0; i < this.getColDefs().length; ++i) {
            if (!this.getColDefs()[i].getFullTableColumnName().equalsIgnoreCase(this.getColDefs()[col].getFullTableColumnName())) continue;
            buf.add(i);
        }
        int[] ret = new int[buf.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Integer)buf.get(i);
        }
        return ret;
    }

    @Override
    public void deleteRows(int[] rows) {
        if (rows.length == 0) {
            JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this.getComponent()), s_stringMgr.getString("dataSetViewerEditableTablePanel.selectionNeeded"));
            return;
        }
        String msg = s_stringMgr.getString("dataSetViewerEditableTablePanel.deleteRosQuestion", rows.length);
        int option = JOptionPane.showConfirmDialog(SwingUtilities.windowForComponent(this.getComponent()), msg, s_stringMgr.getString("dataSetViewerEditableTablePanel.warning"), 0, 2);
        if (option != 0) {
            return;
        }
        if (this.getCurrentCellEditor() != null) {
            this.getCurrentCellEditor().cancelCellEditing();
            this.setCurrentCellEditor(null);
        }
        SortableTableModel tableModel = (SortableTableModel)((JTable)this.getComponent()).getModel();
        Object[][] rowData = new Object[rows.length][this.getColDefs().length];
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < this.getColDefs().length; ++j) {
                rowData[i][j] = tableModel.getValueAt(rows[i], j);
            }
        }
        String message = ((IDataSetUpdateableTableModel)this.getUpdateableModel()).deleteRows(rowData, this.getColDefs());
        if (message != null) {
            JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this.getComponent()), s_stringMgr.getString("dataSetViewerEditableTablePanel.noRowsDeleted", message), s_stringMgr.getString("dataSetViewerEditableTablePanel.error"), 0);
            return;
        }
        DataSetViewerTable myJTable = (DataSetViewerTable)this.getComponent();
        ((SortableTableModel)myJTable.getModel()).deleteRows(rows);
        myJTable.clearSelection();
        myJTable.invalidate();
        myJTable.repaint();
    }

    @Override
    public void insertRow() {
        JTable table = (JTable)this.getComponent();
        Point pt = new Point(10, 200);
        Component comp = SwingUtilities.getRoot(table);
        String[] dbDefaultValues = ((IDataSetUpdateableTableModel)this.getUpdateableModelReference()).getDefaultValues(this.getColDefs());
        Object[] initialValues = new Object[dbDefaultValues.length];
        for (int i = 0; i < initialValues.length; ++i) {
            initialValues[i] = CellComponentFactory.getDefaultValue(this.getColDefs()[i], dbDefaultValues[i]);
        }
        RowDataInputFrame rdif = new RowDataInputFrame(table, this.getColDefs(), initialValues, this);
        rdif.pack();
        Dimension dim = rdif.getSize();
        boolean dimChanged = false;
        if (dim.width < 300) {
            dim.width = 300;
            dimChanged = true;
        }
        if (dimChanged) {
            rdif.setSize(dim);
        }
        int fudgeFactor = 100;
        Rectangle parentBounds = comp.getBounds();
        if (parentBounds.width <= dim.width + fudgeFactor) {
            dim.width = parentBounds.width - fudgeFactor;
            pt.x = fudgeFactor / 2;
            rdif.setSize(dim);
        } else if (pt.x + dim.width + fudgeFactor > parentBounds.width) {
            pt.x -= pt.x + dim.width + fudgeFactor - parentBounds.width;
        }
        rdif.setLocation(pt);
        rdif.setVisible(true);
    }

    protected String insertRow(Object[] values) {
        String message = ((IDataSetUpdateableTableModel)this.getUpdateableModelReference()).insertRow(values, this.getColDefs());
        if (message != null) {
            JOptionPane.showMessageDialog(SwingUtilities.windowForComponent(this.getComponent()), message, s_stringMgr.getString("dataSetViewereditableTablePanel.error2"), 0);
            return "Error";
        }
        SortableTableModel sortedModel = (SortableTableModel)((JTable)this.getComponent()).getModel();
        sortedModel.insertRow(values);
        return null;
    }
}

