/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab;

import java.awt.Component;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.filemanager.IFileEditorAPI;
import net.sourceforge.squirrel_sql.client.session.mainpanel.BaseMainPanelTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanel;

public abstract class BaseSQLTab
extends BaseMainPanelTab {
    private SQLPanel _sqlPanel;

    public BaseSQLTab(ISession session) {
        super.setSession(session);
    }

    @Override
    public Component getComponent() {
        if (null == this._sqlPanel) {
            this._sqlPanel = this.createSqlPanel();
        }
        return this._sqlPanel;
    }

    protected abstract SQLPanel createSqlPanel();

    @Override
    public void setSession(ISession session) {
        super.setSession(session);
        if (null != this._sqlPanel) {
            this._sqlPanel.setSession(session);
        }
    }

    @Override
    public void sessionClosing(ISession session) {
        this._sqlPanel.sessionClosing();
    }

    @Override
    public void select() {
        super.select();
        SwingUtilities.invokeLater(() -> this._sqlPanel.getSQLEntryPanel().requestFocus());
    }

    @Override
    public IFileEditorAPI getActiveFileEditorAPIOrNull() {
        return this.getSQLPanelAPI();
    }

    public SQLPanel getSQLPanel() {
        return this._sqlPanel;
    }

    public ISQLPanelAPI getSQLPanelAPI() {
        return this._sqlPanel.getSQLPanelAPI();
    }
}

