/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab;

import java.awt.Component;
import javax.swing.ImageIcon;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.ButtonTabComponent;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFilePathHandler;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFilePathHandlerUtil;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanelPosition;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTabCounter;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.BaseSQLTab;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class AdditionalSQLTab
extends BaseSQLTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AdditionalSQLTab.class);
    private final int _tabNumber;
    private final ButtonTabComponent _tabComponent;
    private TitleFilePathHandler _titleFileHandler;
    private String _titleWithoutFile;

    public AdditionalSQLTab(ISession session) {
        super(session);
        AdditionalSQLTabCounter additionalSQLTabCounter = (AdditionalSQLTabCounter)session.getSessionLocal(AdditionalSQLTabCounter.class);
        if (null == additionalSQLTabCounter) {
            additionalSQLTabCounter = new AdditionalSQLTabCounter();
            session.putSessionLocal(AdditionalSQLTabCounter.class, additionalSQLTabCounter);
        }
        this._tabNumber = additionalSQLTabCounter.nextNumber();
        this._titleWithoutFile = s_stringMgr.getString("AdditionalSQLTab.title", this._tabNumber);
        ImageIcon icon = Main.getApplication().getResources().getIcon("add_tab");
        this._titleFileHandler = new TitleFilePathHandler(() -> this.setTitle(this._titleWithoutFile));
        this._tabComponent = new ButtonTabComponent(this._titleWithoutFile, icon);
        this._tabComponent.getClosebutton().addActionListener(e -> this.onClose());
        this._tabComponent.getToWindowButton().setVisible(false);
    }

    @Override
    protected SQLPanel createSqlPanel() {
        return new SQLPanel(this.getSession(), SQLPanelPosition.ADDITIONAL_TAB_IN_SESSION_WINDOW, this._titleFileHandler);
    }

    private void setTitle(String title) {
        this._titleWithoutFile = title;
        TitleFilePathHandlerUtil.setTitle(this._titleWithoutFile, this._titleFileHandler, this._tabComponent);
    }

    @Override
    public void mouseWheelClickedOnTab() {
        this._tabComponent.doClickClose();
    }

    @Override
    public Component getTabComponent() {
        return this._tabComponent;
    }

    private void onClose() {
        if (this.getSQLPanel().getSQLPanelAPI().confirmClose()) {
            this.getSession().getSessionPanel().removeMainTab(this);
        }
    }

    @Override
    public String getHint() {
        return s_stringMgr.getString("AdditionalSQLTab.tooltip", this._tabNumber);
    }

    public void displayUnsavedEditsInTabComponent(boolean hasUnsavedEdits) {
        this._titleFileHandler.setUnsavedEdits(hasUnsavedEdits);
    }
}

