/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFilePathHandler;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.action.OpenSqlHistoryAction;
import net.sourceforge.squirrel_sql.client.session.event.ISQLExecutionListener;
import net.sourceforge.squirrel_sql.client.session.event.ISQLPanelListener;
import net.sourceforge.squirrel_sql.client.session.event.ISQLResultExecuterTabListener;
import net.sourceforge.squirrel_sql.client.session.event.SQLExecutionAdapter;
import net.sourceforge.squirrel_sql.client.session.event.SQLPanelEvent;
import net.sourceforge.squirrel_sql.client.session.event.SQLResultExecuterTabEvent;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ISQLResultExecuter;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IUndoHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ReloadSqlContentsHelper;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistoryComboBox;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistoryComboBoxModel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistoryController;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistoryItem;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanelPosition;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLResultExecuterPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SessionStartupMainSQLTabContentLoader;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SqlPanelListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ToggleResultMinimizeHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.UndoHandlerImpl;
import net.sourceforge.squirrel_sql.client.session.mainpanel.multiclipboard.PasteFromHistoryAttach;
import net.sourceforge.squirrel_sql.client.session.properties.ResultLimitAndReadOnPanelSmallPanel;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.gui.FontInfo;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.QueryHolder;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SQLPanel
extends JPanel {
    private static final ILogger s_log = LoggerController.createLogger(SQLPanel.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLPanel.class);
    private static final String LINE_SEPARATOR = "\n";
    private static boolean s_loadedSQLHistory;
    private transient ISession _session;
    private SQLHistoryComboBox _sqlCombo;
    private ISQLEntryPanel _sqlEntry;
    private SqlComboListener _sqlComboListener = new SqlComboListener();
    private MyPropertiesListener _propsListener;
    private JPanel _executerPanleHolder;
    private JTabbedPane _tabbedExecuterPanel;
    private JPanel _simpleExecuterPanel;
    private boolean _hasBeenVisible = false;
    private JSplitPane _splitPane;
    private EventListenerList _listeners = new EventListenerList();
    private final List<ISQLResultExecuter> _executors = new ArrayList<ISQLResultExecuter>();
    private SQLResultExecuterPanel _sqlExecPanel;
    private transient ISQLPanelAPI _panelAPI;
    private static final String PREFS_KEY_SPLIT_DIVIDER_LOC = "squirrelSql_sqlPanel_divider_loc";
    private static final String PREFS_KEY_SPLIT_DIVIDER_LOC_HORIZONTAL = "squirrelSql_sqlPanel_divider_loc_horizontal";
    private SQLExecutorHistoryListener _sqlExecutorHistoryListener = new SQLExecutorHistoryListener();
    private ArrayList<SqlPanelListener> _sqlPanelListeners = new ArrayList();
    private IUndoHandler _undoHandler;
    private ResultLimitAndReadOnPanelSmallPanel _resultLimitAndReadOnPanelSmallPanel = new ResultLimitAndReadOnPanelSmallPanel();
    private ToggleResultMinimizeHandler _toggleResultMinimizeHandler;
    private SQLPanelPosition _sqlPanelPosition;

    public SQLPanel(ISession session, SQLPanelPosition sqlPanelPosition, TitleFilePathHandler titleFileHandler) {
        this._sqlPanelPosition = sqlPanelPosition;
        this.setSession(session);
        this.createGUI();
        this.propertiesHaveChanged(null);
        this._sqlExecPanel = new SQLResultExecuterPanel(session);
        this._sqlExecPanel.addSQLExecutionListener(this._sqlExecutorHistoryListener);
        this.addExecutor(this._sqlExecPanel);
        this._panelAPI = new SQLPanelAPI(this, titleFileHandler);
        this._resultLimitAndReadOnPanelSmallPanel.loadData(session.getProperties());
        this._toggleResultMinimizeHandler = new ToggleResultMinimizeHandler(this._splitPane);
        if (SQLPanelPosition.MAIN_TAB_IN_SESSION_WINDOW == this._sqlPanelPosition) {
            SessionStartupMainSQLTabContentLoader.handleLoadFileAtSessionStart(session, this._panelAPI);
        }
    }

    public synchronized void setSession(ISession session) {
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        this.sessionClosing();
        this._session = session;
        this._propsListener = new MyPropertiesListener();
        this._session.getProperties().addPropertyChangeListener(this._propsListener);
    }

    public ISQLPanelAPI getSQLPanelAPI() {
        return this._panelAPI;
    }

    public synchronized ISession getSession() {
        return this._session;
    }

    public void addExecutor(ISQLResultExecuter exec) {
        this._executors.add(exec);
        if (1 == this._executors.size()) {
            this._executerPanleHolder.remove(this._tabbedExecuterPanel);
            this._executerPanleHolder.add(this._simpleExecuterPanel);
        } else if (2 == this._executors.size()) {
            this._executerPanleHolder.remove(this._simpleExecuterPanel);
            this._executerPanleHolder.add(this._tabbedExecuterPanel);
            this._executors.get(0);
            ISQLResultExecuter buf = this._executors.get(0);
            this._tabbedExecuterPanel.addTab(buf.getTitle(), null, buf.getComponent(), buf.getTitle());
        }
        if (1 < this._executors.size()) {
            this._tabbedExecuterPanel.addTab(exec.getTitle(), null, exec.getComponent(), exec.getTitle());
        } else {
            this._simpleExecuterPanel.add(exec.getComponent());
        }
        this.fireExecuterTabAdded(exec);
    }

    public void removeExecutor(ISQLResultExecuter exec) {
        this._executors.remove(exec);
    }

    public SQLResultExecuterPanel getSQLExecPanel() {
        return this._sqlExecPanel;
    }

    public synchronized void addSQLExecutionListener(ISQLExecutionListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("null ISQLExecutionListener passed");
        }
        this._sqlExecPanel.addSQLExecutionListener(lis);
    }

    public synchronized void removeSQLExecutionListener(ISQLExecutionListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("null ISQLExecutionListener passed");
        }
        this._sqlExecPanel.removeSQLExecutionListener(lis);
    }

    public synchronized void addSQLPanelListener(ISQLPanelListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("null ISQLPanelListener passed");
        }
        this._listeners.add(ISQLPanelListener.class, lis);
    }

    public synchronized void removeSQLPanelListener(ISQLPanelListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("null ISQLPanelListener passed");
        }
        this._listeners.remove(ISQLPanelListener.class, lis);
    }

    public void addExecuterTabListener(ISQLResultExecuterTabListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("ISQLExecutionListener == null");
        }
        this._listeners.add(ISQLResultExecuterTabListener.class, lis);
    }

    public synchronized void removeExecuterTabListener(ISQLResultExecuterTabListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("ISQLResultExecuterTabListener == null");
        }
        this._listeners.remove(ISQLResultExecuterTabListener.class, lis);
    }

    public ISQLEntryPanel getSQLEntryPanel() {
        return this._sqlEntry;
    }

    public void runCurrentExecuter() {
        this._runExecuter(ISQLResultExecuter.ExecutionScope.EXEC_CURRENT_SQL);
    }

    public void runAllSqlsExecuter() {
        this._runExecuter(ISQLResultExecuter.ExecutionScope.EXEC_ALL_SQLS);
    }

    private void _runExecuter(ISQLResultExecuter.ExecutionScope executionScope) {
        if (1 == this._executors.size()) {
            ISQLResultExecuter exec = this._executors.get(0);
            exec.execute(this._sqlEntry, executionScope);
        } else {
            int selectedIndex = this._tabbedExecuterPanel.getSelectedIndex();
            ISQLResultExecuter exec = this._executors.get(selectedIndex);
            exec.execute(this._sqlEntry, executionScope);
        }
    }

    public void sessionClosing() {
        if (this._propsListener == null) {
            return;
        }
        this._session.getProperties().removePropertyChangeListener(this._propsListener);
        this._propsListener = null;
        if (Main.getApplication().getSquirrelPreferences().isReloadSqlContents()) {
            if (SQLPanelPosition.MAIN_TAB_IN_SESSION_WINDOW == this._sqlPanelPosition) {
                String entireSQLScript = this._panelAPI.getEntireSQLScript();
                if (StringUtilities.isEmpty(entireSQLScript, true)) {
                    ReloadSqlContentsHelper.tryDeleteContentsFile(this.getSession().getAlias());
                } else {
                    ReloadSqlContentsHelper.writeLastSqlContent(this.getSession().getAlias(), entireSQLScript);
                }
            }
        } else {
            ReloadSqlContentsHelper.tryDeleteContentsFile(this.getSession().getAlias());
        }
    }

    public void sessionWindowClosing() {
        this.fireSQLEntryAreaClosed();
        if (this._hasBeenVisible) {
            this.saveOrientationDependingDividerLocation();
        }
        this._sqlCombo.removeActionListener(this._sqlComboListener);
        this._sqlCombo.dispose();
        this._sqlExecPanel.removeSQLExecutionListener(this._sqlExecutorHistoryListener);
        for (SqlPanelListener l : this._sqlPanelListeners) {
            l.panelParentWindowClosing();
        }
        this._sqlEntry.dispose();
    }

    private void saveOrientationDependingDividerLocation() {
        int dividerLoc = this._splitPane.getDividerLocation();
        if (this._splitPane.getOrientation() == 0) {
            Props.putInt(PREFS_KEY_SPLIT_DIVIDER_LOC, dividerLoc);
        } else {
            Props.putInt(PREFS_KEY_SPLIT_DIVIDER_LOC_HORIZONTAL, dividerLoc);
        }
    }

    private void installSQLEntryPanel(ISQLEntryPanel pnl) {
        if (pnl == null) {
            throw new IllegalArgumentException("Null ISQLEntryPanel passed");
        }
        this._sqlEntry = pnl;
        int pos = this._splitPane.getDividerLocation();
        JScrollPane scrollPane = this._sqlEntry.createScrollPane(this._sqlEntry.getTextComponent());
        this._splitPane.add((Component)scrollPane, "left");
        this._splitPane.setDividerLocation(pos);
        this._undoHandler = new UndoHandlerImpl(this._session.getApplication(), this._sqlEntry);
        new PasteFromHistoryAttach(this._sqlEntry);
        this.fireSQLEntryAreaInstalled();
    }

    @Override
    public void setVisible(boolean value) {
        super.setVisible(value);
        if (value) {
            this._hasBeenVisible = true;
        }
    }

    public void addSQLToHistory(SQLHistoryItem sql) {
        if (sql == null) {
            throw new IllegalArgumentException("SQLHistoryItem == null");
        }
        this._sqlComboListener.stopListening();
        try {
            this._sqlCombo.removeItem(sql);
            this._sqlCombo.insertItemAt(sql, 0);
            this._sqlCombo.setSelectedIndex(0);
            this._sqlCombo.repaint();
        }
        finally {
            this._sqlComboListener.startListening();
        }
    }

    public void addToSQLEntryAreaMenu(JMenu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("Menu == null");
        }
        this.getSQLEntryPanel().addToSQLEntryAreaMenu(menu);
    }

    public JMenuItem addToSQLEntryAreaMenu(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Action == null");
        }
        return this.getSQLEntryPanel().addToSQLEntryAreaMenu(action);
    }

    public void addSeparatorToSQLEntryAreaMenu() {
        this.getSQLEntryPanel().addSeparatorToSQLEntryAreaMenu();
    }

    private void fireSQLEntryAreaInstalled() {
        Object[] listeners = this._listeners.getListenerList();
        SQLPanelEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISQLPanelListener.class) continue;
            if (evt == null) {
                evt = new SQLPanelEvent(this._session, this);
            }
            ((ISQLPanelListener)listeners[i + 1]).sqlEntryAreaInstalled(evt);
        }
    }

    private void fireSQLEntryAreaClosed() {
        Object[] listeners = this._listeners.getListenerList();
        SQLPanelEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISQLPanelListener.class) continue;
            if (evt == null) {
                evt = new SQLPanelEvent(this._session, this);
            }
            ((ISQLPanelListener)listeners[i + 1]).sqlEntryAreaClosed(evt);
        }
    }

    private void fireExecuterTabAdded(ISQLResultExecuter exec) {
        Object[] listeners = this._listeners.getListenerList();
        SQLResultExecuterTabEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISQLResultExecuterTabListener.class) continue;
            if (evt == null) {
                evt = new SQLResultExecuterTabEvent(this._session, exec);
            }
            ((ISQLResultExecuterTabListener)listeners[i + 1]).executerTabAdded(evt);
        }
    }

    private void fireExecuterTabActivated(ISQLResultExecuter exec) {
        Object[] listeners = this._listeners.getListenerList();
        SQLResultExecuterTabEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ISQLResultExecuterTabListener.class) continue;
            if (evt == null) {
                evt = new SQLResultExecuterTabEvent(this._session, exec);
            }
            ((ISQLResultExecuterTabListener)listeners[i + 1]).executerTabActivated(evt);
        }
    }

    private void appendSQL(String sql) {
        if (this._sqlEntry.getText().length() > 0) {
            this._sqlEntry.appendText("\n\n");
        }
        this._sqlEntry.appendText(sql, true);
        this._sqlEntry.requestFocus();
    }

    private void copySelectedItemToEntryArea() {
        SQLHistoryItem item = (SQLHistoryItem)this._sqlCombo.getSelectedItem();
        if (item != null) {
            this.appendSQL(item.getSQL());
        }
    }

    private void openSQLHistory() {
        new SQLHistoryController(this._session, this.getSQLPanelAPI(), ((SQLHistoryComboBoxModel)this._sqlCombo.getModel()).getItems());
    }

    private void propertiesHaveChanged(String propName) {
        FontInfo fi;
        SessionProperties props = this._session.getProperties();
        if (propName == null || propName.equals("sqlShareHistory")) {
            this._sqlCombo.setUseSharedModel(props.getSQLShareHistory());
        }
        if (propName == null || propName.equals("autoCommit")) {
            SetAutoCommitTask task = new SetAutoCommitTask();
            if (SwingUtilities.isEventDispatchThread()) {
                this._session.getApplication().getThreadPool().addTask(task);
            } else {
                task.run();
            }
        }
        if (propName == null || propName.equals("sqlLimitRows")) {
            this._resultLimitAndReadOnPanelSmallPanel.propsChanged(props);
        }
        if (propName == null || propName.equals("sqlNbrOfRowsToShow")) {
            this._resultLimitAndReadOnPanelSmallPanel.propsChanged(props);
        }
        if (propName == null || propName.equals("sqlReadOn")) {
            this._resultLimitAndReadOnPanelSmallPanel.propsChanged(props);
        }
        if (propName == null || propName.equals("sqlReadOnBlockSize")) {
            this._resultLimitAndReadOnPanelSmallPanel.propsChanged(props);
        }
        if ((propName == null || propName.equals("fontInfo")) && (fi = props.getFontInfo()) != null) {
            this._sqlEntry.setFont(fi.createFont());
        }
        if (propName == null || propName.equals("sqlEntryHistorySize") || propName.equals("limitSqlEntryHistorySize")) {
            if (props.getLimitSQLEntryHistorySize()) {
                this._sqlCombo.setMaxMemoryCount(props.getSQLEntryHistorySize());
            } else {
                this._sqlCombo.setMaxMemoryCount(-1);
            }
        }
    }

    public void addSqlPanelListener(SqlPanelListener sqlPanelListener) {
        this._sqlPanelListeners.add(sqlPanelListener);
    }

    public ArrayList<SQLHistoryItem> getSQLHistoryItems() {
        return ((SQLHistoryComboBoxModel)this._sqlCombo.getModel()).getItems();
    }

    public void toggleMinimizeResults() {
        this._toggleResultMinimizeHandler.toggleMinimizeResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createGUI() {
        IApplication app = this._session.getApplication();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!s_loadedSQLHistory) {
                SQLHistory sqlHistory = app.getSQLHistory();
                SQLHistoryComboBoxModel.initializeSharedInstance(sqlHistory.getData());
                s_loadedSQLHistory = true;
            }
        }
        this._tabbedExecuterPanel = UIFactory.getInstance().createTabbedPane();
        this._tabbedExecuterPanel.addChangeListener(new MyExecuterPaneListener());
        this.setLayout(new BorderLayout());
        SessionProperties props = this._session.getProperties();
        this._sqlCombo = new SQLHistoryComboBox(props.getSQLShareHistory());
        this._sqlCombo.setEditable(false);
        if (this._sqlCombo.getItemCount() > 0) {
            this._sqlCombo.setSelectedIndex(0);
        }
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout());
        pnl.add((Component)this._sqlCombo, "Center");
        Box box = Box.createHorizontalBox();
        box.add(new CopyLastButton(app));
        box.add(new ShowHistoryButton(app));
        box.add(Box.createHorizontalStrut(10));
        box.add(this._resultLimitAndReadOnPanelSmallPanel);
        pnl.add((Component)box, "East");
        this.add((Component)pnl, "North");
        this.createSplitPane();
        this._splitPane.setOneTouchExpandable(true);
        this.installSQLEntryPanel(app.getSQLEntryPanelFactory().createSQLEntryPanel(this._session, new HashMap<String, Object>()));
        this._executerPanleHolder = new JPanel(new GridLayout(1, 1));
        this._executerPanleHolder.setMinimumSize(new Dimension(50, 50));
        this._simpleExecuterPanel = new JPanel(new GridLayout(1, 1));
        this._executerPanleHolder.add(this._simpleExecuterPanel);
        this._splitPane.add((Component)this._executerPanleHolder, "right");
        this.add((Component)this._splitPane, "Center");
        this._sqlCombo.addActionListener(this._sqlComboListener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SQLPanel.this._sqlEntry.getTextComponent().requestFocus();
            }
        });
    }

    private void createSplitPane() {
        int spOrientation = this.getSession().getProperties().getSqlPanelOrientation();
        this._splitPane = new JSplitPane(spOrientation);
        int dividerLoc = this.calculateDividerLocation(spOrientation, false);
        this._splitPane.setDividerLocation(dividerLoc);
        this.getSession().getProperties().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("sqlPanelOrientation".equals(evt.getPropertyName())) {
                    SQLPanel.this.saveOrientationDependingDividerLocation();
                    SQLPanel.this._splitPane.setOrientation((Integer)evt.getNewValue());
                    SQLPanel.this._splitPane.setDividerLocation(SQLPanel.this.calculateDividerLocation(SQLPanel.this._splitPane.getOrientation(), false));
                    SQLPanel.this._splitPane.repaint();
                }
            }
        });
        SplitPaneUI spUI = this._splitPane.getUI();
        if (spUI instanceof BasicSplitPaneUI) {
            BasicSplitPaneUI bspUI = (BasicSplitPaneUI)spUI;
            bspUI.getDivider().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                        SQLPanel.this._splitPane.setDividerLocation(SQLPanel.this.calculateDividerLocation(SQLPanel.this._splitPane.getOrientation(), true));
                    }
                }
            });
        }
    }

    private int calculateDividerLocation(int orientation, boolean useDefault) {
        int dividerLoc;
        Dimension parentDim = this._splitPane.getSize();
        if (orientation == 0) {
            int def = parentDim.height - 200;
            dividerLoc = !useDefault ? Props.getInt(PREFS_KEY_SPLIT_DIVIDER_LOC, def) : def;
        } else {
            int def = parentDim.width / 2;
            dividerLoc = !useDefault ? Props.getInt(PREFS_KEY_SPLIT_DIVIDER_LOC_HORIZONTAL, def) : def;
        }
        return dividerLoc;
    }

    public Action getUndoAction() {
        return this._undoHandler.getUndoAction();
    }

    public Action getRedoAction() {
        return this._undoHandler.getRedoAction();
    }

    public SQLPanelPosition getSQLPanelPosition() {
        return this._sqlPanelPosition;
    }

    private class SQLExecutorHistoryListener
    extends SQLExecutionAdapter {
        private SQLExecutorHistoryListener() {
        }

        @Override
        public void statementExecuted(QueryHolder sql) {
            SQLPanel.this._panelAPI.addSQLToHistory(sql.getOriginalQuery());
        }
    }

    private class ShowHistoryButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        ShowHistoryButton(IApplication app) {
            SquirrelResources rsrc = app.getResources();
            ImageIcon icon = rsrc.getIcon("SQLHistory");
            this.setIcon(icon);
            String hint = s_stringMgr.getString("SQLPanel.openSqlHistory.hint");
            this.setToolTipText(hint);
            Dimension dm = this.getPreferredSize();
            dm.setSize(dm.height, dm.height);
            this.setPreferredSize(dm);
            this.addActionListener(SQLPanel.this._session.getApplication().getActionCollection().get(OpenSqlHistoryAction.class));
        }
    }

    private class CopyLastButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        CopyLastButton(IApplication app) {
            SquirrelResources rsrc = app.getResources();
            ImageIcon icon = rsrc.getIcon("CopySelected");
            this.setIcon(icon);
            String hint = s_stringMgr.getString("SQLPanel.copylastbutton.hint");
            this.setToolTipText(hint);
            Dimension dm = this.getPreferredSize();
            dm.setSize(dm.height, dm.height);
            this.setPreferredSize(dm);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLPanel.this.copySelectedItemToEntryArea();
                }
            });
        }
    }

    private class SqlComboListener
    implements ActionListener {
        private boolean _listening = true;

        private SqlComboListener() {
        }

        void stopListening() {
            this._listening = false;
        }

        void startListening() {
            this._listening = true;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this._listening) {
                SQLPanel.this.copySelectedItemToEntryArea();
            }
        }
    }

    private class MyPropertiesListener
    implements PropertyChangeListener {
        private boolean _listening = true;

        private MyPropertiesListener() {
        }

        void stopListening() {
            this._listening = false;
        }

        void startListening() {
            this._listening = true;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this._listening) {
                SQLPanel.this.propertiesHaveChanged(evt.getPropertyName());
            }
        }
    }

    private class MyExecuterPaneListener
    implements ChangeListener {
        private MyExecuterPaneListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            int index = pane.getSelectedIndex();
            if (index != -1) {
                SQLPanel.this.fireExecuterTabActivated((ISQLResultExecuter)SQLPanel.this._executors.get(index));
            }
        }
    }

    private class SetAutoCommitTask
    implements Runnable {
        private SetAutoCommitTask() {
        }

        @Override
        public void run() {
            ISQLConnection conn = SQLPanel.this._session.getSQLConnection();
            SessionProperties props = SQLPanel.this._session.getProperties();
            if (conn != null) {
                boolean auto = true;
                try {
                    auto = conn.getAutoCommit();
                }
                catch (SQLException ex) {
                    s_log.error("Error with transaction control", ex);
                    SQLPanel.this._session.showErrorMessage(ex);
                }
                try {
                    conn.setAutoCommit(props.getAutoCommit());
                }
                catch (SQLException ex) {
                    props.setAutoCommit(auto);
                    SQLPanel.this._session.showErrorMessage(ex);
                }
            }
        }
    }
}

