/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class QueryInfoPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(QueryInfoPanel.class);
    private JTextArea _queryTxt = new JTextArea();
    private JLabel _rowCountLbl = new JLabel();
    private JLabel _executedLbl = new JLabel();
    private JLabel _elapsedLbl = new JLabel();
    private JScrollPane _queryScrollPane;

    QueryInfoPanel() {
        this.createGUI();
    }

    void load(int rowCount, SQLExecutionInfo exInfo) {
        this._queryTxt.setRows(6);
        this._queryTxt.setEditable(false);
        this._queryTxt.setText(exInfo.getQueryHolder().getOriginalQuery());
        this._queryScrollPane.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        this.displayRowCount(rowCount);
        this._executedLbl.setText(exInfo.getSQLExecutionStartTime().toString());
        this._elapsedLbl.setText(this.formatElapsedTime(exInfo));
    }

    public void displayRowCount(int rowCount) {
        this._rowCountLbl.setText(String.valueOf(rowCount));
    }

    private String formatElapsedTime(SQLExecutionInfo exInfo) {
        NumberFormat nbrFmt = NumberFormat.getNumberInstance();
        double executionLength = (double)exInfo.getSQLExecutionElapsedMillis() / 1000.0;
        double outputLength = (double)exInfo.getResultsProcessingElapsedMillis() / 1000.0;
        String totalTime = nbrFmt.format(executionLength + outputLength);
        String queryTime = nbrFmt.format(executionLength);
        String outputTime = nbrFmt.format(outputLength);
        String elapsedTime = s_stringMgr.getString("ResultTab.elapsedTime", new String[]{totalTime, queryTime, outputTime});
        return elapsedTime;
    }

    private void createGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 10, 5, 10);
        gbc.fill = 2;
        String label = s_stringMgr.getString("ResultTab.executedLabel");
        this.add((Component)new JLabel(label, 4), gbc);
        ++gbc.gridy;
        label = s_stringMgr.getString("ResultTab.rowCountLabel");
        this.add((Component)new JLabel(label, 4), gbc);
        ++gbc.gridy;
        label = s_stringMgr.getString("ResultTab.statementLabel");
        this.add((Component)new JLabel(label, 4), gbc);
        ++gbc.gridy;
        label = s_stringMgr.getString("ResultTab.elapsedTimeLabel");
        this.add((Component)new JLabel(label, 4), gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.add((Component)this._executedLbl, gbc);
        ++gbc.gridy;
        this.add((Component)this._rowCountLbl, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        this._queryScrollPane = new JScrollPane(this._queryTxt);
        this.add((Component)this._queryScrollPane, gbc);
        ++gbc.gridy;
        gbc.weightx = 0.0;
        this.add((Component)this._elapsedLbl, gbc);
    }
}

