/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AWTExceptionHandler {
    private static Logger logger;
    private FileHandler fileHandler;

    public AWTExceptionHandler() {
        if (logger != null) {
            logger = Logger.getLogger("org.fife.rtext");
            try {
                this.fileHandler = new FileHandler("%h/uncaughtRTextAwtExceptions.log", true);
                logger.addHandler(this.fileHandler);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void handle(Throwable t) {
        try {
            t.printStackTrace();
            if (logger != null) {
                logger.log(Level.SEVERE, "Uncaught exception in EDT", t);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void register() {
        System.setProperty("sun.awt.exception.handler", AWTExceptionHandler.class.getName());
    }

    public static void shutdown() {
        if (logger != null) {
            Handler[] handlers;
            for (Handler handler : handlers = logger.getHandlers()) {
                handler.close();
            }
            logger = null;
        }
    }
}

