/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.ClassFile;
import com.sun.tools.javac.jvm.ClassWriter;
import com.sun.tools.javac.jvm.PoolConstant;
import com.sun.tools.javac.jvm.UninitializedType;
import com.sun.tools.javac.util.ByteBuffer;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class PoolWriter {
    public static final int MAX_ENTRIES = 65535;
    public static final int MAX_STRING_LENGTH = 65535;
    private static final int POOL_BUF_SIZE = Short.MAX_VALUE;
    private final Types types;
    private final Names names;
    final WriteablePoolHelper pool;
    final SharedSignatureGenerator signatureGen;
    LinkedHashSet<Symbol.ClassSymbol> innerClasses = new LinkedHashSet();
    Map<PoolConstant.Dynamic.BsmKey, Integer> bootstrapMethods = new LinkedHashMap<PoolConstant.Dynamic.BsmKey, Integer>();

    public PoolWriter(Types types, Names names) {
        this.types = types;
        this.names = names;
        this.signatureGen = new SharedSignatureGenerator(types);
        this.pool = new WriteablePoolHelper();
    }

    int putClass(Symbol.ClassSymbol csym) {
        return this.putClass(csym.type);
    }

    int putClass(Type t) {
        return this.pool.writeIfNeeded(this.types.erasure(t));
    }

    int putMember(Symbol s) {
        return this.pool.writeIfNeeded(s);
    }

    int putDynamic(PoolConstant.Dynamic d) {
        return this.pool.writeIfNeeded(d);
    }

    int putDescriptor(Type t) {
        return this.putName(this.typeSig(this.types.erasure(t)));
    }

    int putDescriptor(Symbol s) {
        return this.putDescriptor(this.descriptorType(s));
    }

    int putSignature(Symbol s) {
        if (s.kind == Kinds.Kind.TYP) {
            return this.putName(this.classSig(s.type));
        }
        return this.putName(this.typeSig(s.type));
    }

    int putConstant(Object o) {
        Object object = o;
        if (object instanceof Integer) {
            Integer intVal = (Integer)object;
            return this.putConstant(PoolConstant.LoadableConstant.Int(intVal));
        }
        object = o;
        if (object instanceof Float) {
            Float floatVal = (Float)object;
            return this.putConstant(PoolConstant.LoadableConstant.Float(floatVal.floatValue()));
        }
        object = o;
        if (object instanceof Long) {
            Long longVal = (Long)object;
            return this.putConstant(PoolConstant.LoadableConstant.Long(longVal));
        }
        object = o;
        if (object instanceof Double) {
            Double doubleVal = (Double)object;
            return this.putConstant(PoolConstant.LoadableConstant.Double(doubleVal));
        }
        object = o;
        if (object instanceof String) {
            String strVal = (String)object;
            return this.putConstant(PoolConstant.LoadableConstant.String(strVal));
        }
        throw new AssertionError((Object)("unexpected constant: " + o));
    }

    int putConstant(PoolConstant.LoadableConstant c) {
        switch (c.poolTag()) {
            case 7: {
                return this.putClass((Type)((Object)c));
            }
            case 16: {
                return this.pool.writeIfNeeded(this.types.erasure((Type)((Object)c)));
            }
        }
        return this.pool.writeIfNeeded(c);
    }

    int putName(Name name) {
        return this.pool.writeIfNeeded(name);
    }

    int putNameAndType(Symbol s) {
        return this.pool.writeIfNeeded(new PoolConstant.NameAndType(s.name, this.descriptorType(s)));
    }

    int putPackage(Symbol.PackageSymbol pkg) {
        return this.pool.writeIfNeeded(pkg);
    }

    int putModule(Symbol.ModuleSymbol mod) {
        return this.pool.writeIfNeeded(mod);
    }

    void enterInner(Symbol.ClassSymbol c) {
        if (c.type.isCompound()) {
            throw new AssertionError((Object)("Unexpected intersection type: " + c.type));
        }
        c.complete();
        if (c.owner.enclClass() != null && !this.innerClasses.contains(c)) {
            this.enterInner(c.owner.enclClass());
            this.innerClasses.add(c);
        }
    }

    private Type descriptorType(Symbol s) {
        return s.kind == Kinds.Kind.MTH ? s.externalType(this.types) : s.erasure(this.types);
    }

    private int makeBootstrapEntry(PoolConstant.Dynamic dynamic) {
        PoolConstant.Dynamic.BsmKey bsmKey = dynamic.bsmKey(this.types);
        Integer index = this.bootstrapMethods.get(bsmKey);
        if (index == null) {
            index = this.bootstrapMethods.size();
            this.bootstrapMethods.put(bsmKey, index);
        }
        return index;
    }

    void writePool(OutputStream out) throws IOException, ClassWriter.PoolOverflow {
        if (this.pool.overflowString != null) {
            throw new ClassWriter.StringOverflow(this.pool.overflowString);
        }
        int size = this.size();
        if (size > 65535) {
            throw new ClassWriter.PoolOverflow();
        }
        out.write(size >> 8);
        out.write(size);
        out.write(this.pool.poolbuf.elems, 0, this.pool.poolbuf.length);
    }

    int size() {
        return this.pool.currentIndex;
    }

    private Name typeSig(Type type) {
        this.signatureGen.reset();
        this.signatureGen.assembleSig(type);
        return this.signatureGen.toName();
    }

    private Name classSig(Type t) {
        this.signatureGen.reset();
        List<Type> typarams = t.getTypeArguments();
        if (typarams.nonEmpty()) {
            this.signatureGen.assembleParamsSig(typarams);
        }
        this.signatureGen.assembleSig(this.types.supertype(t));
        for (Type i : this.types.interfaces(t)) {
            this.signatureGen.assembleSig(i);
        }
        return this.signatureGen.toName();
    }

    void reset() {
        this.innerClasses.clear();
        this.bootstrapMethods.clear();
        this.pool.reset();
    }

    class SharedSignatureGenerator
    extends Types.SignatureGenerator {
        ByteBuffer sigbuf;

        SharedSignatureGenerator(Types types) {
            super(types);
            this.sigbuf = new ByteBuffer();
        }

        @Override
        public void assembleSig(Type type) {
            switch (type.getTag()) {
                case UNINITIALIZED_THIS: 
                case UNINITIALIZED_OBJECT: {
                    this.assembleSig(PoolWriter.this.types.erasure(((UninitializedType)type).qtype));
                    break;
                }
                default: {
                    super.assembleSig(type);
                }
            }
        }

        @Override
        protected void append(char ch) {
            this.sigbuf.appendByte(ch);
        }

        @Override
        protected void append(byte[] ba) {
            this.sigbuf.appendBytes(ba);
        }

        @Override
        protected void append(Name name) {
            this.sigbuf.appendName(name);
        }

        @Override
        protected void classReference(Symbol.ClassSymbol c) {
            PoolWriter.this.enterInner(c);
        }

        protected void reset() {
            this.sigbuf.reset();
        }

        protected Name toName() {
            return this.sigbuf.toName(PoolWriter.this.names);
        }
    }

    class WriteablePoolHelper {
        private final Map<Object, Integer> keysToPos = new HashMap<Object, Integer>(64);
        final ByteBuffer poolbuf = new ByteBuffer(Short.MAX_VALUE);
        int currentIndex = 1;
        ArrayDeque<PoolConstant> todo = new ArrayDeque();
        String overflowString = null;

        WriteablePoolHelper() {
        }

        private <P extends PoolConstant> int writeIfNeeded(P p) {
            Object key = p.poolKey(PoolWriter.this.types);
            Integer index = this.keysToPos.get(key);
            if (index == null) {
                index = this.currentIndex++;
                this.keysToPos.put(key, index);
                boolean first = this.todo.isEmpty();
                this.todo.addLast(p);
                if (first) {
                    while (!this.todo.isEmpty()) {
                        this.writeConstant(this.todo.peekFirst());
                        this.todo.removeFirst();
                    }
                }
            }
            return index;
        }

        void writeConstant(PoolConstant c) {
            int tag = c.poolTag();
            switch (tag) {
                case 7: {
                    Type ct = (Type)c;
                    Name name = ct.hasTag(TypeTag.ARRAY) ? PoolWriter.this.typeSig(ct) : PoolWriter.this.names.fromUtf(ClassFile.externalize(ct.tsym.flatName()));
                    this.poolbuf.appendByte(tag);
                    this.poolbuf.appendChar(PoolWriter.this.putName(name));
                    if (!ct.hasTag(TypeTag.CLASS)) break;
                    PoolWriter.this.enterInner((Symbol.ClassSymbol)ct.tsym);
                    break;
                }
                case 1: {
                    Name name = (Name)c;
                    this.poolbuf.appendByte(tag);
                    byte[] bs = name.toUtf();
                    this.poolbuf.appendChar(bs.length);
                    this.poolbuf.appendBytes(bs, 0, bs.length);
                    if (this.overflowString != null || bs.length <= 65535) break;
                    this.overflowString = new String(bs);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    Symbol sym = (Symbol)c;
                    this.poolbuf.appendByte(tag);
                    this.poolbuf.appendChar(PoolWriter.this.putClass((Symbol.ClassSymbol)sym.owner));
                    this.poolbuf.appendChar(PoolWriter.this.putNameAndType(sym));
                    break;
                }
                case 20: {
                    Symbol.PackageSymbol pkg = (Symbol.PackageSymbol)c;
                    Name pkgName = PoolWriter.this.names.fromUtf(ClassFile.externalize(pkg.flatName()));
                    this.poolbuf.appendByte(tag);
                    this.poolbuf.appendChar(PoolWriter.this.putName(pkgName));
                    break;
                }
                case 19: {
                    Symbol.ModuleSymbol mod = (Symbol.ModuleSymbol)c;
                    int modName = PoolWriter.this.putName(mod.name);
                    this.poolbuf.appendByte(mod.poolTag());
                    this.poolbuf.appendChar(modName);
                    break;
                }
                case 3: {
                    this.poolbuf.appendByte(tag);
                    this.poolbuf.appendInt((Integer)((PoolConstant.LoadableConstant.BasicConstant)c).data);
                    break;
                }
                case 4: {
                    this.poolbuf.appendByte(tag);
                    this.poolbuf.appendFloat(((Float)((PoolConstant.LoadableConstant.BasicConstant)c).data).floatValue());
                    break;
                }
                case 5: {
                    ++this.currentIndex;
                    this.poolbuf.appendByte(tag);
                    this.poolbuf.appendLong((Long)((PoolConstant.LoadableConstant.BasicConstant)c).data);
                    break;
                }
                case 6: {
                    ++this.currentIndex;
                    this.poolbuf.appendByte(tag);
                    this.poolbuf.appendDouble((Double)((PoolConstant.LoadableConstant.BasicConstant)c).data);
                    break;
                }
                case 15: {
                    Symbol.MethodHandleSymbol h = (Symbol.MethodHandleSymbol)c;
                    this.poolbuf.appendByte(tag);
                    this.poolbuf.appendByte(h.referenceKind());
                    this.poolbuf.appendChar(PoolWriter.this.putMember(h.baseSymbol()));
                    break;
                }
                case 16: {
                    Type.MethodType mt = (Type.MethodType)c;
                    this.poolbuf.appendByte(tag);
                    this.poolbuf.appendChar(PoolWriter.this.putDescriptor(mt.baseType()));
                    break;
                }
                case 8: {
                    Name utf = PoolWriter.this.names.fromString((String)((PoolConstant.LoadableConstant.BasicConstant)c).data);
                    this.poolbuf.appendByte(tag);
                    this.poolbuf.appendChar(PoolWriter.this.putName(utf));
                    break;
                }
                case 12: {
                    PoolConstant.NameAndType nt = (PoolConstant.NameAndType)c;
                    this.poolbuf.appendByte(tag);
                    this.poolbuf.appendChar(PoolWriter.this.putName(nt.name));
                    this.poolbuf.appendChar(PoolWriter.this.putDescriptor(nt.type));
                    break;
                }
                case 18: {
                    Symbol.DynamicMethodSymbol d = (Symbol.DynamicMethodSymbol)c;
                    this.poolbuf.appendByte(tag);
                    this.poolbuf.appendChar(PoolWriter.this.makeBootstrapEntry(d));
                    this.poolbuf.appendChar(PoolWriter.this.putNameAndType(d));
                    break;
                }
                case 17: {
                    Symbol.DynamicVarSymbol d = (Symbol.DynamicVarSymbol)c;
                    this.poolbuf.appendByte(tag);
                    this.poolbuf.appendChar(PoolWriter.this.makeBootstrapEntry(d));
                    this.poolbuf.appendChar(PoolWriter.this.putNameAndType(d));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected constant tag: " + tag));
                }
            }
        }

        void reset() {
            this.keysToPos.clear();
            this.currentIndex = 1;
            this.todo.clear();
            this.overflowString = null;
            this.poolbuf.reset();
        }
    }
}

