/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDatabaseUpgradeHistoryEntryRequest
extends BmcRequest<Void> {
    private String databaseId;
    private String upgradeHistoryEntryId;
    private String opcRequestId;

    @ConstructorProperties(value={"databaseId", "upgradeHistoryEntryId", "opcRequestId"})
    GetDatabaseUpgradeHistoryEntryRequest(String databaseId, String upgradeHistoryEntryId, String opcRequestId) {
        this.databaseId = databaseId;
        this.upgradeHistoryEntryId = upgradeHistoryEntryId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).upgradeHistoryEntryId(this.upgradeHistoryEntryId).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "GetDatabaseUpgradeHistoryEntryRequest(super=" + super.toString() + ", databaseId=" + this.getDatabaseId() + ", upgradeHistoryEntryId=" + this.getUpgradeHistoryEntryId() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetDatabaseUpgradeHistoryEntryRequest)) {
            return false;
        }
        GetDatabaseUpgradeHistoryEntryRequest other = (GetDatabaseUpgradeHistoryEntryRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$databaseId = this.getDatabaseId();
        String other$databaseId = other.getDatabaseId();
        if (this$databaseId == null ? other$databaseId != null : !this$databaseId.equals(other$databaseId)) {
            return false;
        }
        String this$upgradeHistoryEntryId = this.getUpgradeHistoryEntryId();
        String other$upgradeHistoryEntryId = other.getUpgradeHistoryEntryId();
        if (this$upgradeHistoryEntryId == null ? other$upgradeHistoryEntryId != null : !this$upgradeHistoryEntryId.equals(other$upgradeHistoryEntryId)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetDatabaseUpgradeHistoryEntryRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $databaseId = this.getDatabaseId();
        result = result * 59 + ($databaseId == null ? 43 : $databaseId.hashCode());
        String $upgradeHistoryEntryId = this.getUpgradeHistoryEntryId();
        result = result * 59 + ($upgradeHistoryEntryId == null ? 43 : $upgradeHistoryEntryId.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getUpgradeHistoryEntryId() {
        return this.upgradeHistoryEntryId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDatabaseUpgradeHistoryEntryRequest, Void> {
        private String databaseId;
        private String upgradeHistoryEntryId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDatabaseUpgradeHistoryEntryRequest o) {
            this.databaseId(o.getDatabaseId());
            this.upgradeHistoryEntryId(o.getUpgradeHistoryEntryId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDatabaseUpgradeHistoryEntryRequest build() {
            GetDatabaseUpgradeHistoryEntryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder upgradeHistoryEntryId(String upgradeHistoryEntryId) {
            this.upgradeHistoryEntryId = upgradeHistoryEntryId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetDatabaseUpgradeHistoryEntryRequest buildWithoutInvocationCallback() {
            return new GetDatabaseUpgradeHistoryEntryRequest(this.databaseId, this.upgradeHistoryEntryId, this.opcRequestId);
        }

        public String toString() {
            return "GetDatabaseUpgradeHistoryEntryRequest.Builder(databaseId=" + this.databaseId + ", upgradeHistoryEntryId=" + this.upgradeHistoryEntryId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

