/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib.api.elements;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;

public class TreePath {
    private Element first;
    private Element last;

    public TreePath(Element last) {
        this(null, last);
    }

    public TreePath(Element first, Element last) {
        this.first = first;
        this.last = last;
    }

    public Element first() {
        return this.first;
    }

    public Element last() {
        return this.last;
    }

    public List<Element> path() {
        ArrayList<Element> path = new ArrayList<Element>();
        for (Element node = this.last; node != null; node = node.parent()) {
            path.add(node);
            if (node == this.first) break;
        }
        return path;
    }

    public String toString() {
        return this.getElementPath();
    }

    private String getElementPath() {
        return ElementUtils.encodeToString(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TreePath)) {
            return false;
        }
        TreePath path = (TreePath)o;
        return this.getElementPath().equals(path.getElementPath());
    }

    public int hashCode() {
        return this.getElementPath().hashCode();
    }
}

