/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.kenai;

import java.util.List;
import org.netbeans.modules.bugtracking.spi.QueryController;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.kenai.KenaiQuery;
import org.netbeans.modules.bugzilla.query.BugzillaQuery;
import org.netbeans.modules.bugzilla.query.QueryController;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.repository.IssueField;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.netbeans.modules.team.spi.OwnerInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class KenaiQueryController
extends QueryController {
    private final String product;
    private final boolean predefinedQuery;

    public KenaiQueryController(BugzillaRepository repository, BugzillaQuery query, String urlParameters, String product, boolean predefinedQuery) {
        super(repository, query, urlParameters, false, false);
        this.product = product;
        this.predefinedQuery = predefinedQuery;
        this.postPopulate(urlParameters, false);
    }

    @Override
    public boolean providesMode(QueryController.QueryMode mode) {
        return !this.predefinedQuery || mode != QueryController.QueryMode.EDIT;
    }

    @Override
    public void populate(String urlParameters) {
        if (BugzillaUtil.isNbRepository(this.getRepository())) {
            if (urlParameters == null) {
                OwnerInfo ownerInfo = this.query.getOwnerInfo();
                if (ownerInfo == null) {
                    Node[] selection = WindowManager.getDefault().getRegistry().getActivatedNodes();
                    ownerInfo = this.getRepository().getOwnerInfo(selection);
                }
                if (ownerInfo != null) {
                    StringBuilder sb = new StringBuilder();
                    String owner = ownerInfo.getOwner();
                    if (owner != null && owner.equals(this.product)) {
                        sb.append("product=");
                        sb.append(owner);
                        List data = ownerInfo.getExtraData();
                        if (data != null && data.size() > 0) {
                            sb.append("&component=");
                            sb.append((String)data.get(0));
                        }
                        urlParameters = sb.toString();
                        this.selectFirstProduct();
                    }
                }
                if (urlParameters == null) {
                    urlParameters = "product=" + this.product;
                }
            }
            super.populate(urlParameters);
        } else {
            super.populate(urlParameters);
            this.disableProduct();
            this.selectFirstProduct();
        }
    }

    @Override
    protected void enableFields(boolean bl) {
        super.enableFields(bl);
        if (this.predefinedQuery) {
            this.panel.modifyButton.setEnabled(false);
            this.panel.removeButton.setEnabled(false);
        }
    }

    @Override
    protected void openIssue(BugzillaIssue issue) {
        if (issue != null && !this.checkIssueProduct(issue)) {
            return;
        }
        super.openIssue(issue);
    }

    @Override
    protected void onCloneQuery() {
        String p = this.getUrlParameters(false);
        KenaiQuery q = new KenaiQuery(null, this.getRepository(), p, this.product, false, false);
        BugzillaUtil.openQuery(q);
    }

    private boolean checkIssueProduct(BugzillaIssue issue) {
        String issueProduct = issue.getRepositoryFieldValue(IssueField.PRODUCT);
        if (!issueProduct.equals(this.product)) {
            NotifyDescriptor.Confirmation dd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(KenaiQueryController.class, (String)"MSG_WrongProjectWarning", (Object[])new Object[]{issue.getID(), issueProduct}), 0);
            return DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == NotifyDescriptor.Confirmation.YES_OPTION;
        }
        return true;
    }
}

