/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.nativeimage.debugger.displayer;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.nativeimage.api.debug.NIFrame;
import org.netbeans.modules.nativeimage.spi.debug.filters.FrameDisplayer;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;

public final class JavaFrameDisplayer
implements FrameDisplayer {
    private final ClassPath sourcePath;

    public JavaFrameDisplayer(Project project) {
        this.sourcePath = JavaFrameDisplayer.findSourcePath(project);
    }

    public FrameDisplayer.DisplayedFrame displayed(NIFrame frame) {
        String functionName = frame.getFunctionName();
        if ("??".equals(functionName)) {
            return null;
        }
        return this.createJavaFrame(frame);
    }

    private FrameDisplayer.DisplayedFrame createJavaFrame(NIFrame frame) {
        return FrameDisplayer.DisplayedFrame.newBuilder((String)JavaFrameDisplayer.getDisplayName(frame)).description(JavaFrameDisplayer.getDescription(frame)).line(frame.getLine()).sourceURISupplier(() -> this.getSourceURI(frame)).build();
    }

    private static String getDisplayName(NIFrame frame) {
        String clsMethod;
        int methodStart;
        String functionName = frame.getFunctionName();
        int methodEnd = functionName.indexOf(40);
        if (methodEnd < 0) {
            methodEnd = functionName.length();
        }
        if ((methodStart = functionName.lastIndexOf(46, methodEnd)) < 0) {
            clsMethod = functionName.substring(0, methodEnd);
        } else {
            int clsStart = functionName.lastIndexOf(46, methodStart - 1);
            clsStart = clsStart < 0 ? 0 : ++clsStart;
            clsMethod = functionName.substring(clsStart, methodEnd);
        }
        int line = frame.getLine();
        if (line < 0) {
            return clsMethod;
        }
        return clsMethod + ':' + line;
    }

    private static String getDescription(NIFrame frame) {
        String functionName = frame.getFunctionName();
        int methodEnd = functionName.indexOf(40);
        if (methodEnd < 0) {
            methodEnd = functionName.length();
        }
        String clsMethod = functionName.substring(0, methodEnd);
        int line = frame.getLine();
        if (line < 0) {
            return clsMethod;
        }
        return clsMethod + ':' + line;
    }

    private URI getSourceURI(NIFrame frame) {
        String className;
        URI uri;
        int methodStart;
        String functionName = frame.getFunctionName();
        int methodEnd = functionName.indexOf(40);
        if (methodEnd < 0) {
            methodEnd = functionName.length();
        }
        if (methodEnd > 0 && (methodStart = functionName.lastIndexOf(46, methodEnd)) > 0 && (uri = JavaFrameDisplayer.findClassURI(this.sourcePath, className = functionName.substring(0, methodStart))) != null) {
            return uri;
        }
        String fullFileName = frame.getFullFileName();
        if (fullFileName != null && !fullFileName.isEmpty()) {
            return new File(fullFileName).toURI();
        }
        return null;
    }

    private static URI findClassURI(ClassPath sourcePath, String className) {
        String sourceName = className;
        int i = sourceName.indexOf(36);
        if (i > 0) {
            sourceName = sourceName.substring(0, i);
        }
        sourceName = sourceName.replace('.', '/') + ".java";
        FileObject resource = sourcePath != null ? sourcePath.findResource(sourceName) : GlobalPathRegistry.getDefault().findResource(sourceName);
        if (resource != null) {
            return resource.toURI();
        }
        return null;
    }

    private static ClassPath findSourcePath(Project project) {
        if (project != null) {
            SourceGroup[] sgs;
            ArrayList<FileObject> allSourceRoots = new ArrayList<FileObject>();
            HashSet<FileObject> preferredRoots = new HashSet<FileObject>();
            HashSet<FileObject> addedBinaryRoots = new HashSet<FileObject>();
            for (SourceGroup sg : sgs = ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
                FileObject[] binaryRoots;
                ClassPath ecp = ClassPath.getClassPath((FileObject)sg.getRootFolder(), (String)"classpath/execute");
                if (ecp == null) {
                    ecp = ClassPath.getClassPath((FileObject)sg.getRootFolder(), (String)"classpath/source");
                }
                if (ecp == null) continue;
                for (FileObject fo : binaryRoots = ecp.getRoots()) {
                    FileObject[] roots;
                    if (addedBinaryRoots.contains(fo)) continue;
                    addedBinaryRoots.add(fo);
                    for (FileObject fr : roots = SourceForBinaryQuery.findSourceRoots((URL)fo.toURL()).getRoots()) {
                        if (preferredRoots.contains(fr)) continue;
                        allSourceRoots.add(fr);
                        preferredRoots.add(fr);
                    }
                }
            }
            return JavaFrameDisplayer.createClassPath(allSourceRoots);
        }
        return null;
    }

    private static ClassPath createClassPath(Collection<FileObject> froots) {
        ArrayList<PathResourceImplementation> pris = new ArrayList<PathResourceImplementation>();
        for (FileObject fo : froots) {
            if (fo == null || !fo.canRead()) continue;
            try {
                URL url = fo.toURL();
                pris.add(ClassPathSupport.createResource((URL)url));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return ClassPathSupport.createClassPath(pris);
    }
}

