/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.projectsupport.utilities;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.profiler.projectsupport.utilities.Bundle;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;

public class AppletSupport {
    private static final SpecificationVersion JDK_15 = new SpecificationVersion("1.5");
    private static final String HTML_EXT = "html";
    private static final String CLASS_EXT = "class";
    private static final String POLICY_FILE_NAME = "applet";
    private static final String POLICY_FILE_EXT = "policy";
    public static Boolean unitTestingSupport_isApplet = null;

    private AppletSupport() {
    }

    public static URL generateHtmlFileURL(FileObject appletFile, FileObject buildDir, FileObject classesDir, String activePlatform) throws FileStateInvalidException {
        FileObject html = null;
        IOException ex = null;
        if (appletFile == null || buildDir == null || classesDir == null) {
            return null;
        }
        try {
            html = AppletSupport.generateHtml(appletFile, buildDir, classesDir);
        }
        catch (IOException iex) {
            ex = iex;
        }
        URL url = null;
        if (ex == null) {
            boolean workAround6193279;
            JavaPlatformManager pm = JavaPlatformManager.getDefault();
            JavaPlatform platform = null;
            if (activePlatform == null) {
                platform = pm.getDefaultPlatform();
            } else {
                JavaPlatform[] installedPlatforms = pm.getPlatforms(null, new Specification("j2se", null));
                for (int i = 0; i < installedPlatforms.length; ++i) {
                    String antName = (String)installedPlatforms[i].getProperties().get("platform.ant.name");
                    if (antName == null || !antName.equals(activePlatform)) continue;
                    platform = installedPlatforms[i];
                    break;
                }
            }
            boolean bl = workAround6193279 = platform != null && platform.getSpecification().getVersion().compareTo((Object)JDK_15) >= 0;
            if (workAround6193279) {
                File f = FileUtil.toFile((FileObject)html);
                try {
                    url = new URL("file", null, f.getAbsolutePath());
                }
                catch (MalformedURLException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            } else {
                url = html.toURL();
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject generateSecurityPolicy(FileObject projectDir, FileObject buildDir) {
        FileObject policyFile;
        block7: {
            policyFile = buildDir.getFileObject(POLICY_FILE_NAME, POLICY_FILE_EXT);
            try {
                if (policyFile != null) break block7;
                FileObject original = projectDir.getFileObject(POLICY_FILE_NAME, POLICY_FILE_EXT);
                if (original != null) {
                    policyFile = FileUtil.copyFile((FileObject)original, (FileObject)buildDir, (String)POLICY_FILE_NAME, (String)POLICY_FILE_EXT);
                    break block7;
                }
                policyFile = buildDir.createData(POLICY_FILE_NAME, POLICY_FILE_EXT);
                FileLock lock = policyFile.lock();
                PrintWriter writer = null;
                try {
                    writer = new PrintWriter(policyFile.getOutputStream(lock));
                    AppletSupport.fillInPolicyFile(writer);
                }
                finally {
                    lock.releaseLock();
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().log(1, "Failed to generate applet policy file: " + ioe);
            }
        }
        return policyFile;
    }

    private static void fillInFile(PrintWriter writer, String name, String codebase) {
        writer.println("<HTML>");
        writer.println("<HEAD>");
        writer.print("   <TITLE>");
        writer.print(Bundle.GEN_title());
        writer.println("</TITLE>");
        writer.println("</HEAD>");
        writer.println("<BODY>\n");
        writer.print(Bundle.GEN_warning());
        writer.print("<H3><HR WIDTH=\"100%\">");
        writer.print(Bundle.GEN_header());
        writer.println("<HR WIDTH=\"100%\"></H3>\n");
        writer.println("<P>");
        if (codebase == null) {
            writer.print("<APPLET code=");
        } else {
            writer.print("<APPLET " + codebase + " code=");
        }
        writer.print("\"");
        writer.print(name);
        writer.print("\"");
        writer.println(" width=350 height=200></APPLET>");
        writer.println("</P>\n");
        writer.print("<HR WIDTH=\"100%\"><FONT SIZE=-1><I>");
        writer.print(Bundle.GEN_copy());
        writer.println("</I></FONT>");
        writer.println("</BODY>");
        writer.println("</HTML>");
        writer.flush();
    }

    private static void fillInPolicyFile(PrintWriter writer) {
        writer.println("grant {");
        writer.println("permission java.security.AllPermission;");
        writer.println("};");
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileObject generateHtml(FileObject appletFile, FileObject buildDir, FileObject classesDir) throws IOException {
        FileObject htmlFile = buildDir.getFileObject(appletFile.getName(), HTML_EXT);
        if (htmlFile == null) {
            htmlFile = buildDir.createData(appletFile.getName(), HTML_EXT);
        }
        FileLock lock = htmlFile.lock();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(htmlFile.getOutputStream(lock));
            ClassPath cp = ClassPath.getClassPath((FileObject)appletFile, (String)"classpath/execute");
            ClassPath sp = ClassPath.getClassPath((FileObject)appletFile, (String)"classpath/source");
            String path = FileUtil.getRelativePath((FileObject)sp.findOwnerRoot(appletFile), (FileObject)appletFile);
            path = path.substring(0, path.length() - 5);
            AppletSupport.fillInFile(writer, path + "." + CLASS_EXT, "codebase=\"" + classesDir.toURL() + "\"");
        }
        finally {
            lock.releaseLock();
            if (writer != null) {
                writer.close();
            }
        }
        return htmlFile;
    }
}

