/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JTable;
import javax.swing.tree.TreePath;
import org.netbeans.jellytools.nodes.OutlineNode;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;

public class OutlineOperator
extends JTableOperator {
    public OutlineOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public OutlineOperator(ContainerOperator cont, int index) {
        super((JTable)((Outline)cont.waitSubComponent((ComponentChooser)new OutlineFinder(ComponentSearcher.getTrueChooser((String)"Any Outline")), index)));
        this.copyEnvironment((Operator)cont);
    }

    public OutlineOperator(Outline outline) {
        super((JTable)outline);
    }

    public Outline getOutline() {
        return (Outline)this.getSource();
    }

    public int getTreeColumnIndex() {
        int lnNumColumns = this.getColumnCount();
        for (int i = 0; i < lnNumColumns; ++i) {
            if (this.convertColumnIndexToModel(i) != 0) continue;
            return i;
        }
        return -1;
    }

    public TreePath findNextPathElement(TreePath irParentPath, String isName, int inIndex) {
        TreePath lrTreePath;
        if (!this.isExpanded(irParentPath)) {
            this.expandPath(irParentPath);
        }
        Timeouts lrTimes = this.getTimeouts().cloneThis();
        lrTimes.setTimeout("Waiter.WaitingTime", this.getTimeouts().getTimeout("JTreeOperator.WaitNextNodeTimeout"));
        try {
            Waiter lrWaiter = new Waiter((Waitable)new NodeWaiter(irParentPath, isName, inIndex));
            lrWaiter.setTimeouts(lrTimes);
            lrTreePath = (TreePath)lrWaiter.waitAction(null);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted.", (Throwable)e);
        }
        return lrTreePath;
    }

    public TreePath findNextPathElement(TreePath irParentPath, String isName) {
        return this.findNextPathElement(irParentPath, isName, 0);
    }

    public OutlineNode getRootNode(String isName) {
        return this.getRootNode(isName, 0);
    }

    public OutlineNode getRootNode(String isName, int inIndex) {
        TreePath lrParentPath = new TreePath(this.getOutline().getOutlineModel().getRoot());
        return new OutlineNode(this, this.findNextPathElement(lrParentPath, isName, inIndex));
    }

    public TreePath findPath(TreePath irParentPath, String isPath) {
        int lnDelimIndex = isPath.indexOf("|");
        if (lnDelimIndex > -1) {
            TreePath lrFoundPath = this.findNextPathElement(irParentPath, isPath.substring(0, lnDelimIndex));
            return this.findPath(lrFoundPath, isPath.substring(lnDelimIndex + 1));
        }
        return this.findNextPathElement(irParentPath, isPath);
    }

    public TreePath findPath(String isPath) {
        TreePath lrParentPath = new TreePath(this.getOutline().getOutlineModel().getRoot());
        return this.findPath(lrParentPath, isPath);
    }

    public void waitExpanded(final TreePath irTP) {
        if (irTP == null) {
            throw new JemmyException("No such path: null");
        }
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return OutlineOperator.this.isExpanded(irTP);
            }

            public String getDescription() {
                return "Has \"" + irTP.toString() + "\" path expanded";
            }
        });
    }

    protected int getVisibleRootModifier() {
        return this.getOutline().isRootVisible() ? 0 : -1;
    }

    public Point getLocationForPath(TreePath irTreePath) {
        int lnX = this.getTreeColumnIndex();
        int lnY = this.getRowForPath(irTreePath);
        return lnY == -1 ? new Point(-1, -1) : new Point(lnX, lnY);
    }

    public int getRowForPath(TreePath irTreePath) {
        if (irTreePath.getParentPath() == null) {
            return this.getVisibleRootModifier();
        }
        if (!this.isExpanded(irTreePath.getParentPath())) {
            this.expandPath(irTreePath.getParentPath());
        }
        int lnRow = -1;
        while (irTreePath.getParentPath() != null) {
            lnRow += 1 + this.getPrecedingSiblingsRowSpan(irTreePath);
            irTreePath = irTreePath.getParentPath();
        }
        return lnRow;
    }

    protected int getPrecedingSiblingsRowSpan(TreePath irTreePath) {
        OutlineModel lrModel = this.getOutline().getOutlineModel();
        if (irTreePath.getParentPath() == null) {
            return 0 + this.getVisibleRootModifier();
        }
        Object lrLast = irTreePath.getLastPathComponent();
        TreePath lrParent = irTreePath.getParentPath();
        int lnRowSpan = 0;
        int lnIndex = lrModel.getIndexOfChild(lrParent.getLastPathComponent(), lrLast);
        for (int i = lnIndex - 1; i >= 0; --i) {
            Object lrSibling = lrModel.getChild(lrParent.getLastPathComponent(), i);
            lnRowSpan += this.getRowSpanOfLastElement(lrParent.pathByAddingChild(lrSibling));
        }
        return lnRowSpan;
    }

    protected int getRowSpanOfLastElement(TreePath irTreePath) {
        OutlineModel lrModel = this.getOutline().getOutlineModel();
        if (!this.isExpanded(irTreePath)) {
            return 1;
        }
        Object lrLast = irTreePath.getLastPathComponent();
        int lnRowspan = 1;
        int lnChildCount = lrModel.getChildCount(lrLast);
        for (int i = 0; i < lnChildCount; ++i) {
            Object lnChild = lrModel.getChild(lrLast, i);
            TreePath lrTempPath = irTreePath.pathByAddingChild(lnChild);
            lnRowspan += this.getRowSpanOfLastElement(lrTempPath);
        }
        return lnRowspan;
    }

    public void selectPath(TreePath irPath) {
        Point lrLocation = this.getLocationForPath(irPath);
        if (!lrLocation.equals(new Point(-1, -1))) {
            this.selectCell(lrLocation.y, lrLocation.x);
        }
    }

    public void scrollToPath(TreePath irPath) {
        Point lrLocation = this.getLocationForPath(irPath);
        if (!lrLocation.equals(new Point(-1, -1))) {
            this.scrollToCell(lrLocation.y, lrLocation.x);
        }
    }

    public void expandPath(final TreePath irTP) {
        this.runMapping(new Operator.MapVoidAction("expandPath"){

            public void map() {
                OutlineOperator.this.getOutline().expandPath(irTP);
            }
        });
    }

    public boolean isExpanded(final TreePath irTP) {
        return (Boolean)this.runMapping(new Operator.MapAction("isExpanded"){

            public Object map() {
                return OutlineOperator.this.getOutline().isExpanded(irTP);
            }
        });
    }

    private class NodeWaiter
    implements Waitable {
        private TreePath parentPath;
        private int[] rowsToSearch = null;
        private String name;
        private int index;

        public NodeWaiter(TreePath irParentPath, String isName, int inIndex) {
            this.parentPath = irParentPath;
            this.name = isName;
            this.index = inIndex;
        }

        private int[] getRowsToSearch() {
            int lnRowSpan = OutlineOperator.this.getOutline().getOutlineModel().getChildCount(this.parentPath.getLastPathComponent());
            if (this.rowsToSearch == null || this.rowsToSearch.length != lnRowSpan) {
                int lnStartRow = OutlineOperator.this.getRowForPath(this.parentPath) + 1;
                int lnPrecedingSiblingRowSpan = 0;
                this.rowsToSearch = new int[lnRowSpan];
                for (int i = 0; i < lnRowSpan; ++i) {
                    this.rowsToSearch[i] = lnStartRow + lnPrecedingSiblingRowSpan;
                    Object lrSibling = OutlineOperator.this.getOutline().getOutlineModel().getChild(this.parentPath.getLastPathComponent(), i);
                    TreePath lrSiblingPath = this.parentPath.pathByAddingChild(lrSibling);
                    lnPrecedingSiblingRowSpan += OutlineOperator.this.getRowSpanOfLastElement(lrSiblingPath);
                }
            }
            return this.rowsToSearch;
        }

        public Object actionProduced(Object anObject) {
            Point lrFindPoint = OutlineOperator.this.findCell(this.name, this.getRowsToSearch(), new int[]{OutlineOperator.this.getTreeColumnIndex()}, this.index);
            if (lrFindPoint.equals(new Point(-1, -1))) {
                return null;
            }
            TreePath lrPath = OutlineOperator.this.getOutline().getLayoutCache().getPathForRow(lrFindPoint.y);
            if (lrPath == null) {
                return null;
            }
            if (lrPath.getPathCount() != this.parentPath.getPathCount() + 1) {
                return null;
            }
            return lrPath;
        }

        public String getDescription() {
            return "Tree node cell with name '" + this.name + "' present.";
        }
    }

    private static class OutlineFinder
    implements ComponentChooser {
        private ComponentChooser subFinder;

        public OutlineFinder(ComponentChooser finder) {
            this.subFinder = finder;
        }

        public boolean checkComponent(Component comp) {
            Class<?> cls = comp.getClass();
            do {
                if (!cls.getName().equals("org.netbeans.swing.outline.Outline")) continue;
                return this.subFinder.checkComponent(comp);
            } while ((cls = cls.getSuperclass()) != null);
            return false;
        }

        public String getDescription() {
            return this.subFinder.getDescription();
        }
    }
}

