/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ResponseImpl;
import org.apache.tomcat.util.StringManager;

public class BufferedServletOutputStream
extends ServletOutputStream {
    protected static StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    protected boolean usingWriter = false;
    protected static final int DEFAULT_BUFFER_SIZE = 8192;
    protected byte[] buffer = new byte[8192];
    protected int bufferSize = 8192;
    protected int bufferCount = 0;
    protected int totalCount = 0;
    protected boolean closed = false;
    ResponseImpl resA;

    protected BufferedServletOutputStream() {
    }

    protected BufferedServletOutputStream(Response resA) {
        this.setResponse(resA);
    }

    protected void doWrite(byte[] buffer, int pos, int count) throws IOException {
        this.resA.doWrite(buffer, pos, count);
    }

    protected void sendHeaders() throws IOException {
        if (this.resA != null) {
            this.resA.endHeaders();
        }
    }

    public void setResponse(Response response) {
        this.resA = (ResponseImpl)response;
    }

    public void setUsingWriter(boolean uwrt) {
        this.usingWriter = uwrt;
    }

    public void write(int i) throws IOException {
        if (this.closed) {
            return;
        }
        this.buffer[this.bufferCount] = (byte)i;
        ++this.bufferCount;
        ++this.totalCount;
        if (this.bufferCount >= this.buffer.length) {
            this.reallyFlush();
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return;
        }
        if (len < 0) {
            String msg = sm.getString("servletOutputStreamImpl.write.iae");
            throw new IllegalArgumentException(msg);
        }
        if (len < this.buffer.length - this.bufferCount) {
            System.arraycopy(b, off, this.buffer, this.bufferCount, len);
            this.bufferCount += len;
            this.totalCount += len;
        } else {
            this.reallyFlush();
            int iters = len / this.buffer.length;
            int leftoverStart = iters * this.buffer.length;
            int leftoverLen = len - leftoverStart;
            int i = 0;
            while (i < iters) {
                this.doWrite(b, off + i * this.buffer.length, this.buffer.length);
                ++i;
            }
            this.totalCount += leftoverStart;
            if (len % this.buffer.length != 0) {
                System.arraycopy(b, off + leftoverStart, this.buffer, this.bufferCount, leftoverLen);
                this.bufferCount += leftoverLen;
                this.totalCount += leftoverLen;
            }
        }
    }

    public void print(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if ((c & 0xFF00) != 0) {
                String errMsg = sm.getString("servletOutputStreamImpl.fmt.not_iso8859_1", new Object[]{new Character(c)});
                throw new IOException(errMsg);
            }
            this.write(c);
            ++i;
        }
    }

    public void flush() throws IOException {
        if (!this.usingWriter) {
            this.reallyFlush();
        }
    }

    public void reallyFlush() throws IOException {
        try {
            if (!this.resA.isBufferCommitted()) {
                this.sendHeaders();
                this.resA.setBufferCommitted(true);
            }
            if (this.bufferCount > 0) {
                Request req = this.resA.getRequest();
                ContextManager cm = req.getContextManager();
                cm.doBeforeCommit(req, this.resA);
                this.doWrite(this.buffer, 0, this.bufferCount);
            }
            Object var4_3 = null;
            this.bufferCount = 0;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.bufferCount = 0;
            throw throwable;
        }
    }

    public void close() throws IOException {
        this.reallyFlush();
        this.closed = true;
    }

    public boolean isContentWritten() {
        return this.totalCount > 0;
    }

    public int getBufferSize() {
        return this.buffer.length;
    }

    public void setBufferSize(int size) throws IllegalStateException {
        if (size <= this.bufferSize) {
            return;
        }
        int eightK = 8192;
        if (size % eightK != 0) {
            size = (size / eightK + 1) * eightK;
        }
        this.bufferSize = size;
        this.buffer = new byte[size];
    }

    public void reset() throws IllegalStateException {
        if (this.resA.isBufferCommitted()) {
            String msg = sm.getString("servletOutputStreamImpl.reset.ise");
            throw new IllegalStateException(msg);
        }
        this.bufferCount = 0;
        this.totalCount = 0;
    }

    public void recycle() {
        this.bufferCount = 0;
        this.totalCount = 0;
        this.closed = false;
        this.usingWriter = false;
    }
}

