/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.TokenInput;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.NBSLanguage;
import org.netbeans.modules.languages.Rule;
import org.netbeans.modules.languages.Selector;
import org.netbeans.modules.languages.TokenType;
import org.netbeans.modules.languages.Utils;
import org.netbeans.modules.languages.parser.Pattern;
import org.netbeans.modules.languages.parser.StringInput;
import org.netbeans.modules.languages.parser.SyntaxError;
import org.netbeans.modules.languages.parser.TokenInputUtils;
import org.openide.filesystems.FileObject;

public class NBSLanguageReader {
    private String source;
    private InputStream inputStream;
    private String sourceName;
    private String mimeType;
    private GRNode grammarTree;
    private List<TokenType> tokenTypes;
    private boolean containsTokens = false;
    private Map<String, Integer> tokenTypeToID = new HashMap<String, Integer>();
    private List<Feature> features;
    private List<Rule> grammarRules;

    public static NBSLanguageReader create(FileObject fo, String mimeType) throws IOException {
        return NBSLanguageReader.create(fo.getInputStream(), fo.getPath(), mimeType);
    }

    public static NBSLanguageReader create(InputStream is, String sourceName, String mimeType) {
        return new NBSLanguageReader(is, sourceName, mimeType);
    }

    public static NBSLanguageReader create(String source, String sourceName, String mimeType) {
        return new NBSLanguageReader(source, sourceName, mimeType);
    }

    private NBSLanguageReader(String source, String sourceName, String mimeType) {
        this.tokenTypes = new ArrayList<TokenType>();
        this.addToken(null, null, "error", null, null);
        this.addToken(null, null, "PE", null, null);
        this.addToken(null, null, "GAP", null, null);
        this.addToken(null, null, "string", null, null);
        this.addToken(null, null, "character", null, null);
        this.addToken(null, null, "identifier", null, null);
        this.addToken(null, null, "whitespace", null, null);
        this.addToken(null, null, "number", null, null);
        this.addToken(null, null, "keyword", null, null);
        this.addToken(null, null, "comment", null, null);
        this.addToken(null, null, "operator", null, null);
        this.containsTokens = false;
        this.source = source;
        this.sourceName = sourceName;
        this.mimeType = mimeType;
    }

    private NBSLanguageReader(InputStream inputStream, String sourceName, String mimeType) {
        this.tokenTypes = new ArrayList<TokenType>();
        this.addToken(null, null, "error", null, null);
        this.addToken(null, null, "PE", null, null);
        this.addToken(null, null, "GAP", null, null);
        this.addToken(null, null, "string", null, null);
        this.addToken(null, null, "character", null, null);
        this.addToken(null, null, "identifier", null, null);
        this.addToken(null, null, "whitespace", null, null);
        this.addToken(null, null, "number", null, null);
        this.addToken(null, null, "keyword", null, null);
        this.addToken(null, null, "comment", null, null);
        this.addToken(null, null, "operator", null, null);
        this.containsTokens = false;
        this.inputStream = inputStream;
        this.sourceName = sourceName;
        this.mimeType = mimeType;
    }

    public List<TokenType> getTokenTypes() throws ParseException, IOException {
        if (this.features == null) {
            this.readNBS();
        }
        return this.tokenTypes;
    }

    public boolean containsTokens() throws ParseException, IOException {
        if (this.features == null) {
            this.readNBS();
        }
        return this.containsTokens;
    }

    public List<Feature> getFeatures() throws ParseException, IOException {
        if (this.features == null) {
            this.readNBS();
        }
        return this.features;
    }

    public List<Rule> getRules(Language language) throws ParseException {
        if (this.grammarRules == null) {
            this.grammarRules = this.createRules(this.grammarTree, language);
        }
        return this.grammarRules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readNBS() throws ParseException, IOException {
        if (this.source == null) {
            try (BufferedReader reader = null;){
                InputStreamReader r = new InputStreamReader(this.inputStream);
                reader = new BufferedReader(r);
                StringBuilder sb = new StringBuilder();
                String line = reader.readLine();
                while (line != null) {
                    sb.append(line).append('\n');
                    line = reader.readLine();
                }
                this.source = sb.toString();
            }
        }
        this.features = new ArrayList<Feature>();
        StringInput input = new StringInput(this.source);
        ASTNode node = null;
        TokenInput tokenInput = null;
        try {
            Language nbsLanguage = NBSLanguage.getNBSLanguage();
            tokenInput = TokenInputUtils.create(nbsLanguage, nbsLanguage.getParser(), input);
            node = nbsLanguage.getAnalyser().read(tokenInput, false, new ArrayList<SyntaxError>(), new boolean[]{false});
        }
        catch (ParseException ex) {
            Point p = Utils.findPosition(this.source, tokenInput.getOffset());
            throw new ParseException(this.sourceName + " " + p.x + "," + p.y + ": " + ex.getMessage());
        }
        this.readBody(node);
    }

    private void readBody(ASTNode root) throws ParseException {
        this.grammarTree = new GRNode();
        HashSet<String> skipTokenTypes = new HashSet<String>();
        for (ASTItem item : root.getChildren()) {
            if (item instanceof ASTToken) continue;
            ASTNode node = (ASTNode)item;
            if (node.getNT().equals("token")) {
                this.readToken(node, null);
                continue;
            }
            if (node.getNT().equals("tokenState")) {
                this.readTokenState(node);
                continue;
            }
            if (node.getNT().equals("grammarRule")) {
                this.readGrammarRule(node, this.grammarTree);
                continue;
            }
            if (node.getNT().equals("command")) {
                this.readCommand(node, skipTokenTypes);
                continue;
            }
            throw new ParseException("Unknown grammar rule (" + node.getNT() + ").");
        }
    }

    private void readToken(ASTNode node, String state) throws ParseException {
        String startState = null;
        String endState = null;
        Pattern pattern = null;
        Feature properties = null;
        String name = node.getTokenType("identifier").getIdentifier();
        ASTNode pnode = node.getNode("token2.properties");
        if (pnode != null) {
            properties = this.readProperties(null, null, pnode);
            startState = (String)properties.getValue("start_state");
            endState = (String)properties.getValue("end_state");
            pattern = properties.getPattern("pattern");
            if (pattern == null && properties.getType("call") == Feature.Type.METHOD_CALL) {
                pattern = Pattern.create(".");
            }
        } else {
            ASTNode regularExpressionNode = node.getNode("token2.regularExpression");
            endState = node.getTokenTypeIdentifier("token2.token3.state.identifier");
            pattern = this.readPattern(regularExpressionNode, regularExpressionNode.getOffset());
        }
        if (startState != null && state != null) {
            throw new ParseException("Start state should not be specified inside token group block!");
        }
        if (startState == null) {
            startState = state;
        }
        if (endState == null) {
            endState = state;
        }
        this.addToken(startState, pattern, name, endState, properties);
    }

    private void addToken(String startState, Pattern pattern, String typeName, String endState, Feature properties) {
        this.containsTokens = true;
        int id = this.tokenTypeToID.size();
        if (this.tokenTypeToID.containsKey(typeName)) {
            id = this.tokenTypeToID.get(typeName);
        } else {
            this.tokenTypeToID.put(typeName, id);
        }
        this.tokenTypes.add(new TokenType(startState, pattern, typeName, id, endState, this.tokenTypes.size(), properties));
    }

    private void readGrammarRule(ASTNode node, GRNode grammarRules) {
        String nt = node.getTokenTypeIdentifier("identifier");
        ASTNode rightSide = node.getNode("grRightSide");
        if (rightSide.getChildren().size() == 0) {
            grammarRules.get(nt).setFinal();
        } else {
            NBSLanguageReader.resolveGrammarRule(nt, rightSide, new Franta(), grammarRules, null);
        }
    }

    private static GRNode resolveGrammarRule(String nt, ASTNode rightSide, Franta franta, GRNode ntToMap, GRNode right) {
        for (ASTItem o : rightSide.getChildren()) {
            GRNode right2;
            String nt2;
            GRNode right1;
            String nt1;
            String op;
            int i;
            if (o instanceof ASTToken) continue;
            ASTNode n = (ASTNode)o;
            if (n.getNT().equals("grRightSide1")) {
                NBSLanguageReader.resolveGrammarRule(nt, n, franta, ntToMap, right);
                continue;
            }
            if (n.getNT().equals("grChoice")) {
                right = NBSLanguageReader.resolveGrammarRule(nt, n, franta, ntToMap, ntToMap.get(nt));
                right.setFinal();
                continue;
            }
            if (!n.getNT().equals("grPart")) continue;
            List<ASTItem> ch = n.getChildren();
            for (i = 0; i < ch.size() && NBSLanguageReader.skip(ch.get(i)); ++i) {
            }
            if (ch.get(i) instanceof ASTNode) {
                String token = NBSLanguageReader.readToken((ASTNode)ch.get(i));
                ++i;
                while (i < ch.size() && NBSLanguageReader.skip(ch.get(i))) {
                    ++i;
                }
                if (i < ch.size()) {
                    op = ((ASTNode)ch.get(i)).getTokenTypeIdentifier("operator");
                    if (op != null) {
                        nt1 = franta.next(nt);
                        right = right.get(nt1);
                        if ("*".equals(op)) {
                            right1 = ntToMap.get(nt1);
                            right1.setFinal();
                            right1 = right1.get(token);
                            right1 = right1.get(nt1);
                            right1.setFinal();
                            continue;
                        }
                        if (!"+".equals(op)) continue;
                        right1 = ntToMap.get(nt1);
                        nt2 = franta.next(nt);
                        right1 = right1.get(token);
                        right1 = right1.get(nt2);
                        right1.setFinal();
                        right2 = ntToMap.get(nt2);
                        right2.setFinal();
                        right2 = right2.get(token);
                        right2 = right2.get(nt2);
                        right2.setFinal();
                        continue;
                    }
                    right = right.get(token);
                    continue;
                }
                right = right.get(token);
                continue;
            }
            ASTToken t = (ASTToken)ch.get(i);
            if (t.getIdentifier().equals("(")) {
                String nt22;
                GRNode right12;
                op = n.getTokenTypeIdentifier("grOperator.operator");
                nt1 = franta.next(nt);
                right = right.get(nt1);
                ASTNode nn = n.getNode("grRightSide");
                if ("*".equals(op)) {
                    right12 = ntToMap.get(nt1);
                    nt22 = franta.next(nt);
                    right12.setFinal();
                    right12 = right12.get(nt22);
                    right12 = right12.get(nt1);
                    right12.setFinal();
                    GRNode right22 = ntToMap.get(nt22);
                    NBSLanguageReader.resolveGrammarRule(nt22, nn, franta, ntToMap, right22);
                    continue;
                }
                if ("+".equals(op)) {
                    right12 = ntToMap.get(nt1);
                    nt22 = franta.next(nt);
                    String nt3 = franta.next(nt);
                    right12 = right12.get(nt22);
                    right12 = right12.get(nt3);
                    right12.setFinal();
                    GRNode right3 = ntToMap.get(nt3);
                    right3.setFinal();
                    right3 = right3.get(nt22);
                    right3 = right3.get(nt3);
                    right3.setFinal();
                    GRNode right23 = ntToMap.get(nt22);
                    NBSLanguageReader.resolveGrammarRule(nt22, nn, franta, ntToMap, right23);
                    continue;
                }
                right12 = ntToMap.get(nt1);
                NBSLanguageReader.resolveGrammarRule(nt1, nn, franta, ntToMap, right12);
                continue;
            }
            if (t.getIdentifier().equals("[")) {
                String nnt = franta.next(nt);
                right = right.get(nnt);
                ASTNode nn = n.getNode("grRightSide");
                NBSLanguageReader.resolveGrammarRule(nnt, nn, franta, ntToMap, null);
                ntToMap.get(nnt).setFinal();
                continue;
            }
            ++i;
            while (i < ch.size() && NBSLanguageReader.skip(ch.get(i))) {
                ++i;
            }
            if (i < ch.size()) {
                op = ((ASTNode)ch.get(i)).getTokenTypeIdentifier("operator");
                if (op != null) {
                    nt1 = franta.next(nt);
                    right = right.get(nt1);
                    if ("*".equals(op)) {
                        right1 = ntToMap.get(nt1);
                        right1.setFinal();
                        right1 = right1.get(t.getIdentifier());
                        right1 = right1.get(nt1);
                        right1.setFinal();
                        continue;
                    }
                    if (!"+".equals(op)) continue;
                    right1 = ntToMap.get(nt1);
                    nt2 = franta.next(nt);
                    right1 = right1.get(t.getIdentifier());
                    right1 = right1.get(nt2);
                    right1.setFinal();
                    right2 = ntToMap.get(nt2);
                    right2.setFinal();
                    right2 = right2.get(t.getIdentifier());
                    right2 = right2.get(nt2);
                    right2.setFinal();
                    continue;
                }
                right = right.get(t.getIdentifier());
                continue;
            }
            right = right.get(t.getIdentifier());
        }
        return right;
    }

    private static boolean skip(ASTItem item) {
        if (item instanceof ASTNode) {
            return false;
        }
        int type = ((ASTToken)item).getTypeID();
        if (NBSLanguage.WHITESPACE_ID == type) {
            return true;
        }
        return NBSLanguage.COMMENT_ID == type;
    }

    private static String readToken(ASTNode node) {
        StringBuilder sb = new StringBuilder();
        String type = node.getTokenTypeIdentifier("identifier");
        if (type != null) {
            sb.append(type);
        }
        sb.append('#');
        String identifier = node.getTokenTypeIdentifier("tokenDef1.string");
        if (identifier != null) {
            sb.append(identifier);
        }
        return sb.toString();
    }

    private List<Rule> createRules(GRNode grammar, Language language) throws ParseException {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (String nt : grammar.names()) {
            GRNode right = grammar.get(nt);
            this.resolveNT(nt, 0, right, new ArrayList(), rules, language);
        }
        return rules;
    }

    private void resolveNT(String nt, int id, GRNode grNode, List right, List<Rule> rules, Language language) throws ParseException {
        while (true) {
            Set<String> names = grNode.names();
            if (!grNode.isFinal() && names.isEmpty()) {
                throw new IllegalArgumentException();
            }
            if (grNode.isFinal()) {
                NBSLanguageReader.addRule(nt, id, new ArrayList(right), rules);
            }
            if (names.isEmpty()) {
                return;
            }
            if (names.size() > 1) break;
            String name = names.iterator().next();
            this.addItem(right, name, language);
            grNode = grNode.get(name);
        }
        if (!right.isEmpty()) {
            right.add(nt + "#" + (id + 1));
            NBSLanguageReader.addRule(nt, id, right, rules);
            ++id;
            for (String name : grNode.names()) {
                right = new ArrayList();
                this.addItem(right, name, language);
                this.resolveNT(nt, id, grNode.get(name), right, rules, language);
            }
        } else {
            for (String name : grNode.names()) {
                right = new ArrayList<String>();
                this.addItem(right, name, language);
                this.resolveNT(nt, id, grNode.get(name), right, rules, language);
            }
        }
    }

    private void addItem(List l, String n, Language language) throws ParseException {
        String identifier;
        int typeID;
        if (n.startsWith("\"") || n.startsWith("'")) {
            l.add(ASTToken.create(language, -1, n.substring(1, n.length() - 1), 0));
            return;
        }
        int i = n.indexOf(35);
        if (i < 0) {
            l.add(n);
            return;
        }
        String type = n.substring(0, i);
        int n2 = typeID = type.length() > 0 ? language.getTokenID(type) : -1;
        if (typeID < 0) {
            throw new ParseException(this.sourceName + ": Token '" + type + "' not defined!");
        }
        if ((identifier = n.substring(++i)).length() > 0) {
            identifier = identifier.substring(1, identifier.length() - 1);
        }
        l.add(ASTToken.create(language, typeID, identifier.length() > 0 ? identifier : null, 0));
    }

    private static void addRule(String nt, int id, List right, List<Rule> rules) {
        if (id > 0) {
            nt = nt + "#" + id;
        }
        rules.add(Rule.create(nt, right));
    }

    private void readTokenState(ASTNode node) throws ParseException {
        String startState = node.getTokenTypeIdentifier("state.identifier");
        ASTNode n = node.getNode("tokenState1.token");
        if (n != null) {
            this.readToken(n, startState);
        } else {
            this.readTokenGroup(node.getNode("tokenState1.tokenGroup"), startState);
        }
    }

    private void readTokenGroup(ASTNode node, String startState) throws ParseException {
        for (ASTItem o : node.getNode("tokensInGroup").getChildren()) {
            if (o instanceof ASTToken) continue;
            ASTNode n = (ASTNode)o;
            this.readToken(n, startState);
        }
    }

    private void readCommand(ASTNode commandNode, Set<String> skipTokenTypes) throws ParseException {
        String keyword = commandNode.getTokenTypeIdentifier("keyword");
        ASTNode command0Node = commandNode.getNode("command0");
        ASTNode selectorNode = command0Node.getNode("selector");
        if (selectorNode != null) {
            for (Selector selector : NBSLanguageReader.readSelector(selectorNode)) {
                ASTNode command1Node = command0Node.getNode("command1");
                ASTNode valueNode = command1Node.getNode("value");
                if (valueNode != null) {
                    this.features.add(this.readValue(keyword, selector, valueNode));
                    continue;
                }
                this.features.add(Feature.create(keyword, selector));
            }
        } else {
            ASTNode valueNode = command0Node.getNode("value");
            this.features.add(this.readValue(keyword, null, valueNode));
        }
    }

    private Feature readValue(String keyword, Selector selector, ASTNode valueNode) throws ParseException {
        ASTNode propertiesNode = valueNode.getNode("properties");
        if (propertiesNode != null) {
            return this.readProperties(keyword, selector, propertiesNode);
        }
        ASTNode classNode = valueNode.getNode("class");
        if (classNode != null) {
            return Feature.createMethodCallFeature(keyword, selector, NBSLanguageReader.readClass(classNode));
        }
        ASTNode regExprNode = valueNode.getNode("regularExpression");
        if (regExprNode != null) {
            Pattern pat = this.readPattern(regExprNode, regExprNode.getOffset());
            return Feature.createExpressionFeature(keyword, selector, pat);
        }
        String s = valueNode.getTokenTypeIdentifier("string");
        s = s.substring(1, s.length() - 1);
        return Feature.createExpressionFeature(keyword, selector, NBSLanguageReader.c(s));
    }

    private Feature readProperties(String keyword, Selector selector, ASTNode node) throws ParseException {
        HashMap<String, String> methods = new HashMap<String, String>();
        HashMap<String, String> expressions = new HashMap<String, String>();
        HashMap<String, Pattern> patterns = new HashMap<String, Pattern>();
        for (ASTItem o : node.getChildren()) {
            if (o instanceof ASTToken) continue;
            ASTNode n = (ASTNode)o;
            String key = n.getTokenTypeIdentifier("identifier");
            String value = n.getTokenTypeIdentifier("propertyValue.string");
            if (value != null) {
                value = value.substring(1, value.length() - 1);
                expressions.put(key, NBSLanguageReader.c(value));
                continue;
            }
            if (n.getNode("propertyValue.class") != null) {
                value = NBSLanguageReader.readClass(n.getNode("propertyValue.class"));
                methods.put(key, value);
                continue;
            }
            ASTNode regularExpressionNode = n.getNode("propertyValue.regularExpression");
            Pattern pattern = this.readPattern(regularExpressionNode, n.getOffset());
            patterns.put(key, pattern);
        }
        return Feature.create(keyword, selector, expressions, methods, patterns);
    }

    private static List<Selector> readSelector(ASTNode selectorNode) {
        return NBSLanguageReader.readSelector(selectorNode, new ArrayList<Selector>());
    }

    private static List<Selector> readSelector(ASTNode selectorNode, List<Selector> result) {
        for (ASTItem item : selectorNode.getChildren()) {
            if (!(item instanceof ASTNode)) continue;
            ASTNode node = (ASTNode)item;
            if (node.getNT().equals("class")) {
                result.add(Selector.create(NBSLanguageReader.readClass(node)));
                continue;
            }
            if (!node.getNT().equals("selector1")) continue;
            NBSLanguageReader.readSelector(node, result);
        }
        return result;
    }

    private static String readClass(ASTNode cls) {
        StringBuilder sb = new StringBuilder();
        sb.append(cls.getTokenTypeIdentifier("identifier"));
        for (ASTToken aSTToken : cls.getNode("class1").getChildren()) {
            if (aSTToken.getIdentifier().equals(".")) {
                sb.append('.');
                continue;
            }
            if (aSTToken.getTypeID() != NBSLanguage.IDENTIFIER_ID) continue;
            sb.append(aSTToken.getIdentifier());
        }
        return sb.toString();
    }

    private Pattern readPattern(ASTNode node, int offset) throws ParseException {
        StringBuilder sb = new StringBuilder();
        NBSLanguageReader.getText(node, sb);
        String pattern = sb.toString();
        StringInput input = new StringInput(pattern);
        try {
            return Pattern.create(input);
        }
        catch (ParseException e) {
            Point p = Utils.findPosition(this.source, offset + input.getIndex());
            throw new ParseException(this.sourceName + " " + p.x + "," + p.y + ": " + e.getMessage());
        }
    }

    private static void getText(ASTItem item, StringBuilder sb) {
        for (ASTItem elem : item.getChildren()) {
            if (elem instanceof ASTNode) {
                NBSLanguageReader.getText(elem, sb);
                continue;
            }
            ASTToken token = (ASTToken)elem;
            int typeID = token.getTypeID();
            if (typeID == NBSLanguage.COMMENT_ID || typeID == NBSLanguage.WHITESPACE_ID) continue;
            sb.append(token.getIdentifier());
        }
    }

    private static String c(String s) {
        s = s.replace("\\n", "\n");
        s = s.replace("\\r", "\r");
        s = s.replace("\\t", "\t");
        s = s.replace("\\\"", "\"");
        s = s.replace("\\'", "'");
        s = s.replace("\\\\", "\\");
        return s;
    }

    static class Franta {
        private int i = 1;

        Franta() {
        }

        String next(String nt) {
            return nt + '$' + this.i++;
        }
    }

    private static class GRNode {
        private boolean isFinal = false;
        private Map<String, GRNode> map;

        private GRNode() {
        }

        GRNode get(String name) {
            GRNode result;
            if (this.map == null) {
                this.map = new HashMap<String, GRNode>();
            }
            if ((result = this.map.get(name)) == null) {
                result = new GRNode();
                this.map.put(name, result);
            }
            return result;
        }

        Set<String> names() {
            if (this.map == null) {
                return Collections.emptySet();
            }
            return this.map.keySet();
        }

        void setFinal() {
            this.isFinal = true;
        }

        boolean isFinal() {
            return this.isFinal;
        }

        void put(String name, GRNode node) {
            if (this.map == null) {
                this.map = new HashMap<String, GRNode>();
            }
            this.map.put(name, node);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb, null);
            return sb.toString();
        }

        private void toString(StringBuilder sb, StringBuilder prefix) {
            if (this.isFinal) {
                sb.append((CharSequence)prefix).append('\n');
            }
            if (!this.isFinal && this.map == null) {
                sb.append((CharSequence)prefix).append('?').append('\n');
            }
            if (this.map == null) {
                return;
            }
            for (String name : this.map.keySet()) {
                if (prefix == null) {
                    this.map.get(name).toString(sb, new StringBuilder(name).append(" ="));
                    continue;
                }
                this.map.get(name).toString(sb, new StringBuilder(prefix).append(' ').append(name));
            }
        }
    }
}

