/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.viewmodel;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import org.netbeans.spi.viewmodel.AsynchronousModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public abstract class CachedChildrenTreeModel
implements TreeModel,
AsynchronousModelFilter {
    private final Map<Object, ChildrenTree> childrenCache = new WeakHashMap<Object, ChildrenTree>();
    private final Set<Object> childrenToRefresh = new HashSet<Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Executor asynchronous(Executor original, AsynchronousModelFilter.CALL asynchCall, Object node) throws UnknownTypeException {
        boolean cache;
        if (AsynchronousModelFilter.CALL.CHILDREN.equals((Object)asynchCall) && (cache = this.cacheChildrenOf(node))) {
            Map<Object, ChildrenTree> map = this.childrenCache;
            synchronized (map) {
                if (this.childrenToRefresh.remove(node)) {
                    this.childrenCache.remove(node);
                    return original;
                }
                if (this.childrenCache.containsKey(node)) {
                    return AsynchronousModelFilter.CURRENT_THREAD;
                }
            }
        }
        return original;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object[] getChildren(Object o, int from, int to) throws UnknownTypeException {
        Object ch;
        ChildrenTree cht;
        Map<Object, ChildrenTree> map;
        boolean cache = this.cacheChildrenOf(o);
        if (cache) {
            map = this.childrenCache;
            synchronized (map) {
                if (this.childrenToRefresh.remove(o)) {
                    this.childrenCache.remove(o);
                    cht = null;
                } else {
                    cht = this.childrenCache.get(o);
                }
            }
            ch = cht != null ? cht.getChildren() : null;
        } else {
            ch = null;
        }
        if (ch == null) {
            ch = this.computeChildren(o);
            if (ch == null) {
                throw new UnknownTypeException(o);
            }
            if (cache) {
                cht = new ChildrenTree(o);
                cht.setChildren((Object[])ch);
                map = this.childrenCache;
                synchronized (map) {
                    this.childrenCache.put(o, cht);
                }
            }
        }
        ch = this.reorder((Object[])ch);
        int l = ((Object[])ch).length;
        from = Math.min(l, from);
        to = Math.min(l, to);
        if (from == 0 && to == l) {
            return ch;
        }
        Object[] ch1 = new Object[to - from];
        System.arraycopy(ch, from, ch1, 0, to - from);
        ch = ch1;
        return ch;
    }

    protected abstract Object[] computeChildren(Object var1) throws UnknownTypeException;

    protected boolean cacheChildrenOf(Object node) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void refreshCache(Object node) {
        Map<Object, ChildrenTree> map = this.childrenCache;
        synchronized (map) {
            this.childrenToRefresh.add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clearCache() {
        Map<Object, ChildrenTree> map = this.childrenCache;
        synchronized (map) {
            this.childrenCache.clear();
            this.childrenToRefresh.clear();
        }
    }

    protected Object[] reorder(Object[] nodes) {
        return nodes;
    }

    protected final void recomputeChildren() throws UnknownTypeException {
        this.recomputeChildren(this.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void recomputeChildren(Object node) throws UnknownTypeException {
        Set<Object> keys;
        ChildrenTree cht;
        Map<Object, ChildrenTree> map = this.childrenCache;
        synchronized (map) {
            cht = this.childrenCache.get(node);
            keys = this.childrenCache.keySet();
        }
        if (cht != null) {
            Object[] oldCh = cht.getChildren();
            Object[] newCh = this.computeChildren(node);
            cht.setChildren(newCh);
            for (int i = 0; i < newCh.length; ++i) {
                if (!keys.contains(newCh[i])) continue;
                this.recomputeChildren(newCh[i]);
            }
        }
    }

    private static final class ChildrenTree {
        private Object[] ch;

        public ChildrenTree(Object node) {
        }

        public void setChildren(Object[] ch) {
            this.ch = ch;
        }

        public Object[] getChildren() {
            return this.ch;
        }
    }
}

