/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.web.wizards.BaseWizardPanel;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.InitParamPanel;
import org.netbeans.modules.web.wizards.MappingPanel;
import org.netbeans.modules.web.wizards.ServletData;
import org.netbeans.modules.web.wizards.TargetEvaluator;
import org.netbeans.modules.web.wizards.Utilities;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

class DeployDataPanel
extends BaseWizardPanel
implements ItemListener {
    private TargetEvaluator evaluator = null;
    private ServletData deployData;
    private FileType fileType;
    private boolean edited = false;
    private TemplateWizard wizard;
    private JPanel myDescriptorCheckBoxPanel;
    private JCheckBox jCBservlet;
    private JTextField jTFclassname;
    private JTextField jTFname;
    private JTextField jTFmapping;
    private JLabel jLinstruction;
    private JLabel jLclassname;
    private JLabel jLname;
    private JLabel jLmapping;
    private InitParamPanel paramPanel;
    private MappingPanel mappingPanel;
    private static final long serialVersionUID = -2704206901170711687L;

    public DeployDataPanel(TargetEvaluator e, TemplateWizard wizard) {
        this.evaluator = e;
        this.wizard = wizard;
        this.fileType = this.evaluator.getFileType();
        this.deployData = (ServletData)this.evaluator.getDeployData();
        this.setName(NbBundle.getMessage(DeployDataPanel.class, (String)("TITLE_ddpanel_" + this.fileType)));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeployDataPanel.class, (String)"ACSD_deployment"));
        this.initComponents();
        if (!Utilities.isJavaEE6Plus(wizard)) {
            this.myDescriptorCheckBoxPanel.remove(this.jCBservlet);
        }
        this.fireChangeEvent();
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(450, 250));
        this.setLayout(new GridBagLayout());
        GridBagConstraints fullRowC = new GridBagConstraints();
        fullRowC.gridx = 0;
        fullRowC.gridy = -1;
        fullRowC.gridwidth = 8;
        fullRowC.anchor = 17;
        fullRowC.fill = 2;
        fullRowC.insets = new Insets(4, 0, 4, 0);
        GridBagConstraints firstC = new GridBagConstraints();
        firstC.gridx = 0;
        firstC.gridy = -1;
        firstC.gridwidth = 1;
        firstC.anchor = 17;
        firstC.insets = new Insets(4, 20, 4, 0);
        GridBagConstraints tfC = new GridBagConstraints();
        tfC.gridx = -1;
        tfC.gridy = 0;
        tfC.gridwidth = 7;
        tfC.fill = 2;
        tfC.insets = new Insets(4, 20, 4, 0);
        GridBagConstraints stfC = new GridBagConstraints();
        stfC.gridx = -1;
        stfC.gridy = 0;
        stfC.gridwidth = 5;
        stfC.weightx = 1.0;
        stfC.fill = 2;
        stfC.insets = new Insets(4, 20, 4, 0);
        GridBagConstraints tablePanelC = new GridBagConstraints();
        tablePanelC.gridx = 0;
        tablePanelC.gridy = -1;
        tablePanelC.gridwidth = 8;
        tablePanelC.fill = 1;
        tablePanelC.weightx = 1.0;
        tablePanelC.weighty = 1.0;
        tablePanelC.insets = new Insets(4, 20, 4, 0);
        this.jLinstruction = new JLabel(NbBundle.getMessage(DeployDataPanel.class, (String)("LBL_dd_" + this.fileType)));
        this.add((Component)this.jLinstruction, fullRowC);
        ++tfC.gridy;
        this.myDescriptorCheckBoxPanel = new JPanel();
        this.myDescriptorCheckBoxPanel.setLayout(new FlowLayout(0, 0, 0));
        this.jCBservlet = new JCheckBox(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_addtodd"), true);
        this.jCBservlet.setMnemonic(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_add_mnemonic").charAt(0));
        this.jCBservlet.addItemListener(this);
        this.jCBservlet.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeployDataPanel.class, (String)"ACSD_addtodd"));
        this.myDescriptorCheckBoxPanel.add(this.jCBservlet);
        this.add((Component)this.myDescriptorCheckBoxPanel, fullRowC);
        ++tfC.gridy;
        this.jTFclassname = new JTextField(25);
        this.jTFclassname.setEnabled(false);
        this.jLclassname = new JLabel(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_ClassName"));
        this.jLclassname.setLabelFor(this.jTFclassname);
        this.jLclassname.setDisplayedMnemonic(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_Class_Mnemonic").charAt(0));
        this.jTFclassname.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeployDataPanel.class, (String)"ACSD_ClassName"));
        this.add((Component)this.jLclassname, firstC);
        this.add((Component)this.jTFclassname, tfC);
        ++tfC.gridy;
        this.jTFname = new JTextField(25);
        this.jTFname.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeployDataPanel.class, (String)("ACSD_name_" + this.fileType)));
        this.jTFname.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                Mutex.EVENT.readAccess(new Runnable(){

                    @Override
                    public void run() {
                        DeployDataPanel.this.deployData.setName(DeployDataPanel.this.jTFname.getText().trim());
                        if (DeployDataPanel.this.fileType == FileType.FILTER) {
                            DeployDataPanel.this.mappingPanel.setData();
                        }
                        DeployDataPanel.this.fireChangeEvent();
                    }
                });
            }
        });
        this.jTFname.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.jTFname.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DeployDataPanel.this.jTFname.selectAll();
            }
        });
        this.jLname = new JLabel(NbBundle.getMessage(DeployDataPanel.class, (String)("LBL_name_" + this.fileType)));
        this.jLname.setLabelFor(this.jTFname);
        this.jLname.setDisplayedMnemonic(NbBundle.getMessage(DeployDataPanel.class, (String)("LBL_name_" + this.fileType + "_mnem")).charAt(0));
        this.add((Component)this.jLname, firstC);
        this.add((Component)this.jTFname, tfC);
        if (this.fileType == FileType.SERVLET) {
            ++tfC.gridy;
            this.jTFmapping = new JTextField(25);
            this.jTFmapping.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DeployDataPanel.class, (String)"ACSD_url_mapping"));
            this.jTFmapping.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    Mutex.EVENT.readAccess(new Runnable(){

                        @Override
                        public void run() {
                            DeployDataPanel.this.deployData.parseUrlMappingString(DeployDataPanel.this.jTFmapping.getText().trim());
                            DeployDataPanel.this.fireChangeEvent();
                        }
                    });
                }
            });
            this.jTFmapping.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
            this.jTFmapping.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent evt) {
                    DeployDataPanel.this.jTFmapping.selectAll();
                }

                @Override
                public void focusLost(FocusEvent evt) {
                    DeployDataPanel.this.deployData.parseUrlMappingString(DeployDataPanel.this.jTFmapping.getText().trim());
                    DeployDataPanel.this.fireChangeEvent();
                }
            });
            this.jLmapping = new JLabel(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_url_mapping"));
            this.jLmapping.setLabelFor(this.jTFmapping);
            this.jLmapping.setDisplayedMnemonic(NbBundle.getMessage(DeployDataPanel.class, (String)"LBL_mapping_mnemonic").charAt(0));
            this.add((Component)this.jLmapping, firstC);
            this.add((Component)this.jTFmapping, tfC);
        }
        if (this.fileType == FileType.SERVLET) {
            this.paramPanel = new InitParamPanel(this.deployData, this, this.wizard);
            this.add((Component)this.paramPanel, tablePanelC);
        } else if (this.fileType == FileType.FILTER) {
            this.mappingPanel = new MappingPanel(this.deployData, this, this.wizard);
            this.add((Component)this.mappingPanel, tablePanelC);
        }
        GridBagConstraints fillerC = new GridBagConstraints();
        fillerC.gridx = 0;
        fillerC.gridy = -1;
        fillerC.weighty = 1.0;
        fillerC.fill = 1;
        this.add((Component)new JPanel(), fillerC);
    }

    @Override
    void setData() {
        String displayName = null;
        DataObject templateDo = this.wizard.getTemplate();
        displayName = templateDo.getNodeDelegate().getDisplayName();
        this.wizard.putProperty("NewFileWizard_Title", (Object)displayName);
        this.deployData.setClassName(this.evaluator.getClassName());
        this.jTFclassname.setText(this.deployData.getClassName());
        if (!this.edited) {
            this.deployData.setName(this.evaluator.getFileName());
            if (this.fileType == FileType.SERVLET) {
                this.deployData.parseUrlMappingString("/" + ServletData.getRFC2396URI(this.evaluator.getFileName()));
            }
        }
        this.jTFname.setText(this.deployData.getName());
        if (this.fileType == FileType.SERVLET) {
            this.jTFmapping.setText(this.deployData.getUrlMappingsAsString());
        } else if (this.fileType == FileType.FILTER) {
            this.mappingPanel.setData();
        }
        if (Utilities.isJavaEE6Plus(this.wizard)) {
            this.jCBservlet.setSelected(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.jCBservlet) {
            boolean enabled = itemEvent.getStateChange() == 1;
            this.deployData.setMakeEntry(enabled);
            this.enableInput(enabled || Utilities.isJavaEE6Plus(this.wizard));
        }
        this.fireChangeEvent();
    }

    private void enableInput(boolean enable) {
        this.jTFname.setEnabled(enable);
        this.jLinstruction.setEnabled(enable);
        this.jLclassname.setEnabled(enable);
        this.jLname.setEnabled(enable);
        if (this.fileType == FileType.SERVLET) {
            this.jTFmapping.setEnabled(enable);
            this.jLmapping.setEnabled(enable);
            this.paramPanel.setEnabled(enable);
        } else if (this.fileType == FileType.FILTER) {
            this.mappingPanel.setEnabled(enable);
        }
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx(this.getClass().getName() + "." + this.evaluator.getFileType().toString());
    }
}

