/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder.impl;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLStreamHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.openide.util.BaseUtilities;

public class MavenProtocolHandler
extends URLStreamHandler {
    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
        Artifact a = MavenProtocolHandler.resolveM2Url(u, online);
        try {
            online.resolve(a, Collections.singletonList(online.createRemoteRepository("https://repo.maven.apache.org/maven2", "central")), online.getLocalRepository());
        }
        catch (RuntimeException | ArtifactNotFoundException | ArtifactResolutionException x) {
            throw new IOException(u + ": " + x, x);
        }
        File f = a.getFile();
        if (!f.isFile()) {
            throw new IOException("failed to download " + u);
        }
        Logger.getLogger(MavenProtocolHandler.class.getName()).log(Level.FINE, "resolved {0} -> {1}", new Object[]{u, f});
        return BaseUtilities.toURI((File)f).toURL().openConnection();
    }

    static Artifact resolveM2Url(URL u, MavenEmbedder online) throws IOException {
        Artifact a;
        String path = u.getPath();
        if (!path.startsWith("/")) {
            throw new IOException(path);
        }
        String stuff = path.substring(1);
        String[] pieces = Arrays.stream(stuff.split(":")).map(MavenProtocolHandler::urlDecode).collect(Collectors.toList()).toArray(new String[0]);
        if (pieces.length == 4) {
            a = online.createArtifact(pieces[0], pieces[1], pieces[2], pieces[3]);
        } else if (pieces.length == 5) {
            a = online.createArtifactWithClassifier(pieces[0], pieces[1], pieces[2], pieces[3], pieces[4]);
        } else {
            throw new IOException(stuff);
        }
        return a;
    }

    private static String urlDecode(String input) {
        try {
            return URLDecoder.decode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

