/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.iface2;

import agent.dbgeng.manager.breakpoint.DbgBreakpointInfo;
import agent.dbgeng.model.iface1.DbgModelTargetBptHelper;
import agent.dbgeng.model.iface2.DbgModelTargetObject;
import agent.dbgeng.model.iface2.DbgModelTargetThread;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetDeletable;
import ghidra.dbg.target.TargetObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressSpace;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface DbgModelTargetBreakpointSpec
extends DbgModelTargetObject,
TargetBreakpointSpec,
TargetBreakpointLocation,
TargetDeletable,
DbgModelTargetBptHelper {
    public static final String BPT_ACCESS_ATTRIBUTE_NAME = "Access";
    public static final String BPT_DISP_ATTRIBUTE_NAME = "Disposition";
    public static final String BPT_PENDING_ATTRIBUTE_NAME = "Pending";
    public static final String BPT_TIMES_ATTRIBUTE_NAME = "Times";
    public static final String BPT_TYPE_ATTRIBUTE_NAME = "Type";
    public static final String BPT_INDEX_ATTRIBUTE_NAME = "Id";

    default public CompletableFuture<Void> delete() {
        return this.getModel().gateFuture(this.getManager().deleteBreakpoints(this.getNumber()));
    }

    default public CompletableFuture<Void> disable() {
        this.setEnabled(false, "Disabled");
        return this.getModel().gateFuture(this.getManager().disableBreakpoints(this.getNumber()));
    }

    default public CompletableFuture<Void> enable() {
        this.setEnabled(true, "Enabled");
        return this.getModel().gateFuture(this.getManager().enableBreakpoints(this.getNumber()));
    }

    default public String getExpression() {
        return this.getBreakpointInfo().getExpression();
    }

    default public long getNumber() {
        return this.getBreakpointInfo().getNumber();
    }

    default public TargetBreakpointSpecContainer.TargetBreakpointKindSet getKinds() {
        switch (this.getBreakpointInfo().getType()) {
            case BREAKPOINT: {
                return TargetBreakpointSpecContainer.TargetBreakpointKindSet.of((TargetBreakpointSpec.TargetBreakpointKind[])new TargetBreakpointSpec.TargetBreakpointKind[]{TargetBreakpointSpec.TargetBreakpointKind.SW_EXECUTE});
            }
            case HW_BREAKPOINT: {
                return TargetBreakpointSpecContainer.TargetBreakpointKindSet.of((TargetBreakpointSpec.TargetBreakpointKind[])new TargetBreakpointSpec.TargetBreakpointKind[]{TargetBreakpointSpec.TargetBreakpointKind.HW_EXECUTE});
            }
            case HW_WATCHPOINT: {
                return TargetBreakpointSpecContainer.TargetBreakpointKindSet.of((TargetBreakpointSpec.TargetBreakpointKind[])new TargetBreakpointSpec.TargetBreakpointKind[]{TargetBreakpointSpec.TargetBreakpointKind.WRITE});
            }
            case READ_WATCHPOINT: {
                return TargetBreakpointSpecContainer.TargetBreakpointKindSet.of((TargetBreakpointSpec.TargetBreakpointKind[])new TargetBreakpointSpec.TargetBreakpointKind[]{TargetBreakpointSpec.TargetBreakpointKind.READ});
            }
            case ACCESS_WATCHPOINT: {
                return TargetBreakpointSpecContainer.TargetBreakpointKindSet.of((TargetBreakpointSpec.TargetBreakpointKind[])new TargetBreakpointSpec.TargetBreakpointKind[]{TargetBreakpointSpec.TargetBreakpointKind.READ, TargetBreakpointSpec.TargetBreakpointKind.WRITE});
            }
        }
        return TargetBreakpointSpecContainer.TargetBreakpointKindSet.of();
    }

    @Override
    default public CompletableFuture<Void> init(Map<String, Object> map) {
        AddressSpace space = this.getModel().getAddressSpace("ram");
        return this.requestNativeAttributes().thenAccept(attrs -> {
            if (attrs != null) {
                map.putAll((Map<String, Object>)attrs);
                TargetObject addr = (TargetObject)attrs.get("Address");
                TargetObject id = (TargetObject)attrs.get(BPT_INDEX_ATTRIBUTE_NAME);
                TargetObject enabled = (TargetObject)attrs.get("IsEnabled");
                String addstr = addr.getCachedAttribute("_value").toString();
                String idstr = id.getCachedAttribute("_value").toString();
                this.setBreakpointId(idstr);
                String enstr = enabled.getCachedAttribute("_value").toString();
                try {
                    Address address = space.getAddress(addstr);
                    map.put("_address", address);
                }
                catch (AddressFormatException e) {
                    e.printStackTrace();
                }
                map.put("_spec", this);
                map.put("_expression", addstr);
                map.put("_kinds", this.getKinds());
                map.put("_enabled", enstr.equals("-1"));
                this.setEnabled(enstr.equals("-1"), "Refreshed");
                int size = this.getBreakpointInfo().getSize();
                map.put("_length", size);
                String oldval = (String)this.getCachedAttribute("_display");
                String display = "[" + idstr + "] " + addstr;
                map.put("_display", display);
                this.setModified(map, !display.equals(oldval));
            }
        });
    }

    private long orZero(Long l) {
        if (l == null) {
            return 0L;
        }
        return l;
    }

    default public Address doGetAddress() {
        DbgBreakpointInfo info = this.getBreakpointInfo();
        return this.getModel().getAddress("ram", this.orZero(info.getOffset()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void updateInfo(DbgBreakpointInfo oldInfo, DbgBreakpointInfo newInfo, String reason) {
        DbgModelTargetBreakpointSpec dbgModelTargetBreakpointSpec = this;
        synchronized (dbgModelTargetBreakpointSpec) {
            if (!2.$assertionsDisabled && oldInfo != this.getBreakpointInfo()) {
                throw new AssertionError();
            }
            this.setBreakpointInfo(newInfo);
        }
        this.setEnabled(newInfo.isEnabled(), reason);
    }

    default public void setEnabled(boolean enabled, String reason) {
        this.setBreakpointEnabled(enabled);
        this.changeAttributes(List.of(), Map.of("_enabled", enabled), reason);
    }

    default public boolean isEnabled() {
        return this.isBreakpointEnabled();
    }

    default public void addAction(TargetBreakpointSpec.TargetBreakpointAction action) {
        this.getActions().add((Object)action);
    }

    default public void removeAction(TargetBreakpointSpec.TargetBreakpointAction action) {
        this.getActions().remove((Object)action);
    }

    default public void breakpointHit() {
        DbgModelTargetThread targetThread = this.getParentProcess().getThreads().getTargetThread(this.getManager().getEventThread());
        ((TargetBreakpointSpec.TargetBreakpointAction)this.getActions().fire).breakpointHit((TargetBreakpointSpec)((DbgModelTargetBreakpointSpec)this.getProxy()), (TargetObject)targetThread, null, (TargetBreakpointLocation)this);
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }
}

