/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.datamodel.script;

import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.datamodel.script.DataModelScriptTemplate;
import agent.dbgmodel.dbgmodel.datamodel.script.DataModelScriptTemplateEnumerator;
import agent.dbgmodel.impl.dbgmodel.datamodel.script.DataModelScriptProviderInternal;
import agent.dbgmodel.impl.dbgmodel.datamodel.script.DataModelScriptTemplateEnumeratorInternal;
import agent.dbgmodel.impl.dbgmodel.datamodel.script.DataModelScriptTemplateInternal;
import agent.dbgmodel.jna.dbgmodel.datamodel.script.IDataModelScriptProvider;
import agent.dbgmodel.jna.dbgmodel.datamodel.script.WrapIDataModelScriptTemplate;
import agent.dbgmodel.jna.dbgmodel.datamodel.script.WrapIDataModelScriptTemplateEnumerator;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public class DataModelScriptProviderImpl
implements DataModelScriptProviderInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IDataModelScriptProvider jnaData;

    public DataModelScriptProviderImpl(IDataModelScriptProvider jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    @Override
    public String getName() {
        WTypes.BSTRByReference bref = new WTypes.BSTRByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetName(bref));
        WTypes.BSTR bstr = bref.getValue();
        String name = bstr.getValue();
        OleAuto.INSTANCE.SysFreeString(bstr);
        return name;
    }

    @Override
    public String getExtension() {
        WTypes.BSTRByReference bref = new WTypes.BSTRByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetExtension(bref));
        WTypes.BSTR bstr = bref.getValue();
        String extension = bstr.getValue();
        OleAuto.INSTANCE.SysFreeString(bstr);
        return extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataModelScriptTemplate createScript() {
        PointerByReference ppScript = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.CreateScript(ppScript));
        WrapIDataModelScriptTemplate wrap = new WrapIDataModelScriptTemplate(ppScript.getValue());
        try {
            DataModelScriptTemplateInternal dataModelScriptTemplateInternal = DataModelScriptTemplateInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return dataModelScriptTemplateInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataModelScriptTemplate getDefaultTemplateContent() {
        PointerByReference ppTemplateContent = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetDefaultTemplateContent(ppTemplateContent));
        WrapIDataModelScriptTemplate wrap = new WrapIDataModelScriptTemplate(ppTemplateContent.getValue());
        try {
            DataModelScriptTemplateInternal dataModelScriptTemplateInternal = DataModelScriptTemplateInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return dataModelScriptTemplateInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataModelScriptTemplateEnumerator enumerateTemplates() {
        PointerByReference ppTemplateContent = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.EnumerateTemplates(ppTemplateContent));
        WrapIDataModelScriptTemplateEnumerator wrap = new WrapIDataModelScriptTemplateEnumerator(ppTemplateContent.getValue());
        try {
            DataModelScriptTemplateEnumeratorInternal dataModelScriptTemplateEnumeratorInternal = DataModelScriptTemplateEnumeratorInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return dataModelScriptTemplateEnumeratorInternal;
        }
        finally {
            wrap.Release();
        }
    }
}

