/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.datamodel.script;

import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.main.KeyEnumerator;
import agent.dbgmodel.dbgmodel.main.KeyStore;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.impl.dbgmodel.datamodel.script.DataModelNameBinderInternal;
import agent.dbgmodel.impl.dbgmodel.main.KeyEnumeratorInternal;
import agent.dbgmodel.impl.dbgmodel.main.KeyStoreInternal;
import agent.dbgmodel.impl.dbgmodel.main.ModelObjectInternal;
import agent.dbgmodel.jna.dbgmodel.datamodel.script.IDataModelNameBinder;
import agent.dbgmodel.jna.dbgmodel.main.WrapIKeyEnumerator;
import agent.dbgmodel.jna.dbgmodel.main.WrapIKeyStore;
import agent.dbgmodel.jna.dbgmodel.main.WrapIModelObject;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public class DataModelNameBinderImpl
implements DataModelNameBinderInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IDataModelNameBinder jnaData;
    private ModelObject value;
    private KeyStore metadata;
    private ModelObject reference;

    public DataModelNameBinderImpl(IDataModelNameBinder jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindValue(ModelObject contextObject, WString name) {
        Pointer pContextObject = contextObject.getPointer();
        PointerByReference ppValue = new PointerByReference();
        PointerByReference ppMetadata = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.BindValue(pContextObject, name, ppValue, ppMetadata));
        WrapIModelObject wrap0 = new WrapIModelObject(ppMetadata.getValue());
        try {
            this.value = ModelObjectInternal.tryPreferredInterfaces(wrap0::QueryInterface);
        }
        finally {
            wrap0.Release();
        }
        WrapIKeyStore wrap1 = new WrapIKeyStore(ppMetadata.getValue());
        try {
            this.metadata = KeyStoreInternal.tryPreferredInterfaces(wrap1::QueryInterface);
        }
        finally {
            wrap1.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindReference(ModelObject contextObject, WString name) {
        Pointer pContextObject = contextObject.getPointer();
        PointerByReference ppReference = new PointerByReference();
        PointerByReference ppMetadata = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.BindReference(pContextObject, name, ppReference, ppMetadata));
        WrapIModelObject wrap0 = new WrapIModelObject(ppMetadata.getValue());
        try {
            this.reference = ModelObjectInternal.tryPreferredInterfaces(wrap0::QueryInterface);
        }
        finally {
            wrap0.Release();
        }
        WrapIKeyStore wrap1 = new WrapIKeyStore(ppMetadata.getValue());
        try {
            this.metadata = KeyStoreInternal.tryPreferredInterfaces(wrap1::QueryInterface);
        }
        finally {
            wrap1.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyEnumerator enumerateValues(ModelObject contextObject) {
        Pointer pContextObject = contextObject.getPointer();
        PointerByReference ppEnumerator = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.EnumerateValues(pContextObject, ppEnumerator));
        WrapIKeyEnumerator wrap = new WrapIKeyEnumerator(ppEnumerator.getValue());
        try {
            KeyEnumeratorInternal keyEnumeratorInternal = KeyEnumeratorInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return keyEnumeratorInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyEnumerator enumerateReferences(ModelObject contextObject) {
        Pointer pContextObject = contextObject.getPointer();
        PointerByReference ppEnumerator = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.EnumerateReferences(pContextObject, ppEnumerator));
        WrapIKeyEnumerator wrap = new WrapIKeyEnumerator(ppEnumerator.getValue());
        try {
            KeyEnumeratorInternal keyEnumeratorInternal = KeyEnumeratorInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return keyEnumeratorInternal;
        }
        finally {
            wrap.Release();
        }
    }

    public ModelObject getValue() {
        return this.value;
    }

    public KeyStore getMetadata() {
        return this.metadata;
    }

    public ModelObject getReference() {
        return this.reference;
    }
}

