/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.HiddenDockingFrame;
import docking.framework.ApplicationInformationDisplayFactory;
import docking.help.HelpDescriptor;
import generic.util.WindowUtilities;
import ghidra.framework.Application;
import ghidra.util.bean.GGlassPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.map.LazyMap;

public class DockingDialog
extends JDialog
implements HelpDescriptor {
    private static Component focusComponent;
    private static Map<String, BoundsInfo> dialogBoundsMap;
    private WindowListener windowAdapter;
    private DialogComponentProvider component;
    private boolean hasBeenFocused;
    private Runnable requestFocusRunnable = () -> {
        if (focusComponent != null) {
            focusComponent.requestFocus();
            this.hasBeenFocused = true;
        }
    };
    private DockingWindowManager owningWindowManager;
    private WindowAdapter modalFixWindowAdapter;

    private static JFrame createHiddenParentFrame(DialogComponentProvider componentProvider) {
        HiddenDockingFrame hiddenFrame = new HiddenDockingFrame(Application.getName());
        hiddenFrame.setShowingAllowed(true);
        List<Image> list = ApplicationInformationDisplayFactory.getWindowIcons();
        hiddenFrame.setIconImages(list);
        hiddenFrame.setUndecorated(true);
        hiddenFrame.setBounds(-500, -500, 10, 10);
        hiddenFrame.setVisible(true);
        return hiddenFrame;
    }

    public static DockingDialog createDialog(Window parent, DialogComponentProvider comp, Component centeredOnComponent) {
        if (parent instanceof Dialog) {
            return new DockingDialog((Dialog)parent, comp, centeredOnComponent);
        }
        if (parent instanceof Frame) {
            return new DockingDialog((Frame)parent, comp, centeredOnComponent);
        }
        return new DockingDialog(comp, centeredOnComponent);
    }

    private DockingDialog(Dialog parent, DialogComponentProvider comp, Component centeredOnComponent) {
        super(parent, comp.getTitle(), comp.isModal());
        this.owningWindowManager = DockingWindowManager.getInstance(parent);
        this.init(comp);
        this.initializeLocationAndSize(centeredOnComponent);
    }

    private DockingDialog(Frame parent, DialogComponentProvider comp, Component centeredOnComponent) {
        super(parent, comp.getTitle(), comp.isModal());
        this.owningWindowManager = DockingWindowManager.getInstance(parent);
        this.init(comp);
        this.initializeLocationAndSize(centeredOnComponent);
    }

    private DockingDialog(DialogComponentProvider comp, Component centeredOnComponent) {
        super(DockingDialog.createHiddenParentFrame(comp), comp.getTitle(), comp.isModal());
        this.init(comp);
        this.initializeLocationAndSize(centeredOnComponent);
    }

    private void initializeLocationAndSize(Component centeredOnComponent) {
        String key = this.getKey();
        BoundsInfo boundsInfo = dialogBoundsMap.get(key);
        Rectangle lastBounds = boundsInfo.getEndBounds();
        this.applySize(lastBounds);
        Point initialLocation = this.component.getIntialLocation();
        if (initialLocation != null) {
            this.setLocation(initialLocation);
            this.setLocation(initialLocation);
        } else if (centeredOnComponent != null) {
            this.setCenteredOnComponent(centeredOnComponent);
        } else {
            this.setCenteredOnComponent(this.getParent());
        }
        boundsInfo.setStartBounds(new Rectangle(this.getBounds()));
        if (boundsInfo.hasBeenMoved()) {
            this.applyLocation(lastBounds);
        }
    }

    private void applySize(Rectangle savedBounds) {
        boolean rememberSize = this.component.getRemberSize();
        if (rememberSize && savedBounds != null) {
            this.setSize(savedBounds.width, savedBounds.height);
            return;
        }
        Dimension defaultSize = this.component.getDefaultSize();
        if (defaultSize != null) {
            this.setSize(defaultSize);
        }
    }

    private void applyLocation(Rectangle savedBounds) {
        if (savedBounds == null) {
            return;
        }
        boolean rememberLocation = this.component.getRememberLocation();
        if (!rememberLocation) {
            return;
        }
        this.setLocation(savedBounds.x, savedBounds.y);
    }

    private String getKey() {
        Object scopeObject = null;
        scopeObject = this.component.getUseSharedLocation() ? this.owningWindowManager : this.getParent();
        return this.component.getClass().getName() + System.identityHashCode(scopeObject);
    }

    private void init(DialogComponentProvider provider) {
        this.component = provider;
        provider.setDialog(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)provider.getComponent(), "Center");
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setResizable(provider.isResizeable());
        this.windowAdapter = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                Component newFocusComponent;
                if (!DockingDialog.this.hasBeenFocused && (newFocusComponent = DockingDialog.this.component.getFocusComponent()) != null) {
                    focusComponent = newFocusComponent;
                    SwingUtilities.invokeLater(DockingDialog.this.requestFocusRunnable);
                }
            }

            @Override
            public void windowOpened(WindowEvent e) {
                DockingDialog.this.component.dialogShown();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                DockingDialog.this.component.escapeCallback();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                DockingDialog.this.cleanup();
            }
        };
        this.addWindowListener(this.windowAdapter);
        this.modalFixWindowAdapter = new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                WindowUtilities.bringModalestDialogToFront((Window)DockingDialog.this);
            }
        };
        this.addWindowListener(this.modalFixWindowAdapter);
        if (provider.getDefaultButton() != null) {
            this.getRootPane().setDefaultButton(provider.getDefaultButton());
        }
        GGlassPane ghidraGlassPane = new GGlassPane();
        this.setGlassPane((Component)ghidraGlassPane);
        ghidraGlassPane.setVisible(true);
    }

    public DockingWindowManager getOwningWindowManager() {
        return this.owningWindowManager;
    }

    public DialogComponentProvider getDialogComponent() {
        return this.component;
    }

    void close() {
        this.cleanup();
    }

    private void cleanup() {
        if (this.component.getRemberSize() || this.component.getRememberLocation()) {
            String key = this.getKey();
            Rectangle rect = this.getBounds();
            BoundsInfo boundsInfo = dialogBoundsMap.get(key);
            boundsInfo.setEndBounds(new Rectangle(rect));
        }
        this.component.setDialog(null);
        this.removeWindowListener(this.windowAdapter);
        this.setVisible(false);
        this.component.dialogClosed();
        this.component = null;
        this.getContentPane().removeAll();
        this.dispose();
        this.disposeHiddenFrame();
    }

    private void disposeHiddenFrame() {
        Container myParent = this.getParent();
        if (myParent instanceof HiddenDockingFrame) {
            Window[] ownedWindows;
            JFrame f = (JFrame)myParent;
            for (Window window : ownedWindows = f.getOwnedWindows()) {
                if (window == this) continue;
                return;
            }
            ((HiddenDockingFrame)myParent).dispose();
        }
    }

    DialogComponentProvider getComponent() {
        return this.component;
    }

    public void setCenteredOnComponent(Component c) {
        if (c == null) {
            this.setCenteredOnScreen();
            return;
        }
        if (c instanceof HiddenDockingFrame) {
            this.setCenteredOnScreen();
            return;
        }
        if (!c.isVisible()) {
            this.setCenteredOnScreen();
            return;
        }
        Rectangle r = this.getBounds();
        Point p = WindowUtilities.centerOnComponent((Component)c, (Component)this);
        r.setLocation(p);
        this.setBounds(r);
    }

    @Override
    public String getHelpInfo() {
        return "   DIALOG TITLE: " + this.getTitle() + "\n";
    }

    @Override
    public Object getHelpObject() {
        return this;
    }

    private void setCenteredOnScreen() {
        Dimension size = this.getSize();
        Point center = WindowUtilities.centerOnScreen((Dimension)size);
        this.setLocation(center);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            WindowUtilities.ensureOnScreen((Component)this);
        }
        super.setVisible(b);
    }

    @Override
    public String toString() {
        return this.getTitle();
    }

    static {
        dialogBoundsMap = LazyMap.lazyMap(new HashMap(), () -> new BoundsInfo());
    }

    private static class BoundsInfo {
        private Rectangle startBounds;
        private Rectangle endBounds;

        private BoundsInfo() {
        }

        boolean hasBeenMoved() {
            return this.endBounds != null && !Objects.equals(this.startBounds, this.endBounds);
        }

        Rectangle getEndBounds() {
            return this.endBounds;
        }

        void setStartBounds(Rectangle bounds) {
            this.startBounds = bounds;
        }

        void setEndBounds(Rectangle bounds) {
            if (Objects.equals(this.startBounds, bounds)) {
                return;
            }
            this.endBounds = bounds;
        }
    }
}

