/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.matchtable;

import docking.DockingWindowManager;
import docking.help.HelpService;
import docking.widgets.button.GRadioButton;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GComboBox;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.util.VTMatchApplyChoices;
import ghidra.feature.vt.gui.util.VTOptionDefines;
import ghidra.framework.options.EditorStateFactory;
import ghidra.framework.options.EnumEditor;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsEditor;
import ghidra.framework.options.ToolOptions;
import ghidra.util.HelpLocation;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VariableHeightPairLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class ApplyMarkupPropertyEditor
implements OptionsEditor {
    private static final String DATA_MATCH_DATA_TYPE_TOOLTIP = "<HTML>The apply action for the <b>data type on a data match</b> when performing bulk apply operations</HTML>";
    private static final String LABELS_TOOLTIP = "<HTML>The apply action for <b>labels</b> when performing bulk apply operations</HTML>";
    private static final String FUNCTION_NAME_TOOLTIP = "<HTML>The apply action for <b>function name</b> when performing bulk apply operations</HTML>";
    private static final String FUNCTION_SIGNATURE_TOOLTIP = "<HTML>The apply action for the <b>function signature</b> when performing bulk apply operations</HTML>";
    private static final String PLATE_COMMENT_TOOLTIP = "<HTML>The apply action for <b>plate comments</b> when performing bulk apply operations</HTML>";
    private static final String PRE_COMMENT_TOOLTIP = "<HTML>The apply action for <b>pre comments</b> when performing bulk apply operations</HTML>";
    private static final String END_OF_LINE_COMMENT_TOOLTIP = "<HTML>The apply action for <b>end of line comments</b> when performing bulk apply operations</HTML>";
    private static final String REPEATABLE_COMMENT_TOOLTIP = "<HTML>The apply action for <b>repeatable comments</b> when performing bulk apply operations</HTML>";
    private static final String POST_COMMENT_TOOLTIP = "<HTML>The apply action for <b>post comments</b> when performing bulk apply operations</HTML>";
    private static final String FUNCTION_RETURN_TYPE_TOOLTIP = "<HTML>The apply action for <b>function return type</b> when the function signature is applied</HTML>";
    private static final String INLINE_TOOLTIP = "<HTML>The apply action to use for the <b>function inline flag</b> when applying the function signature</HTML>";
    private static final String NO_RETURN_TOOLTIP = "<HTML>The apply action to use for the <b>function no return flag</b> when applying the function signature</HTML>";
    private static final String CALLING_CONVENTION_TOOLTIP = "<HTML>The apply action to use for the <b>function calling convention</b> when applying the function signature</HTML>";
    private static final String CALL_FIXUP_TOOLTIP = "<HTML>The apply action for <b>whether or not to apply call fixup</b> when applying the function signature</HTML>";
    private static final String VAR_ARGS_TOOLTIP = "<HTML>The apply action to use for the <b>var args flag</b> when applying the function signature</HTML>";
    private static final String PARAMETER_DATA_TYPES_TOOLTIP = "<HTML>The apply action for <b>function parameter data types</b> when applying the function signature</HTML>";
    private static final String PARAMETER_NAMES_TOOLTIP = "<HTML>The apply action for <b>function parameter names</b> when applying the function signature</HTML>";
    private static final String PARAMETER_NAME_PRIORITY_TOOTIP = "<HTML>Choose whether a parameter name with a User source type or Import source type is highest priority when determining whether to replace the name or not when using the priority.</HTML>";
    private static final String HIGHEST_NAME_PRIORITY_TOOLTIP = "<HTML>The apply action for <b>which source type is the highest priority</b> when applying parameter names using a priority replace</HTML>";
    private static final String USER_PRIORITY_TOOLTIP = "<HTML>Parameter Name Source Type Priority <br>from highest to lowest:<br><blockquote>User Defined<br>Imported<br>Analysis<br>default (i.e. param_...)</blockquote></HTML>";
    private static final String IMPORT_PRIORITY_TOOLTIP = "<HTML>Parameter Name Source Type Priority <br>from highest to lowest:<br><blockquote>Imported<br>User Defined<br>Analysis<br>default (i.e. param_...)</blockquote></HTML>";
    private static final String PARAMETER_NAMES_REPLACE_IF_SAME_PRIORITY_TOOLTIP = "<HTML>When function signature parameter names are being replaced based on source type priority, replace the destination name with the source name if their source types are the same.</HTML>";
    private static final String PARAMETER_COMMENTS_TOOLTIP = "<HTML>The apply action for <b>parameter comments</b> when applying the function signature</HTML>";
    private static final String IGNORE_EXCLUDED_TOOLTIP = "<HTML>Markup items whose \"apply option\" is set to <b>Do Not Apply</b> should be changed to a status of <b>Ignored</b> by applying a match.</HTML>";
    private static final String IGNORE_INCOMPLETE_TOOLTIP = "<HTML>Markup items that are <b>incomplete</b> (for example, no destination address is specified) should be changed to a status of <b>Ignored</b> by applying a match.</HTML>";
    private JComponent editorComponent;
    private JLabel dataMatchDataTypeLabel;
    private JLabel functionNameLabel;
    private JLabel functionSignatureLabel;
    private JLabel returnTypeLabel;
    private JLabel inlineLabel;
    private JLabel noReturnLabel;
    private JLabel callingConventionLabel;
    private JLabel callFixupLabel;
    private JLabel parameterDataTypesLabel;
    private JLabel parameterNamesLabel;
    private JLabel parameterCommentsLabel;
    private JLabel varArgsLabel;
    private JLabel labelsLabel;
    private JLabel plateCommentsLabel;
    private JLabel preCommentsLabel;
    private JLabel endOfLineCommentsLabel;
    private JLabel repeatableCommentsLabel;
    private JLabel postCommentsLabel;
    private JComboBox<Enum<?>> dataMatchDataTypeComboBox;
    private JComboBox<Enum<?>> functionNameComboBox;
    private JComboBox<Enum<?>> functionSignatureComboBox;
    private JComboBox<Enum<?>> returnTypeComboBox;
    private JComboBox<Enum<?>> callingConventionComboBox;
    private JComboBox<Enum<?>> inlineComboBox;
    private JComboBox<Enum<?>> noReturnComboBox;
    private JComboBox<Enum<?>> callFixupComboBox;
    private JComboBox<Enum<?>> parameterDataTypesComboBox;
    private JComboBox<Enum<?>> parameterNamesComboBox;
    private JComboBox<Enum<?>> parameterCommentsComboBox;
    private JRadioButton userHighestPriorityRB;
    private JRadioButton importHighestPriorityRB;
    private ButtonGroup priorityButtonGroup;
    private JCheckBox replaceIfSameSourceCheckBox;
    private JComboBox<Enum<?>> varArgsComboBox;
    private JComboBox<Enum<?>> labelsComboBox;
    private JComboBox<Enum<?>> plateCommentsComboBox;
    private JComboBox<Enum<?>> preCommentsComboBox;
    private JComboBox<Enum<?>> endOfLineCommentsComboBox;
    private JComboBox<Enum<?>> postCommentsComboBox;
    private JComboBox<Enum<?>> repeatableCommentsComboBox;
    private JCheckBox ignoreExcludedCheckBox;
    private JCheckBox ignoreIncompleteCheckBox;
    private ActionListener defaultActionListener;
    private ToolOptions originalOptions;
    private PropertyChangeListener listener;
    private boolean unappliedChanges = false;
    private VTController controller;

    public ApplyMarkupPropertyEditor(VTController controller) {
        this.controller = controller;
        this.originalOptions = controller.getOptions();
        this.editorComponent = this.buildEditor();
        this.setEditorValues(this.originalOptions);
        this.setupHelp();
    }

    public void dispose() {
    }

    private void setupHelp() {
        HelpService helpService = DockingWindowManager.getHelpService();
        HelpLocation applyMatchOptionsHelpLocation = new HelpLocation("VersionTrackingPlugin", "Match_Apply_Options");
        helpService.registerHelp((Object)this.editorComponent, applyMatchOptionsHelpLocation);
    }

    private JComponent buildEditor() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new VerticalLayout(5));
        JPanel pair1 = new JPanel((LayoutManager)new VariableHeightPairLayout(3, 5));
        pair1.add(this.createNonCommentMarkupSubPanel());
        pair1.add(this.createCommentsSubPanel());
        JPanel pair2 = new JPanel((LayoutManager)new VariableHeightPairLayout(3, 5));
        pair2.add(this.createFunctionSignatureSubPanel());
        pair2.add(this.createParametersSubPanel());
        panel.add(pair1);
        panel.add(this.createSeparator());
        panel.add(pair2);
        panel.add(this.createSeparator());
        panel.add(this.createIgnoreCheckBoxPanel());
        panel.setBorder(BorderFactory.createTitledBorder("Apply Markup Options"));
        JScrollPane scrollPane = new JScrollPane(panel);
        return scrollPane;
    }

    private Component createSeparator() {
        JSeparator separator = new JSeparator(0);
        JPanel borderPanel = new JPanel(new BorderLayout());
        borderPanel.setBorder(BorderFactory.createEmptyBorder(20, 50, 20, 50));
        borderPanel.add(separator);
        return borderPanel;
    }

    private Component createIgnoreCheckBoxPanel() {
        this.createIgnoreCheckBoxes();
        this.setupIgnoreMarkupItemsListeners();
        JPanel panel = new JPanel();
        panel.add(this.ignoreExcludedCheckBox);
        panel.add(this.ignoreIncompleteCheckBox);
        return panel;
    }

    private void createIgnoreCheckBoxes() {
        this.ignoreIncompleteCheckBox = new GCheckBox("Set Incomplete Markup Items To Ignored");
        this.ignoreIncompleteCheckBox.setToolTipText(IGNORE_INCOMPLETE_TOOLTIP);
        this.ignoreExcludedCheckBox = new GCheckBox("Set Excluded Markup Items To Ignored");
        this.ignoreExcludedCheckBox.setToolTipText(IGNORE_EXCLUDED_TOOLTIP);
    }

    private void setupIgnoreMarkupItemsListeners() {
        this.ignoreExcludedCheckBox.addActionListener(this.defaultActionListener);
        this.ignoreIncompleteCheckBox.addActionListener(this.defaultActionListener);
    }

    private JPanel createFunctionSignatureSubPanel() {
        this.createFunctionSignatureDetailLabels();
        this.createFunctionSignatureDetailChoices();
        this.setupFunctionSignatureDetailChoiceListeners();
        JPanel outerPanel = new JPanel();
        outerPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(null, "Function Signature Details", 1, 0));
        panel.setLayout((LayoutManager)new PairLayout(3, 5));
        panel.add(this.returnTypeLabel);
        panel.add(this.returnTypeComboBox);
        panel.add(this.inlineLabel);
        panel.add(this.inlineComboBox);
        panel.add(this.noReturnLabel);
        panel.add(this.noReturnComboBox);
        panel.add(this.callingConventionLabel);
        panel.add(this.callingConventionComboBox);
        panel.add(this.callFixupLabel);
        panel.add(this.callFixupComboBox);
        panel.add(this.varArgsLabel);
        panel.add(this.varArgsComboBox);
        outerPanel.add(panel);
        return outerPanel;
    }

    private void createFunctionSignatureDetailLabels() {
        this.returnTypeLabel = new GDLabel("Return Type", 4);
        this.returnTypeLabel.setToolTipText(FUNCTION_RETURN_TYPE_TOOLTIP);
        this.inlineLabel = new GDLabel("Inline", 4);
        this.inlineLabel.setToolTipText(INLINE_TOOLTIP);
        this.noReturnLabel = new GDLabel("No Return", 4);
        this.noReturnLabel.setToolTipText(NO_RETURN_TOOLTIP);
        this.callingConventionLabel = new GDLabel("Calling Convention", 4);
        this.callingConventionLabel.setToolTipText(CALLING_CONVENTION_TOOLTIP);
        this.callFixupLabel = new GDLabel("Call Fixup", 4);
        this.callFixupLabel.setToolTipText(CALL_FIXUP_TOOLTIP);
        this.varArgsLabel = new GDLabel("Var Args", 4);
        this.varArgsLabel.setToolTipText(VAR_ARGS_TOOLTIP);
    }

    private void createFunctionSignatureDetailChoices() {
        this.returnTypeComboBox = this.createComboBox("Apply Markup Options.Function Return Type", VTOptionDefines.DEFAULT_OPTION_FOR_FUNCTION_RETURN_TYPE);
        this.returnTypeComboBox.setToolTipText(FUNCTION_RETURN_TYPE_TOOLTIP);
        this.inlineComboBox = this.createComboBox("Apply Markup Options.Function Inline", VTOptionDefines.DEFAULT_OPTION_FOR_INLINE);
        this.inlineComboBox.setToolTipText(INLINE_TOOLTIP);
        this.noReturnComboBox = this.createComboBox("Apply Markup Options.Function No Return", VTOptionDefines.DEFAULT_OPTION_FOR_NO_RETURN);
        this.noReturnComboBox.setToolTipText(NO_RETURN_TOOLTIP);
        this.callingConventionComboBox = this.createComboBox("Apply Markup Options.Function Calling Convention", VTMatchApplyChoices.CallingConventionChoices.SAME_LANGUAGE);
        this.callingConventionComboBox.setToolTipText(CALLING_CONVENTION_TOOLTIP);
        this.callFixupComboBox = this.createComboBox("Apply Markup Options.Function Call Fixup", VTOptionDefines.DEFAULT_OPTION_FOR_CALL_FIXUP);
        this.callFixupComboBox.setToolTipText(CALL_FIXUP_TOOLTIP);
        this.varArgsComboBox = this.createComboBox("Apply Markup Options.Function Var Args", VTOptionDefines.DEFAULT_OPTION_FOR_VAR_ARGS);
        this.varArgsComboBox.setToolTipText(VAR_ARGS_TOOLTIP);
    }

    private void setupFunctionSignatureDetailChoiceListeners() {
        this.returnTypeComboBox.addActionListener(this.defaultActionListener);
        this.inlineComboBox.addActionListener(this.defaultActionListener);
        this.noReturnComboBox.addActionListener(this.defaultActionListener);
        this.callingConventionComboBox.addActionListener(this.defaultActionListener);
        this.callFixupComboBox.addActionListener(this.defaultActionListener);
        this.varArgsComboBox.addActionListener(this.defaultActionListener);
    }

    private JPanel createParametersSubPanel() {
        this.createParameterLabels();
        this.createParameterChoices();
        this.setupParameterChoiceListeners();
        JPanel outerPanel = new JPanel();
        outerPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(null, "Function Parameter Details", 1, 0));
        panel.setLayout((LayoutManager)new VariableHeightPairLayout(3, 5));
        panel.add(this.parameterDataTypesLabel);
        panel.add(this.parameterDataTypesComboBox);
        panel.add(this.parameterNamesLabel);
        panel.add(this.parameterNamesComboBox);
        panel.add((Component)new GLabel(" "));
        panel.add(this.createPrioritySubPanel());
        panel.add(this.parameterCommentsLabel);
        panel.add(this.parameterCommentsComboBox);
        outerPanel.add(panel);
        return outerPanel;
    }

    private void createParameterLabels() {
        this.parameterDataTypesLabel = new GDLabel("Parameter Data Types", 4);
        this.parameterDataTypesLabel.setToolTipText(PARAMETER_DATA_TYPES_TOOLTIP);
        this.parameterNamesLabel = new GDLabel("Parameter Names", 4);
        this.parameterNamesLabel.setToolTipText(PARAMETER_NAMES_TOOLTIP);
        this.parameterCommentsLabel = new GDLabel("Parameter Comments", 4);
        this.parameterCommentsLabel.setToolTipText(PARAMETER_COMMENTS_TOOLTIP);
    }

    private void createParameterChoices() {
        this.parameterDataTypesComboBox = this.createComboBox("Apply Markup Options.Function Parameter Data Types", VTOptionDefines.DEFAULT_OPTION_FOR_PARAMETER_DATA_TYPES);
        this.parameterDataTypesComboBox.setToolTipText(PARAMETER_DATA_TYPES_TOOLTIP);
        this.parameterNamesComboBox = this.createComboBox("Apply Markup Options.Function Parameter Names", VTOptionDefines.DEFAULT_OPTION_FOR_PARAMETER_NAMES);
        this.parameterNamesComboBox.setToolTipText(PARAMETER_NAMES_TOOLTIP);
        this.parameterCommentsComboBox = this.createComboBox("Apply Markup Options.Function Parameter Comments", VTOptionDefines.DEFAULT_OPTION_FOR_PARAMETER_COMMENTS);
        this.parameterCommentsComboBox.setToolTipText(PARAMETER_COMMENTS_TOOLTIP);
        this.userHighestPriorityRB = this.createRadioButton("User ");
        this.userHighestPriorityRB.setToolTipText(USER_PRIORITY_TOOLTIP);
        this.importHighestPriorityRB = this.createRadioButton("Import");
        this.importHighestPriorityRB.setToolTipText(IMPORT_PRIORITY_TOOLTIP);
        this.priorityButtonGroup = new ButtonGroup();
        this.priorityButtonGroup.add(this.userHighestPriorityRB);
        this.priorityButtonGroup.add(this.importHighestPriorityRB);
        this.replaceIfSameSourceCheckBox = this.createCheckBox("Also Replace If Same Source Type");
        this.replaceIfSameSourceCheckBox.setToolTipText(PARAMETER_NAMES_REPLACE_IF_SAME_PRIORITY_TOOLTIP);
    }

    private void setupParameterChoiceListeners() {
        this.parameterDataTypesComboBox.addActionListener(this.defaultActionListener);
        this.parameterNamesComboBox.addActionListener(this.defaultActionListener);
        this.userHighestPriorityRB.addActionListener(this.defaultActionListener);
        this.importHighestPriorityRB.addActionListener(this.defaultActionListener);
        this.replaceIfSameSourceCheckBox.addActionListener(this.defaultActionListener);
        this.parameterCommentsComboBox.addActionListener(this.defaultActionListener);
    }

    private JPanel createPrioritySubPanel() {
        JPanel outerPanel = new JPanel();
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(null, "Parameter Name Priority", 1, 0));
        panel.setLayout((LayoutManager)new VerticalLayout(5));
        panel.setToolTipText(PARAMETER_NAME_PRIORITY_TOOTIP);
        Box buttonBox = new Box(0);
        GDLabel highestPriorityLabel = new GDLabel(" Highest: ");
        highestPriorityLabel.setToolTipText(HIGHEST_NAME_PRIORITY_TOOLTIP);
        buttonBox.add((Component)highestPriorityLabel);
        buttonBox.add(this.userHighestPriorityRB);
        buttonBox.add(this.importHighestPriorityRB);
        panel.add(buttonBox);
        panel.add(this.replaceIfSameSourceCheckBox);
        outerPanel.add(panel);
        return outerPanel;
    }

    private JPanel createNonCommentMarkupSubPanel() {
        this.createNonCommentMarkupLabels();
        this.createNonCommentMarkupChoices();
        this.setupNonCommentMarkupChoiceListeners();
        JPanel outerPanel = new JPanel();
        outerPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new PairLayout(3, 5));
        panel.add(this.dataMatchDataTypeLabel);
        panel.add(this.dataMatchDataTypeComboBox);
        panel.add(this.labelsLabel);
        panel.add(this.labelsComboBox);
        panel.add(this.functionNameLabel);
        panel.add(this.functionNameComboBox);
        panel.add(this.functionSignatureLabel);
        panel.add(this.functionSignatureComboBox);
        outerPanel.add(panel);
        return outerPanel;
    }

    private void createNonCommentMarkupLabels() {
        this.dataMatchDataTypeLabel = new GDLabel("Data Match Data Type", 4);
        this.dataMatchDataTypeLabel.setToolTipText(DATA_MATCH_DATA_TYPE_TOOLTIP);
        this.labelsLabel = new GDLabel("Labels", 4);
        this.labelsLabel.setToolTipText(LABELS_TOOLTIP);
        this.functionNameLabel = new GDLabel("Function Name", 4);
        this.functionNameLabel.setToolTipText(FUNCTION_NAME_TOOLTIP);
        this.functionSignatureLabel = new GDLabel("Function Signature", 4);
        this.functionSignatureLabel.setToolTipText(FUNCTION_SIGNATURE_TOOLTIP);
    }

    private void createNonCommentMarkupChoices() {
        this.dataMatchDataTypeComboBox = this.createComboBox("Apply Markup Options.Data Match Data Type", VTOptionDefines.DEFAULT_OPTION_FOR_DATA_MATCH_DATA_TYPE);
        this.dataMatchDataTypeComboBox.setToolTipText(DATA_MATCH_DATA_TYPE_TOOLTIP);
        this.labelsComboBox = this.createComboBox("Apply Markup Options.Labels", VTOptionDefines.DEFAULT_OPTION_FOR_LABELS);
        this.labelsComboBox.setToolTipText(LABELS_TOOLTIP);
        this.functionNameComboBox = this.createComboBox("Apply Markup Options.Function Name", VTOptionDefines.DEFAULT_OPTION_FOR_FUNCTION_NAME);
        this.functionNameComboBox.setToolTipText(FUNCTION_NAME_TOOLTIP);
        this.functionSignatureComboBox = this.createComboBox("Apply Markup Options.Function Signature", VTOptionDefines.DEFAULT_OPTION_FOR_FUNCTION_SIGNATURE);
        this.functionSignatureComboBox.setToolTipText(FUNCTION_SIGNATURE_TOOLTIP);
    }

    private void setupNonCommentMarkupChoiceListeners() {
        this.dataMatchDataTypeComboBox.addActionListener(this.defaultActionListener);
        this.labelsComboBox.addActionListener(this.defaultActionListener);
        this.functionNameComboBox.addActionListener(this.defaultActionListener);
        this.functionSignatureComboBox.addActionListener(this.defaultActionListener);
    }

    private JPanel createCommentsSubPanel() {
        this.createCommentLabels();
        this.createCommentChoices();
        this.setupCommentChoiceListeners();
        JPanel outerPanel = new JPanel();
        outerPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new PairLayout(3, 5));
        panel.add(this.plateCommentsLabel);
        panel.add(this.plateCommentsComboBox);
        panel.add(this.preCommentsLabel);
        panel.add(this.preCommentsComboBox);
        panel.add(this.endOfLineCommentsLabel);
        panel.add(this.endOfLineCommentsComboBox);
        panel.add(this.repeatableCommentsLabel);
        panel.add(this.repeatableCommentsComboBox);
        panel.add(this.postCommentsLabel);
        panel.add(this.postCommentsComboBox);
        outerPanel.add(panel);
        return outerPanel;
    }

    private void createCommentLabels() {
        this.plateCommentsLabel = new GDLabel("Plate Comments", 4);
        this.plateCommentsLabel.setToolTipText(PLATE_COMMENT_TOOLTIP);
        this.preCommentsLabel = new GDLabel("Pre-Comments", 4);
        this.preCommentsLabel.setToolTipText(PRE_COMMENT_TOOLTIP);
        this.endOfLineCommentsLabel = new GDLabel("End of Line Comments", 4);
        this.endOfLineCommentsLabel.setToolTipText(END_OF_LINE_COMMENT_TOOLTIP);
        this.repeatableCommentsLabel = new GDLabel("Repeatable Comments", 4);
        this.repeatableCommentsLabel.setToolTipText(REPEATABLE_COMMENT_TOOLTIP);
        this.postCommentsLabel = new GDLabel("Post Comments", 4);
        this.postCommentsLabel.setToolTipText(POST_COMMENT_TOOLTIP);
    }

    private void createCommentChoices() {
        this.plateCommentsComboBox = this.createComboBox("Apply Markup Options.Plate Comment", VTOptionDefines.DEFAULT_OPTION_FOR_PLATE_COMMENTS);
        this.plateCommentsComboBox.setToolTipText(PLATE_COMMENT_TOOLTIP);
        this.preCommentsComboBox = this.createComboBox("Apply Markup Options.Pre Comment", VTOptionDefines.DEFAULT_OPTION_FOR_PRE_COMMENTS);
        this.preCommentsComboBox.setToolTipText(PRE_COMMENT_TOOLTIP);
        this.endOfLineCommentsComboBox = this.createComboBox("Apply Markup Options.End of Line Comment", VTOptionDefines.DEFAULT_OPTION_FOR_EOL_COMMENTS);
        this.endOfLineCommentsComboBox.setToolTipText(END_OF_LINE_COMMENT_TOOLTIP);
        this.repeatableCommentsComboBox = this.createComboBox("Apply Markup Options.Repeatable Comment", VTOptionDefines.DEFAULT_OPTION_FOR_REPEATABLE_COMMENTS);
        this.repeatableCommentsComboBox.setToolTipText(REPEATABLE_COMMENT_TOOLTIP);
        this.postCommentsComboBox = this.createComboBox("Apply Markup Options.Post Comment", VTOptionDefines.DEFAULT_OPTION_FOR_POST_COMMENTS);
        this.postCommentsComboBox.setToolTipText(POST_COMMENT_TOOLTIP);
    }

    private void setupCommentChoiceListeners() {
        this.plateCommentsComboBox.addActionListener(this.defaultActionListener);
        this.preCommentsComboBox.addActionListener(this.defaultActionListener);
        this.endOfLineCommentsComboBox.addActionListener(this.defaultActionListener);
        this.repeatableCommentsComboBox.addActionListener(this.defaultActionListener);
        this.postCommentsComboBox.addActionListener(this.defaultActionListener);
    }

    private void updateOptions(ToolOptions options) {
        this.updateNonCommentMarkupOptions(options);
        this.updateCommentOptions(options);
        this.updateFunctionSignatureOptions(options);
        this.updateParameterOptions(options);
        this.updateIgnoreMarkupOptions((Options)options);
    }

    private void updateNonCommentMarkupOptions(ToolOptions options) {
        VTMatchApplyChoices.ReplaceDataChoices dataMatchDataTypeChoice = (VTMatchApplyChoices.ReplaceDataChoices)((Object)this.dataMatchDataTypeComboBox.getSelectedItem());
        options.setEnum("Apply Markup Options.Data Match Data Type", (Enum)dataMatchDataTypeChoice);
        VTMatchApplyChoices.LabelChoices labelsChoice = (VTMatchApplyChoices.LabelChoices)((Object)this.labelsComboBox.getSelectedItem());
        options.setEnum("Apply Markup Options.Labels", (Enum)labelsChoice);
        VTMatchApplyChoices.FunctionNameChoices functionNameChoice = (VTMatchApplyChoices.FunctionNameChoices)((Object)this.functionNameComboBox.getSelectedItem());
        options.setEnum("Apply Markup Options.Function Name", (Enum)functionNameChoice);
        VTMatchApplyChoices.FunctionSignatureChoices functionSignatureChoice = (VTMatchApplyChoices.FunctionSignatureChoices)((Object)this.functionSignatureComboBox.getSelectedItem());
        options.setEnum("Apply Markup Options.Function Signature", (Enum)functionSignatureChoice);
    }

    private void updateCommentOptions(ToolOptions options) {
        VTMatchApplyChoices.CommentChoices plateCommentChoice = (VTMatchApplyChoices.CommentChoices)((Object)this.plateCommentsComboBox.getSelectedItem());
        options.setEnum("Apply Markup Options.Plate Comment", (Enum)plateCommentChoice);
        VTMatchApplyChoices.CommentChoices preCommentChoice = (VTMatchApplyChoices.CommentChoices)((Object)this.preCommentsComboBox.getSelectedItem());
        options.setEnum("Apply Markup Options.Pre Comment", (Enum)preCommentChoice);
        VTMatchApplyChoices.CommentChoices endOfLineCommentChoice = (VTMatchApplyChoices.CommentChoices)((Object)this.endOfLineCommentsComboBox.getSelectedItem());
        options.setEnum("Apply Markup Options.End of Line Comment", (Enum)endOfLineCommentChoice);
        VTMatchApplyChoices.CommentChoices repeatableCommentChoice = (VTMatchApplyChoices.CommentChoices)((Object)this.repeatableCommentsComboBox.getSelectedItem());
        options.setEnum("Apply Markup Options.Repeatable Comment", (Enum)repeatableCommentChoice);
        VTMatchApplyChoices.CommentChoices postCommentChoice = (VTMatchApplyChoices.CommentChoices)((Object)this.postCommentsComboBox.getSelectedItem());
        options.setEnum("Apply Markup Options.Post Comment", (Enum)postCommentChoice);
    }

    private void updateFunctionSignatureOptions(ToolOptions options) {
        VTMatchApplyChoices.ParameterDataTypeChoices returnTypeChoice = (VTMatchApplyChoices.ParameterDataTypeChoices)((Object)this.returnTypeComboBox.getSelectedItem());
        options.setEnum("Apply Markup Options.Function Return Type", (Enum)returnTypeChoice);
        VTMatchApplyChoices.ReplaceChoices inlineChoice = (VTMatchApplyChoices.ReplaceChoices)((Object)this.inlineComboBox.getSelectedItem());
        options.setEnum("Apply Markup Options.Function Inline", (Enum)inlineChoice);
        VTMatchApplyChoices.ReplaceChoices noReturnChoice = (VTMatchApplyChoices.ReplaceChoices)((Object)this.noReturnComboBox.getSelectedItem());
        options.setEnum("Apply Markup Options.Function No Return", (Enum)noReturnChoice);
        VTMatchApplyChoices.CallingConventionChoices callingConventionChoice = (VTMatchApplyChoices.CallingConventionChoices)((Object)this.callingConventionComboBox.getSelectedItem());
        options.setEnum("Apply Markup Options.Function Calling Convention", (Enum)callingConventionChoice);
        VTMatchApplyChoices.ReplaceChoices callFixupChoice = (VTMatchApplyChoices.ReplaceChoices)((Object)this.callFixupComboBox.getSelectedItem());
        options.setEnum("Apply Markup Options.Function Call Fixup", (Enum)callFixupChoice);
        VTMatchApplyChoices.ReplaceChoices varArgsChoice = (VTMatchApplyChoices.ReplaceChoices)((Object)this.varArgsComboBox.getSelectedItem());
        options.setEnum("Apply Markup Options.Function Var Args", (Enum)varArgsChoice);
    }

    private void updateParameterOptions(ToolOptions options) {
        VTMatchApplyChoices.ParameterDataTypeChoices parameterDataTypeChoice = (VTMatchApplyChoices.ParameterDataTypeChoices)((Object)this.parameterDataTypesComboBox.getSelectedItem());
        options.setEnum("Apply Markup Options.Function Parameter Data Types", (Enum)parameterDataTypeChoice);
        VTMatchApplyChoices.SourcePriorityChoices parameterNameChoice = (VTMatchApplyChoices.SourcePriorityChoices)((Object)this.parameterNamesComboBox.getSelectedItem());
        options.setEnum("Apply Markup Options.Function Parameter Names", (Enum)parameterNameChoice);
        VTMatchApplyChoices.HighestSourcePriorityChoices highestPriorityChoice = this.userHighestPriorityRB.isSelected() ? VTMatchApplyChoices.HighestSourcePriorityChoices.USER_PRIORITY_HIGHEST : VTMatchApplyChoices.HighestSourcePriorityChoices.IMPORT_PRIORITY_HIGHEST;
        options.setEnum("Apply Markup Options.Function Parameter Names Highest Name Priority", (Enum)highestPriorityChoice);
        boolean replaceIfSameSource = this.replaceIfSameSourceCheckBox.isSelected();
        options.setBoolean("Apply Markup Options.Function Parameter Names Replace If Same Priority", replaceIfSameSource);
        VTMatchApplyChoices.CommentChoices parameterCommentChoice = (VTMatchApplyChoices.CommentChoices)((Object)this.parameterCommentsComboBox.getSelectedItem());
        options.setEnum("Apply Markup Options.Function Parameter Comments", (Enum)parameterCommentChoice);
    }

    private void updateIgnoreMarkupOptions(Options options) {
        boolean ignoreExcludedMarkup = this.ignoreExcludedCheckBox.isSelected();
        options.setBoolean("Apply Markup Options.Set Excluded Markup Items To Ignored", ignoreExcludedMarkup);
        boolean ignoreIncompleteMarkup = this.ignoreIncompleteCheckBox.isSelected();
        options.setBoolean("Apply Markup Options.Set Incomplete Markup Items To Ignored", ignoreIncompleteMarkup);
    }

    private void setEditorValues(ToolOptions options) {
        this.setEditorNonCommentMarkupValues(options);
        this.setEditorCommentValues(options);
        this.setEditorFunctionSignatureValues(options);
        this.setEditorParameterValues(options);
        this.setEditorIgnoreMarkupValues((Options)options);
    }

    private void setEditorNonCommentMarkupValues(ToolOptions options) {
        VTMatchApplyChoices.FunctionSignatureChoices functionSignatureChoice;
        VTMatchApplyChoices.FunctionNameChoices functionNameChoice;
        VTMatchApplyChoices.LabelChoices labelsChoice;
        VTMatchApplyChoices.ReplaceDataChoices dataMatchDataTypeChoice = (VTMatchApplyChoices.ReplaceDataChoices)options.getEnum("Apply Markup Options.Data Match Data Type", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_DATA_MATCH_DATA_TYPE);
        if (dataMatchDataTypeChoice != this.dataMatchDataTypeComboBox.getSelectedItem()) {
            this.dataMatchDataTypeComboBox.setSelectedItem((Object)dataMatchDataTypeChoice);
        }
        if ((labelsChoice = (VTMatchApplyChoices.LabelChoices)options.getEnum("Apply Markup Options.Labels", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_LABELS)) != this.labelsComboBox.getSelectedItem()) {
            this.labelsComboBox.setSelectedItem((Object)labelsChoice);
        }
        if ((functionNameChoice = (VTMatchApplyChoices.FunctionNameChoices)options.getEnum("Apply Markup Options.Function Name", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_FUNCTION_NAME)) != this.functionNameComboBox.getSelectedItem()) {
            this.functionNameComboBox.setSelectedItem((Object)functionNameChoice);
        }
        if ((functionSignatureChoice = (VTMatchApplyChoices.FunctionSignatureChoices)options.getEnum("Apply Markup Options.Function Signature", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_FUNCTION_SIGNATURE)) != this.functionSignatureComboBox.getSelectedItem()) {
            this.functionSignatureComboBox.setSelectedItem((Object)functionSignatureChoice);
        }
    }

    private void setEditorCommentValues(ToolOptions options) {
        VTMatchApplyChoices.CommentChoices postCommentChoice;
        VTMatchApplyChoices.CommentChoices repeatableCommentChoice;
        VTMatchApplyChoices.CommentChoices endOfLineCommentChoice;
        VTMatchApplyChoices.CommentChoices preCommentChoice;
        VTMatchApplyChoices.CommentChoices plateCommentChoice = (VTMatchApplyChoices.CommentChoices)options.getEnum("Apply Markup Options.Plate Comment", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_PLATE_COMMENTS);
        if (plateCommentChoice != this.plateCommentsComboBox.getSelectedItem()) {
            this.plateCommentsComboBox.setSelectedItem((Object)plateCommentChoice);
        }
        if ((preCommentChoice = (VTMatchApplyChoices.CommentChoices)options.getEnum("Apply Markup Options.Pre Comment", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_PRE_COMMENTS)) != this.preCommentsComboBox.getSelectedItem()) {
            this.preCommentsComboBox.setSelectedItem((Object)preCommentChoice);
        }
        if ((endOfLineCommentChoice = (VTMatchApplyChoices.CommentChoices)options.getEnum("Apply Markup Options.End of Line Comment", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_EOL_COMMENTS)) != this.endOfLineCommentsComboBox.getSelectedItem()) {
            this.endOfLineCommentsComboBox.setSelectedItem((Object)endOfLineCommentChoice);
        }
        if ((repeatableCommentChoice = (VTMatchApplyChoices.CommentChoices)options.getEnum("Apply Markup Options.Repeatable Comment", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_REPEATABLE_COMMENTS)) != this.repeatableCommentsComboBox.getSelectedItem()) {
            this.repeatableCommentsComboBox.setSelectedItem((Object)repeatableCommentChoice);
        }
        if ((postCommentChoice = (VTMatchApplyChoices.CommentChoices)options.getEnum("Apply Markup Options.Post Comment", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_POST_COMMENTS)) != this.postCommentsComboBox.getSelectedItem()) {
            this.postCommentsComboBox.setSelectedItem((Object)postCommentChoice);
        }
    }

    private void setEditorFunctionSignatureValues(ToolOptions options) {
        VTMatchApplyChoices.ReplaceChoices varArgsChoice;
        VTMatchApplyChoices.ReplaceChoices callFixupChoice;
        VTMatchApplyChoices.CallingConventionChoices callingConventionChoice;
        VTMatchApplyChoices.ReplaceChoices noReturnChoice;
        VTMatchApplyChoices.ReplaceChoices inlineChoice;
        VTMatchApplyChoices.ParameterDataTypeChoices returnTypeChoice = (VTMatchApplyChoices.ParameterDataTypeChoices)options.getEnum("Apply Markup Options.Function Return Type", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_FUNCTION_RETURN_TYPE);
        if (returnTypeChoice != this.returnTypeComboBox.getSelectedItem()) {
            this.returnTypeComboBox.setSelectedItem((Object)returnTypeChoice);
        }
        if ((inlineChoice = (VTMatchApplyChoices.ReplaceChoices)options.getEnum("Apply Markup Options.Function Inline", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_INLINE)) != this.inlineComboBox.getSelectedItem()) {
            this.inlineComboBox.setSelectedItem((Object)inlineChoice);
        }
        if ((noReturnChoice = (VTMatchApplyChoices.ReplaceChoices)options.getEnum("Apply Markup Options.Function No Return", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_NO_RETURN)) != this.noReturnComboBox.getSelectedItem()) {
            this.noReturnComboBox.setSelectedItem((Object)noReturnChoice);
        }
        if ((callingConventionChoice = (VTMatchApplyChoices.CallingConventionChoices)options.getEnum("Apply Markup Options.Function Calling Convention", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_CALLING_CONVENTION)) != this.callingConventionComboBox.getSelectedItem()) {
            this.callingConventionComboBox.setSelectedItem((Object)callingConventionChoice);
        }
        if ((callFixupChoice = (VTMatchApplyChoices.ReplaceChoices)options.getEnum("Apply Markup Options.Function Call Fixup", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_CALL_FIXUP)) != this.callFixupComboBox.getSelectedItem()) {
            this.callFixupComboBox.setSelectedItem((Object)callFixupChoice);
        }
        if ((varArgsChoice = (VTMatchApplyChoices.ReplaceChoices)options.getEnum("Apply Markup Options.Function Var Args", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_VAR_ARGS)) != this.varArgsComboBox.getSelectedItem()) {
            this.varArgsComboBox.setSelectedItem((Object)varArgsChoice);
        }
    }

    private void setEditorParameterValues(ToolOptions options) {
        VTMatchApplyChoices.CommentChoices parameterCommentChoice;
        VTMatchApplyChoices.HighestSourcePriorityChoices highestPriorityChoice;
        VTMatchApplyChoices.SourcePriorityChoices parameterNameChoice;
        VTMatchApplyChoices.ParameterDataTypeChoices parameterDataTypeChoice = (VTMatchApplyChoices.ParameterDataTypeChoices)options.getEnum("Apply Markup Options.Function Parameter Data Types", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_PARAMETER_DATA_TYPES);
        if (parameterDataTypeChoice != this.parameterDataTypesComboBox.getSelectedItem()) {
            this.parameterDataTypesComboBox.setSelectedItem((Object)parameterDataTypeChoice);
        }
        if ((parameterNameChoice = (VTMatchApplyChoices.SourcePriorityChoices)options.getEnum("Apply Markup Options.Function Parameter Names", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_PARAMETER_NAMES)) != this.parameterNamesComboBox.getSelectedItem()) {
            this.parameterNamesComboBox.setSelectedItem((Object)parameterNameChoice);
        }
        if ((highestPriorityChoice = (VTMatchApplyChoices.HighestSourcePriorityChoices)options.getEnum("Apply Markup Options.Function Parameter Names Highest Name Priority", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_HIGHEST_NAME_PRIORITY)) == VTMatchApplyChoices.HighestSourcePriorityChoices.USER_PRIORITY_HIGHEST) {
            this.userHighestPriorityRB.setSelected(true);
        } else {
            this.importHighestPriorityRB.setSelected(true);
        }
        boolean replaceIfSameSource = options.getBoolean("Apply Markup Options.Function Parameter Names Replace If Same Priority", VTOptionDefines.DEFAULT_OPTION_FOR_PARAMETER_NAMES_REPLACE_IF_SAME_PRIORITY);
        if (replaceIfSameSource != this.replaceIfSameSourceCheckBox.isSelected()) {
            this.replaceIfSameSourceCheckBox.setSelected(replaceIfSameSource);
        }
        if ((parameterCommentChoice = (VTMatchApplyChoices.CommentChoices)options.getEnum("Apply Markup Options.Function Parameter Comments", (Enum)VTOptionDefines.DEFAULT_OPTION_FOR_PARAMETER_COMMENTS)) != this.parameterCommentsComboBox.getSelectedItem()) {
            this.parameterCommentsComboBox.setSelectedItem((Object)parameterCommentChoice);
        }
    }

    private void setEditorIgnoreMarkupValues(Options options) {
        boolean ignoreIncompleteMarkup;
        boolean ignoreExcludedMarkup = options.getBoolean("Apply Markup Options.Set Excluded Markup Items To Ignored", VTOptionDefines.DEFAULT_OPTION_FOR_IGNORE_EXCLUDED_MARKUP_ITEMS);
        if (ignoreExcludedMarkup != this.ignoreExcludedCheckBox.isSelected()) {
            this.ignoreExcludedCheckBox.setSelected(ignoreExcludedMarkup);
        }
        if ((ignoreIncompleteMarkup = options.getBoolean("Apply Markup Options.Set Incomplete Markup Items To Ignored", VTOptionDefines.DEFAULT_OPTION_FOR_IGNORE_INCOMPLETE_MARKUP_ITEMS)) != this.ignoreIncompleteCheckBox.isSelected()) {
            this.ignoreIncompleteCheckBox.setSelected(ignoreIncompleteMarkup);
        }
    }

    private JComboBox<Enum<?>> createComboBox(String optionName, Enum<?> choiceEnum) {
        EnumEditor editor = new EnumEditor();
        editor.setValue(choiceEnum);
        Object[] enums = editor.getEnums();
        GComboBox applyComboBox = new GComboBox(enums);
        applyComboBox.addActionListener(e -> this.changesMade(true));
        return applyComboBox;
    }

    private JCheckBox createCheckBox(String optionName) {
        GCheckBox applyCheckBox = new GCheckBox(optionName);
        applyCheckBox.addChangeListener(e -> this.changesMade(true));
        return applyCheckBox;
    }

    private JRadioButton createRadioButton(String optionName) {
        GRadioButton applyRadioButton = new GRadioButton(optionName);
        applyRadioButton.addActionListener(e -> this.changesMade(true));
        return applyRadioButton;
    }

    private void changesMade(boolean changes) {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "apply.enabled", this.unappliedChanges, changes));
        }
        this.unappliedChanges = changes;
    }

    public void apply() throws InvalidInputException {
        this.updateOptions(this.originalOptions);
    }

    public void cancel() {
    }

    public void reload() {
        this.originalOptions = this.controller.getOptions();
        this.setEditorValues(this.originalOptions);
    }

    public void setOptionsPropertyChangeListener(PropertyChangeListener listener) {
        this.listener = listener;
    }

    public JComponent getEditorComponent(Options options, EditorStateFactory editorStateFactory) {
        return this.editorComponent;
    }
}

