/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.symbol;

import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.symbol.TraceSymbol;
import ghidra.trace.model.symbol.TraceSymbolManager;
import ghidra.trace.model.symbol.TraceSymbolView;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.LockHold;
import java.util.ArrayList;
import java.util.Collection;

public interface TraceSymbolWithLocationView<T extends TraceSymbol>
extends TraceSymbolView<T> {
    public T getChildWithNameAt(String var1, long var2, TraceThread var4, Address var5, TraceNamespaceSymbol var6);

    default public T getGlobalWithNameAt(String name, long snap, TraceThread thread, Address address) {
        return this.getChildWithNameAt(name, snap, thread, address, this.getManager().getGlobalNamespace());
    }

    public Collection<? extends T> getIntersecting(Range<Long> var1, TraceThread var2, AddressRange var3, boolean var4, boolean var5);

    default public Collection<? extends T> getAt(long snap, TraceThread thread, Address address, boolean includeDynamicSymbols) {
        try (LockHold hold = this.getManager().getTrace().lockRead();){
            ArrayList<T> result = new ArrayList<T>(this.getIntersecting((Range<Long>)Range.closed((Comparable)Long.valueOf(snap), (Comparable)Long.valueOf(snap)), thread, (AddressRange)new AddressRangeImpl(address, address), includeDynamicSymbols, true));
            result.sort(TraceSymbolManager.PRIMALITY_COMPARATOR);
            ArrayList<T> arrayList = result;
            return arrayList;
        }
    }

    default public boolean hasAt(long snap, TraceThread thread, Address address, boolean includeDynamicSymbols) {
        try (LockHold hold = this.getManager().getTrace().lockRead();){
            boolean bl = !this.getIntersecting((Range<Long>)Range.singleton((Comparable)Long.valueOf(snap)), thread, (AddressRange)new AddressRangeImpl(address, address), includeDynamicSymbols, true).isEmpty();
            return bl;
        }
    }
}

