/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.symbol;

import ghidra.trace.model.Trace;
import ghidra.trace.model.symbol.TraceClassSymbolView;
import ghidra.trace.model.symbol.TraceFunctionSymbol;
import ghidra.trace.model.symbol.TraceFunctionSymbolView;
import ghidra.trace.model.symbol.TraceGlobalVariableSymbolView;
import ghidra.trace.model.symbol.TraceLabelSymbolView;
import ghidra.trace.model.symbol.TraceLocalVariableSymbolView;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.symbol.TraceNamespaceSymbolView;
import ghidra.trace.model.symbol.TraceParameterSymbolView;
import ghidra.trace.model.symbol.TraceSymbol;
import ghidra.trace.model.symbol.TraceSymbolNoDuplicatesView;
import ghidra.trace.model.symbol.TraceSymbolView;
import ghidra.trace.model.symbol.TraceSymbolWithAddressNoDuplicatesView;
import ghidra.trace.model.symbol.TraceSymbolWithLocationView;
import ghidra.trace.model.symbol.TraceVariableSymbol;
import java.util.Collection;
import java.util.Comparator;

public interface TraceSymbolManager {
    public static final Comparator<TraceSymbol> PRIMALITY_COMPARATOR = (a, b) -> {
        boolean aFunc = a instanceof TraceFunctionSymbol;
        boolean bFunc = b instanceof TraceFunctionSymbol;
        if (aFunc && !bFunc) {
            return -1;
        }
        if (!aFunc && bFunc) {
            return 1;
        }
        boolean aPrim = a.isPrimary();
        boolean bPrim = b.isPrimary();
        if (aPrim && !bPrim) {
            return -1;
        }
        if (!aPrim && bPrim) {
            return 1;
        }
        return 0;
    };

    public Trace getTrace();

    public TraceSymbol getSymbolByID(long var1);

    public TraceNamespaceSymbol getGlobalNamespace();

    public TraceLabelSymbolView labels();

    public TraceNamespaceSymbolView namespaces();

    public TraceClassSymbolView classes();

    public TraceFunctionSymbolView functions();

    public TraceParameterSymbolView parameters();

    public TraceLocalVariableSymbolView localVariables();

    public TraceGlobalVariableSymbolView globalVariables();

    public TraceSymbolView<? extends TraceNamespaceSymbol> allNamespaces();

    public TraceSymbolWithAddressNoDuplicatesView<? extends TraceVariableSymbol> allLocals();

    public TraceSymbolWithAddressNoDuplicatesView<? extends TraceSymbol> allVariables();

    public TraceSymbolWithLocationView<? extends TraceSymbol> labelsAndFunctions();

    public TraceSymbolNoDuplicatesView<? extends TraceSymbol> notLabelsNorFunctions();

    public TraceSymbolView<? extends TraceSymbol> allSymbols();

    public Collection<Long> getIDsAdded(long var1, long var3);

    public Collection<Long> getIDsRemoved(long var1, long var3);
}

