/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.listing;

import ghidra.program.model.address.AddressRange;
import ghidra.program.model.lang.Register;
import ghidra.trace.model.listing.TraceBaseCodeUnitsView;
import ghidra.trace.model.listing.TraceCodeUnit;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceRegisterUtils;
import java.util.HashSet;
import java.util.Set;

public interface TraceBaseCodeUnitsRegisterView<T extends TraceCodeUnit>
extends TraceBaseCodeUnitsView<T> {
    public TraceThread getThread();

    default public Set<Register> getRegisters() {
        return new HashSet<Register>(this.getThread().getTrace().getBaseLanguage().getRegisters());
    }

    default public T getForRegister(long snap, Register register) {
        Object candidate = this.getContaining(snap, register.getAddress());
        if (candidate == null) {
            return null;
        }
        AddressRange range = TraceRegisterUtils.rangeForRegister(register);
        int cmpMax = range.getMaxAddress().compareTo((Object)candidate.getMaxAddress());
        if (cmpMax > 0) {
            return null;
        }
        if (cmpMax == 0 && candidate.getMinAddress().equals((Object)register.getAddress())) {
            return candidate;
        }
        if (!(candidate instanceof TraceData)) {
            return null;
        }
        TraceData data = (TraceData)candidate;
        return (T)TraceRegisterUtils.seekComponent(data, range);
    }

    default public T getContaining(long snap, Register register) {
        Object candidate = this.getContaining(snap, register.getAddress());
        if (candidate == null) {
            return null;
        }
        AddressRange range = TraceRegisterUtils.rangeForRegister(register);
        int cmpMax = range.getMaxAddress().compareTo((Object)candidate.getMaxAddress());
        if (cmpMax > 0) {
            return null;
        }
        return candidate;
    }

    default public Iterable<? extends T> get(long snap, Register register, boolean forward) {
        return this.get(snap, TraceRegisterUtils.rangeForRegister(register), forward);
    }
}

