/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.breakpoint;

import com.google.common.collect.Range;
import db.DBHandle;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.breakpoint.DBTraceBreakpoint;
import ghidra.trace.database.breakpoint.DBTraceBreakpointSpace;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.space.DBTraceDelegatingManager;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceBreakpointManager;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.LockHold;
import ghidra.util.database.DBOpenMode;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceBreakpointManager
extends AbstractDBTraceSpaceBasedManager<DBTraceBreakpointSpace, DBTraceBreakpointSpace>
implements TraceBreakpointManager,
DBTraceDelegatingManager<DBTraceBreakpointSpace> {
    protected static final String NAME = "Breakpoint";

    public DBTraceBreakpointManager(DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager) throws VersionException, IOException {
        super(NAME, dbh, openMode, lock, monitor, baseLanguage, trace, threadManager);
        this.loadSpaces();
    }

    @Override
    protected DBTraceBreakpointSpace createSpace(AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        return new DBTraceBreakpointSpace(this, this.dbh, space, ent);
    }

    @Override
    protected DBTraceBreakpointSpace createRegisterSpace(AddressSpace space, DBTraceThread thread, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DBTraceBreakpointSpace getForSpace(AddressSpace space, boolean createIfAbsent) {
        return (DBTraceBreakpointSpace)super.getForSpace(space, createIfAbsent);
    }

    @Override
    public Lock readLock() {
        return this.lock.readLock();
    }

    @Override
    public Lock writeLock() {
        return this.lock.writeLock();
    }

    protected void checkDuplicatePath(DBTraceBreakpoint ignore, String path, Range<Long> lifespan) throws DuplicateNameException {
        for (DBTraceBreakpoint dBTraceBreakpoint : this.getBreakpointsByPath(path)) {
            if (dBTraceBreakpoint == ignore || !DBTraceUtils.intersect(lifespan, dBTraceBreakpoint.getLifespan())) continue;
            throw new DuplicateNameException("A breakpoint having path '" + path + "' already exists within an overlapping snap");
        }
    }

    @Override
    public TraceBreakpoint addBreakpoint(String path, Range<Long> lifespan, AddressRange range, Collection<TraceThread> threads, Collection<TraceBreakpointKind> kinds, boolean enabled, String comment) throws DuplicateNameException {
        this.checkDuplicatePath(null, path, lifespan);
        return (TraceBreakpoint)this.delegateWrite(range.getAddressSpace(), m -> m.addBreakpoint(path, lifespan, range, threads, kinds, enabled, comment));
    }

    public Collection<? extends DBTraceBreakpoint> getAllBreakpoints() {
        return this.delegateCollection(this.getActiveMemorySpaces(), m -> m.getAllBreakpoints());
    }

    public Collection<? extends DBTraceBreakpoint> getBreakpointsByPath(String path) {
        return this.delegateCollection(this.getActiveMemorySpaces(), m -> m.getBreakpointsByPath(path));
    }

    @Override
    public TraceBreakpoint getPlacedBreakpointByPath(long snap, String path) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            TraceBreakpoint traceBreakpoint = this.getBreakpointsByPath(path).stream().filter(b -> b.getLifespan().contains((Comparable)Long.valueOf(snap))).findAny().orElse(null);
            return traceBreakpoint;
        }
    }

    public Collection<? extends DBTraceBreakpoint> getBreakpointsAt(long snap, Address address) {
        return (Collection)this.delegateRead(address.getAddressSpace(), m -> m.getBreakpointsAt(snap, address), Collections.emptyList());
    }

    public Collection<? extends DBTraceBreakpoint> getBreakpointsIntersecting(Range<Long> span, AddressRange range) {
        return (Collection)this.delegateRead(range.getAddressSpace(), m -> m.getBreakpointsIntersecting(span, range), Collections.emptyList());
    }
}

