/*
 * Decompiled with CFR 0.152.
 */
package ghidra.sleigh.grammar;

import ghidra.sleigh.grammar.Location;
import java.math.BigInteger;
import java.util.Random;

public class RadixBigInteger
extends BigInteger {
    private static final long serialVersionUID = -7927157989937732244L;
    protected int preferredRadix = 10;
    public final Location location;

    public RadixBigInteger(Location location, byte[] val) {
        super(val);
        this.location = location;
    }

    public RadixBigInteger(Location location, String val) {
        super(val);
        this.location = location;
    }

    public RadixBigInteger(Location location, int signum, byte[] magnitude) {
        super(signum, magnitude);
        this.location = location;
    }

    public RadixBigInteger(Location location, String val, int radix) {
        super(val, radix);
        this.preferredRadix = radix;
        this.location = location;
    }

    public RadixBigInteger(Location location, int numBits, Random rnd) {
        super(numBits, rnd);
        this.location = location;
    }

    public RadixBigInteger(Location location, int bitLength, int certainty, Random rnd) {
        super(bitLength, certainty, rnd);
        this.location = location;
    }

    public int getPreferredRadix() {
        return this.preferredRadix;
    }

    public void setPreferredRadix(int preferredRadix) {
        this.preferredRadix = preferredRadix;
    }

    @Override
    public String toString() {
        Object s = super.toString(this.preferredRadix);
        if (this.preferredRadix == 16) {
            s = "0x" + (String)s;
        }
        return s;
    }
}

