/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.database.function.FunctionDB;
import ghidra.program.database.symbol.CodeSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.DataTypeSymbol;
import ghidra.program.model.pcode.FunctionPrototype;
import ghidra.program.model.pcode.GlobalSymbolMap;
import ghidra.program.model.pcode.HighConstant;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.HighGlobal;
import ghidra.program.model.pcode.HighLocal;
import ghidra.program.model.pcode.HighOther;
import ghidra.program.model.pcode.HighParam;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.JumpTable;
import ghidra.program.model.pcode.LocalSymbolMap;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.PcodeException;
import ghidra.program.model.pcode.PcodeSyntaxTree;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeAST;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlPullParserFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class HighFunction
extends PcodeSyntaxTree {
    public static final String DECOMPILER_TAG_MAP = "decompiler_tags";
    private Function func;
    private Language language;
    private CompilerSpec compilerSpec;
    private FunctionPrototype proto;
    private LocalSymbolMap localSymbols;
    private GlobalSymbolMap globalSymbols;
    private List<JumpTable> jumpTables;
    private List<DataTypeSymbol> protoOverrides;

    public HighFunction(Function function, Language language, CompilerSpec compilerSpec, PcodeDataTypeManager dtManager) {
        super(function.getProgram().getAddressFactory(), dtManager);
        this.func = function;
        this.language = language;
        this.compilerSpec = compilerSpec;
        this.localSymbols = new LocalSymbolMap(this, "stack");
        this.globalSymbols = new GlobalSymbolMap(this);
        this.proto = new FunctionPrototype(this.localSymbols, function);
        this.jumpTables = null;
        this.protoOverrides = null;
    }

    public Function getFunction() {
        return this.func;
    }

    public long getID() {
        if (this.func instanceof FunctionDB) {
            return this.func.getSymbol().getID();
        }
        return this.func.getProgram().getSymbolTable().getDynamicSymbolID(this.func.getEntryPoint());
    }

    public Language getLanguage() {
        return this.language;
    }

    public CompilerSpec getCompilerSpec() {
        return this.compilerSpec;
    }

    public FunctionPrototype getFunctionPrototype() {
        return this.proto;
    }

    public JumpTable[] getJumpTables() {
        if (this.jumpTables == null) {
            return new JumpTable[0];
        }
        JumpTable[] res = new JumpTable[this.jumpTables.size()];
        return this.jumpTables.toArray(res);
    }

    public LocalSymbolMap getLocalSymbolMap() {
        return this.localSymbols;
    }

    public GlobalSymbolMap getGlobalSymbolMap() {
        return this.globalSymbols;
    }

    public HighSymbol getMappedSymbol(Address addr, Address pcaddr) {
        return this.localSymbols.findLocal(addr, pcaddr);
    }

    @Override
    public HighSymbol getSymbol(long symbolId) {
        return this.localSymbols.getSymbol(symbolId);
    }

    public void grabFromFunction(int overrideExtrapop, boolean includeDefaultNames, boolean doOverride) {
        this.localSymbols.grabFromFunction(includeDefaultNames);
        this.proto.grabFromFunction(this.func, overrideExtrapop, doOverride);
        this.jumpTables = null;
        this.protoOverrides = null;
        this.grabOverrides();
    }

    private void grabOverrides() {
        SymbolTable symtab = this.func.getProgram().getSymbolTable();
        Namespace space = HighFunction.findOverrideSpace(this.func);
        if (space == null) {
            return;
        }
        SymbolIterator iter = symtab.getSymbols(space);
        while (iter.hasNext()) {
            DataTypeSymbol protover;
            Symbol sym = iter.next();
            String nm = sym.getName();
            if (nm.length() < 3) continue;
            if ((nm = nm.substring(0, 3)).equals("jmp")) {
                JumpTable jumpTab;
                Object obj = sym.getObject();
                if (!(obj instanceof Namespace) || (jumpTab = JumpTable.readOverride((Namespace)obj, symtab)) == null) continue;
                if (this.jumpTables == null) {
                    this.jumpTables = new ArrayList<JumpTable>();
                }
                this.jumpTables.add(jumpTab);
                continue;
            }
            if (!nm.equals("prt") || sym.getSymbolType() != SymbolType.LABEL || (protover = HighFunctionDBUtil.readOverride(sym)) == null) continue;
            if (this.protoOverrides == null) {
                this.protoOverrides = new ArrayList<DataTypeSymbol>();
            }
            this.protoOverrides.add(protover);
        }
    }

    @Override
    public Varnode newVarnode(int sz, Address addr) {
        addr = this.func.getEntryPoint().getAddressSpace().getOverlayAddress(addr);
        return super.newVarnode(sz, addr);
    }

    @Override
    public Varnode newVarnode(int sz, Address addr, int id) {
        addr = this.func.getEntryPoint().getAddressSpace().getOverlayAddress(addr);
        return super.newVarnode(sz, addr, id);
    }

    private void readHighXML(XmlPullParser parser) throws PcodeXMLException {
        HighVariable var;
        XmlElement el = parser.peek();
        String classstring = el.getAttribute("class");
        switch (classstring.charAt(0)) {
            case 'o': {
                var = new HighOther(this);
                break;
            }
            case 'g': {
                var = new HighGlobal(this);
                break;
            }
            case 'l': {
                var = new HighLocal(this);
                break;
            }
            case 'p': {
                var = new HighParam(this);
                break;
            }
            case 'c': {
                var = new HighConstant(this);
                break;
            }
            default: {
                throw new PcodeXMLException("Unknown HighVariable class string: " + classstring);
            }
        }
        var.restoreXml(parser);
    }

    private void readHighlistXML(XmlPullParser parser) throws PcodeXMLException {
        XmlElement el = parser.start(new String[]{"highlist"});
        while (parser.peek().isStart()) {
            this.readHighXML(parser);
        }
        parser.end(el);
    }

    @Override
    public void readXML(XmlPullParser parser) throws PcodeXMLException {
        XmlElement start = parser.start(new String[]{"function"});
        String name = start.getAttribute("name");
        if (!this.func.getName().equals(name)) {
            throw new PcodeXMLException("Function name mismatch: " + this.func.getName() + " + " + name);
        }
        while (!parser.peek().isEnd()) {
            XmlElement subel = parser.peek();
            if (subel.getName().equals("addr")) {
                subel = parser.start(new String[]{"addr"});
                Address addr = AddressXML.readXML(subel, this.getAddressFactory());
                parser.end(subel);
                addr = this.func.getEntryPoint().getAddressSpace().getOverlayAddress(addr);
                if (this.func.getEntryPoint().equals(addr)) continue;
                throw new PcodeXMLException("Mismatched address in function tag");
            }
            if (subel.getName().equals("prototype")) {
                this.proto.readPrototypeXML(parser, this.getDataTypeManager());
                continue;
            }
            if (subel.getName().equals("localdb")) {
                this.localSymbols.parseScopeXML(parser);
                continue;
            }
            if (subel.getName().equals("ast")) {
                super.readXML(parser);
                continue;
            }
            if (subel.getName().equals("highlist")) {
                this.readHighlistXML(parser);
                continue;
            }
            if (subel.getName().equals("jumptablelist")) {
                this.readJumpTableListXML(parser);
                continue;
            }
            if (subel.getName().equals("override")) {
                parser.discardSubTree();
                continue;
            }
            if (subel.getName().equals("scope")) {
                parser.discardSubTree();
                continue;
            }
            throw new PcodeXMLException("Unknown tag in function: " + subel.getName());
        }
        parser.end(start);
    }

    private void readJumpTableListXML(XmlPullParser parser) throws PcodeXMLException {
        XmlElement el = parser.start(new String[]{"jumptablelist"});
        while (parser.peek().isStart()) {
            JumpTable table = new JumpTable(this.func.getEntryPoint().getAddressSpace());
            table.restoreXml(parser, this.getAddressFactory());
            if (table.isEmpty()) continue;
            if (this.jumpTables == null) {
                this.jumpTables = new ArrayList<JumpTable>();
            }
            this.jumpTables.add(table);
        }
        parser.end(el);
    }

    protected Address getPCAddress(Varnode rep) {
        Address pcaddr = null;
        if (!rep.isAddrTied() && (pcaddr = rep.getPCAddress()) == Address.NO_ADDRESS) {
            try {
                pcaddr = this.func.getEntryPoint().add(-1L);
            }
            catch (AddressOutOfBoundsException e) {
                pcaddr = this.func.getEntryPoint();
            }
        }
        return pcaddr;
    }

    public HighVariable splitOutMergeGroup(HighVariable high, Varnode vn) throws PcodeException {
        try {
            HighVariable resremain;
            HighLocal reslocal;
            HighSymbol sym;
            Varnode[] curinst;
            ArrayList<Varnode> newinst = new ArrayList<Varnode>();
            ArrayList<Varnode> oldinst = new ArrayList<Varnode>();
            short ourgroup = vn.getMergeGroup();
            for (Varnode curvn : curinst = high.getInstances()) {
                if (curvn.getMergeGroup() == ourgroup) {
                    newinst.add(curvn);
                    continue;
                }
                oldinst.add(curvn);
            }
            if (oldinst.size() == 0) {
                return high;
            }
            if (!(high instanceof HighLocal)) {
                throw new PcodeException("Variable " + high.getName() + " is speculatively merged but not a local");
            }
            HighLocal highloc = (HighLocal)high;
            Varnode[] newinstarray = new Varnode[newinst.size()];
            newinst.toArray(newinstarray);
            Varnode[] oldinstarray = new Varnode[oldinst.size()];
            oldinst.toArray(oldinstarray);
            Varnode oldrep = high.getRepresentative();
            if (oldrep.getMergeGroup() == ourgroup) {
                if (high instanceof HighParam) {
                    return high;
                }
                vn = oldrep;
                oldrep = oldinstarray[0];
                sym = highloc.getSymbol();
                reslocal = new HighLocal(highloc.getDataType(), highloc.getRepresentative(), null, highloc.getPCAddress(), sym);
                resremain = new HighOther(highloc.getDataType(), new Varnode(oldrep.getAddress(), highloc.getSize()), null, oldrep.getPCAddress(), this);
            } else {
                sym = this.localSymbols.newMappedSymbol(0L, highloc.getName(), highloc.getDataType(), new VariableStorage(this.func.getProgram(), vn), vn.getPCAddress(), -1);
                reslocal = new HighLocal(highloc.getDataType(), vn, null, vn.getPCAddress(), sym);
                resremain = highloc;
            }
            sym.setHighVariable(reslocal);
            reslocal.attachInstances(newinstarray, vn);
            for (Varnode element : newinstarray) {
                ((VarnodeAST)element).setHigh(reslocal);
            }
            resremain.attachInstances(oldinstarray, oldrep);
            for (Varnode element : oldinstarray) {
                ((VarnodeAST)element).setHigh(resremain);
            }
            return reslocal;
        }
        catch (InvalidInputException e) {
            throw new PcodeXMLException("Bad storage node", e);
        }
    }

    public String buildFunctionXML(long id, Namespace namespace, Address entryPoint, int size) {
        boolean hasOverrideTag;
        StringBuilder resBuf = new StringBuilder();
        resBuf.append("<function");
        if (id != 0L) {
            SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)resBuf, (String)"id", (long)id);
        }
        SpecXmlUtils.xmlEscapeAttribute((StringBuilder)resBuf, (String)"name", (String)this.func.getName());
        SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)resBuf, (String)"size", (long)size);
        if (this.func.isInline()) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)resBuf, (String)"inline", (boolean)true);
        }
        if (this.func.hasNoReturn()) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)resBuf, (String)"noreturn", (boolean)true);
        }
        resBuf.append(">\n");
        if (entryPoint == null) {
            AddressXML.buildXML(resBuf, this.func.getEntryPoint());
        } else {
            AddressXML.buildXML(resBuf, entryPoint);
        }
        this.localSymbols.buildLocalDbXML(resBuf, namespace);
        this.proto.buildPrototypeXML(resBuf, this.getDataTypeManager());
        if (this.jumpTables != null && this.jumpTables.size() > 0) {
            resBuf.append("<jumptablelist>\n");
            for (JumpTable jumpTable : this.jumpTables) {
                jumpTable.buildXml(resBuf);
            }
            resBuf.append("</jumptablelist>\n");
        }
        boolean bl = hasOverrideTag = this.protoOverrides != null && this.protoOverrides.size() > 0;
        if (hasOverrideTag) {
            resBuf.append("<override>\n");
        }
        if (this.protoOverrides != null && this.protoOverrides.size() > 0) {
            PcodeDataTypeManager dtmanage = this.getDataTypeManager();
            for (DataTypeSymbol sym : this.protoOverrides) {
                Address addr = sym.getAddress();
                FunctionPrototype fproto = new FunctionPrototype((FunctionSignature)((Object)sym.getDataType()), this.compilerSpec, false);
                resBuf.append("<protooverride>\n");
                AddressXML.buildXML(resBuf, addr);
                fproto.buildPrototypeXML(resBuf, dtmanage);
                resBuf.append("</protooverride>\n");
            }
        }
        if (hasOverrideTag) {
            resBuf.append("</override>\n");
        }
        resBuf.append("</function>\n");
        return resBuf.toString();
    }

    public static ErrorHandler getErrorHandler(final Object errOriginator, final String targetName) {
        return new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                Msg.error((Object)errOriginator, (Object)("Error parsing " + targetName), (Throwable)exception);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                Msg.error((Object)errOriginator, (Object)("Fatal error parsing " + targetName), (Throwable)exception);
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                Msg.warn((Object)errOriginator, (Object)("Warning parsing " + targetName), (Throwable)exception);
            }
        };
    }

    public static Namespace findOverrideSpace(Function func) {
        SymbolTable symtab = func.getProgram().getSymbolTable();
        return HighFunction.findNamespace(symtab, func, "override");
    }

    public static Namespace findCreateOverrideSpace(Function func) {
        SymbolTable symtab = func.getProgram().getSymbolTable();
        return HighFunction.findCreateNamespace(symtab, func, "override");
    }

    public static Namespace findNamespace(SymbolTable symtab, Namespace parent, String name) {
        return symtab.getNamespace(name, parent);
    }

    public static void createLabelSymbol(SymbolTable symtab, Address addr, String name, Namespace namespace, SourceType source, boolean useLocalNamespace) throws InvalidInputException {
        if (namespace == null && useLocalNamespace) {
            namespace = symtab.getNamespace(addr);
        }
        symtab.createLabel(addr, name, namespace, source);
    }

    public static void deleteSymbol(SymbolTable symtab, Address addr, String name, Namespace space) throws InvalidInputException {
        Symbol s = symtab.getSymbol(name, addr, space);
        if (s == null) {
            throw new InvalidInputException("Symbol " + name + " not found!");
        }
        if (s.getSource() == SourceType.DEFAULT) {
            throw new InvalidInputException("Deleting the default symbol \"" + name + "\" @ " + addr + " is not allowed.");
        }
        boolean success = symtab.removeSymbolSpecial(s);
        if (!success) {
            throw new InvalidInputException("Couldn't delete the symbol \"" + name + "\" @ " + addr + ".");
        }
    }

    public static boolean clearNamespace(SymbolTable symtab, Namespace space) throws InvalidInputException {
        SymbolIterator iter = symtab.getSymbols(space);
        ArrayList<Address> addrlist = new ArrayList<Address>();
        ArrayList<String> namelist = new ArrayList<String>();
        while (iter.hasNext()) {
            Symbol sym = iter.next();
            if (!(sym instanceof CodeSymbol)) {
                return false;
            }
            addrlist.add(sym.getAddress());
            namelist.add(sym.getName());
        }
        for (int i = 0; i < addrlist.size(); ++i) {
            HighFunction.deleteSymbol(symtab, (Address)addrlist.get(i), (String)namelist.get(i), space);
        }
        return true;
    }

    public static Namespace findCreateNamespace(SymbolTable symtab, Namespace parentspace, String name) {
        Namespace res = HighFunction.findNamespace(symtab, parentspace, name);
        if (res == null) {
            try {
                return symtab.createNameSpace(parentspace, name, SourceType.USER_DEFINED);
            }
            catch (DuplicateNameException e) {
                return null;
            }
            catch (InvalidInputException e) {
                return null;
            }
        }
        return res;
    }

    public static XmlPullParser stringTree(InputStream xml, ErrorHandler handler) throws PcodeXMLException {
        try {
            XmlPullParser parser = XmlPullParserFactory.create((InputStream)xml, (String)"Decompiler Result Parser", (ErrorHandler)handler, (boolean)false);
            return parser;
        }
        catch (Exception e) {
            throw new PcodeXMLException("XML parsing error: " + e.getMessage(), e);
        }
    }

    public static final boolean collapseToGlobal(Namespace namespace) {
        return namespace instanceof Library;
    }

    public static void createNamespaceTag(StringBuilder buf, Namespace namespace) {
        buf.append("<parent>\n");
        if (namespace != null) {
            ArrayList<Namespace> arr = new ArrayList<Namespace>();
            for (Namespace curspc = namespace; curspc != null; curspc = curspc.getParentNamespace()) {
                arr.add(0, curspc);
                if (HighFunction.collapseToGlobal(curspc)) break;
            }
            buf.append("<val/>\n");
            for (int i = 1; i < arr.size(); ++i) {
                Namespace curScope = (Namespace)arr.get(i);
                buf.append("<val");
                SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"id", (long)curScope.getID());
                buf.append('>');
                SpecXmlUtils.xmlEscape((StringBuilder)buf, (String)curScope.getName());
                buf.append("</val>\n");
            }
        }
        buf.append("</parent>\n");
    }

    public static String tagFindExclude(String tagname, String doc) {
        if (doc == null) {
            return null;
        }
        int length = tagname.length();
        int bindex = doc.indexOf("<" + tagname);
        if (bindex == -1) {
            return null;
        }
        if (bindex + length + 3 > doc.length()) {
            return null;
        }
        if (doc.charAt(bindex + length + 1) == '/') {
            return "";
        }
        int eindex = doc.indexOf("</" + tagname + ">");
        if (eindex == -1) {
            return null;
        }
        return doc.substring(bindex + length + 2, eindex);
    }
}

