/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class Register
implements Serializable,
Comparable<Register> {
    private static final List<String> EMPTY_COLLECTION = new ArrayList<String>();
    private static final long serialVersionUID = 1L;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_FP = 1;
    public static final int TYPE_SP = 2;
    public static final int TYPE_PC = 4;
    public static final int TYPE_CONTEXT = 8;
    public static final int TYPE_ZERO = 16;
    public static final int TYPE_HIDDEN = 32;
    public static final int TYPE_DOES_NOT_FOLLOW_FLOW = 64;
    public static final int TYPE_VECTOR = 128;
    public static final Register NO_CONTEXT = new Register("NO_CONTEXT", "NO_CONTEXT", Address.NO_ADDRESS, 4, true, 0);
    private String name;
    private String description;
    private Address address;
    private int numBytes;
    private int leastSigBit;
    private int bitLength;
    private int typeFlags;
    private boolean bigEndian;
    private List<Register> childRegisters = new ArrayList<Register>();
    private Set<String> aliases = new HashSet<String>();
    private byte[] baseMask;
    private int leastSigBitInBaseRegister = 0;
    private Register parent;
    private Register baseRegister;
    private String group;
    private TreeSet<Integer> laneSizes;

    public Register(String name, String description, Address address, int numBytes, boolean bigEndian, int typeFlags) {
        this(name, description, address, numBytes, 0, numBytes * 8, bigEndian, typeFlags);
    }

    public Register(Register register) {
        this(register.name, register.description, register.address, register.numBytes, register.leastSigBit, register.bitLength, register.bigEndian, register.typeFlags);
    }

    public Register(String name, String description, Address address, int numBytes, int leastSignificantBit, int bitLength, boolean bigEndian, int typeFlags) {
        this.name = name;
        this.description = description;
        this.address = address;
        this.leastSigBit = leastSignificantBit;
        this.numBytes = numBytes;
        this.typeFlags = typeFlags;
        this.bigEndian = bigEndian;
        this.bitLength = bitLength;
        int leastSigByte = leastSignificantBit / 8;
        int mostSigByte = (leastSignificantBit + bitLength - 1) / 8;
        int extraLowerBytes = leastSigByte;
        int extraHighBytes = numBytes - mostSigByte - 1;
        if (bigEndian) {
            if (extraLowerBytes > 0) {
                this.numBytes = numBytes - extraLowerBytes;
                this.leastSigBit -= extraLowerBytes * 8;
            }
            if (extraHighBytes > 0) {
                this.address = address.add(extraHighBytes);
                this.numBytes -= extraHighBytes;
            }
        } else {
            if (extraLowerBytes > 0) {
                this.address = address.add(extraLowerBytes);
                this.numBytes -= extraLowerBytes;
                this.leastSigBit -= extraLowerBytes * 8;
            }
            if (extraHighBytes > 0) {
                this.numBytes -= extraHighBytes;
            }
        }
    }

    void addAlias(String alias) {
        if (this.name.equals(alias)) {
            return;
        }
        if (this.aliases == null) {
            this.aliases = new HashSet<String>();
        }
        this.aliases.add(alias);
    }

    void removeAlias(String alias) {
        if (this.aliases != null) {
            this.aliases.remove(alias);
        }
    }

    public Iterable<String> getAliases() {
        if (this.aliases == null) {
            return EMPTY_COLLECTION;
        }
        return this.aliases;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public int getBitLength() {
        return this.bitLength;
    }

    public int getMinimumByteSize() {
        return (this.bitLength + 7) / 8;
    }

    public int getNumBytes() {
        return this.numBytes;
    }

    public int getOffset() {
        return (int)this.address.getOffset();
    }

    public int getLeastSignificantBit() {
        return this.leastSigBit;
    }

    public boolean isDefaultFramePointer() {
        return (this.typeFlags & 1) != 0;
    }

    public boolean followsFlow() {
        return (this.typeFlags & 0x40) == 0;
    }

    public boolean isHidden() {
        return (this.typeFlags & 0x20) != 0;
    }

    public boolean isProgramCounter() {
        return (this.typeFlags & 4) != 0;
    }

    public boolean isProcessorContext() {
        return (this.typeFlags & 8) != 0;
    }

    public boolean isZero() {
        return (this.typeFlags & 0x10) != 0;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Register.class != o.getClass()) {
            return false;
        }
        Register rd = (Register)o;
        return rd.name.equals(this.name) && rd.bitLength == this.bitLength && rd.address.equals(this.address) && rd.leastSigBit == this.leastSigBit;
    }

    public int hashCode() {
        return (int)this.address.getOffset();
    }

    public AddressSpace getAddressSpace() {
        return this.address.getAddressSpace();
    }

    @Override
    public int compareTo(Register other) {
        int result = this.getBaseRegister().equals(other.getBaseRegister()) ? this.leastSigBitInBaseRegister - other.leastSigBitInBaseRegister : this.address.compareTo(other.address);
        if (result == 0) {
            result = this.bitLength - other.bitLength;
        }
        return result;
    }

    public Address getAddress() {
        return this.address;
    }

    public Register getParentRegister() {
        return this.parent;
    }

    public List<Register> getChildRegisters() {
        return new ArrayList<Register>(this.childRegisters);
    }

    public Register getBaseRegister() {
        if (this.baseRegister != null) {
            return this.baseRegister;
        }
        return this;
    }

    public int getLeastSignificatBitInBaseRegister() {
        return this.leastSigBitInBaseRegister;
    }

    void setParent(Register parent) {
        this.parent = parent;
        this.updateBaseRegisterInfo();
        for (Register child : this.childRegisters) {
            child.updateBaseRegisterInfo();
        }
    }

    private void updateBaseRegisterInfo() {
        this.baseRegister = this.parent.getBaseRegister();
        this.baseMask = null;
        int baseStartAddr = this.baseRegister.getOffset();
        int baseEndAddr = baseStartAddr + this.baseRegister.numBytes;
        int myStartAddr = this.getOffset();
        int myEndAddr = myStartAddr + this.numBytes;
        if (this.bigEndian) {
            int bytesAfterMe = baseEndAddr - myEndAddr;
            this.leastSigBitInBaseRegister = this.leastSigBit + bytesAfterMe * 8;
        } else {
            int bytesBeforeMe = myStartAddr - baseStartAddr;
            this.leastSigBitInBaseRegister = this.leastSigBit + bytesBeforeMe * 8;
        }
        for (Register child : this.childRegisters) {
            child.updateBaseRegisterInfo();
        }
    }

    void setChildRegisters(Register[] childRegisters) {
        for (Register register : childRegisters) {
            if (register.isProcessorContext()) {
                this.typeFlags |= 8;
            }
            register.setParent(this);
        }
        this.childRegisters = Arrays.asList(childRegisters);
        Collections.sort(this.childRegisters);
    }

    public int getTypeFlags() {
        return this.typeFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBaseMask() {
        if (this.baseMask == null) {
            Register register = this;
            synchronized (register) {
                Register base = this.getBaseRegister();
                int byteLength = (base.getBitLength() + 7) / 8;
                byte[] newBaseMask = new byte[byteLength];
                int endBit = this.leastSigBitInBaseRegister + this.bitLength - 1;
                for (int i = this.leastSigBitInBaseRegister; i <= endBit; ++i) {
                    this.setBit(newBaseMask, i);
                }
                this.baseMask = newBaseMask;
            }
        }
        return this.baseMask;
    }

    private void setBit(byte[] byteMask, int bit) {
        int byteNum = byteMask.length - bit / 8 - 1;
        int bitNum = bit % 8;
        int n = byteNum;
        byteMask[n] = (byte)(byteMask[n] | 1 << bitNum);
    }

    void setFlag(int flag) {
        this.typeFlags |= flag;
    }

    public boolean hasChildren() {
        return this.childRegisters.size() != 0;
    }

    void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean isBaseRegister() {
        return this.baseRegister == null;
    }

    public boolean contains(Register reg) {
        if (this.equals(reg)) {
            return true;
        }
        for (Register child : this.childRegisters) {
            if (!child.contains(reg)) continue;
            return true;
        }
        return false;
    }

    void rename(String newName) {
        if (this.aliases != null) {
            this.aliases.remove(newName);
        }
        this.name = newName;
    }

    public boolean isVectorRegister() {
        return (this.typeFlags & 0x80) != 0;
    }

    public boolean isValidLaneSize(int laneSizeInBytes) {
        if (!this.isVectorRegister()) {
            return false;
        }
        if (this.laneSizes == null) {
            return false;
        }
        return this.laneSizes.contains(laneSizeInBytes);
    }

    public int[] getLaneSizes() {
        if (this.laneSizes == null) {
            return null;
        }
        int[] sizes = new int[this.laneSizes.size()];
        int index = 0;
        for (int size : this.laneSizes) {
            sizes[index++] = size;
        }
        return sizes;
    }

    void addLaneSize(int laneSizeInBytes) {
        if (8 * this.numBytes != this.bitLength) {
            throw new UnsupportedOperationException("Register " + this.getName() + " does not support lanes");
        }
        if (laneSizeInBytes <= 0 || laneSizeInBytes >= this.numBytes || this.numBytes % laneSizeInBytes != 0) {
            throw new IllegalArgumentException("Invalid lane size: " + laneSizeInBytes + " for register " + this.getName());
        }
        if (this.laneSizes == null) {
            this.laneSizes = new TreeSet();
        }
        this.typeFlags |= 0x80;
        this.laneSizes.add(laneSizeInBytes);
    }
}

