/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.block;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.PartitionCodeSubModel;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.LinkedList;

class PartitionCodeSubIterator
implements CodeBlockIterator {
    private Listing listing = null;
    private CodeBlock nextSub = null;
    private InstructionIterator instIter;
    private AddressSet addrCoveredSoFar = new AddressSet();
    private LinkedList<CodeBlock> blockList = new LinkedList();
    private PartitionCodeSubModel model = null;
    private TaskMonitor monitor;

    PartitionCodeSubIterator(PartitionCodeSubModel model, TaskMonitor monitor) {
        this(model, model.getProgram().getMinAddress(), monitor);
    }

    PartitionCodeSubIterator(PartitionCodeSubModel model, Address addr, TaskMonitor monitor) {
        this.model = model;
        this.monitor = monitor != null ? monitor : TaskMonitor.DUMMY;
        this.listing = model.getListing();
        this.instIter = this.listing.getInstructions(addr, true);
        this.nextSub = null;
        this.monitor.setIndeterminate(true);
    }

    PartitionCodeSubIterator(PartitionCodeSubModel model, AddressSetView set, TaskMonitor monitor) {
        this.model = model;
        this.monitor = monitor != null ? monitor : TaskMonitor.DUMMY;
        this.listing = model.getListing();
        this.instIter = this.listing.getInstructions(set, true);
        this.nextSub = null;
    }

    @Override
    public boolean hasNext() throws CancelledException {
        if (this.nextSub != null) {
            return true;
        }
        if (!this.blockList.isEmpty()) {
            this.nextSub = this.blockList.removeFirst();
            if (this.nextSub != null) {
                return true;
            }
        }
        while (this.nextSub == null && this.instIter.hasNext()) {
            CodeBlock block;
            Instruction inst = this.instIter.next();
            Address minAddr = inst.getMinAddress();
            if (this.addrCoveredSoFar.contains(minAddr) || (block = this.model.getFirstCodeBlockContaining(minAddr, this.monitor)) == null) continue;
            this.addrCoveredSoFar.add(block);
            this.nextSub = block;
        }
        return this.nextSub != null;
    }

    @Override
    public CodeBlock next() throws CancelledException {
        if (this.nextSub == null) {
            this.hasNext();
        }
        CodeBlock retSub = this.nextSub;
        this.nextSub = null;
        return retSub;
    }
}

