/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBRecord;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.data.ProgramDataTypeManager;
import ghidra.program.database.symbol.EquateManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Enum;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.pcode.DynamicHash;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateReference;
import ghidra.util.Lock;
import ghidra.util.UniversalID;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class EquateDB
extends DatabaseObject
implements Equate {
    private DBRecord record;
    private EquateManager equateMgr;

    public EquateDB(EquateManager equateMgr, DBObjectCache<EquateDB> cache, DBRecord record) {
        super(cache, record.getKey());
        this.equateMgr = equateMgr;
        this.record = record;
    }

    @Override
    protected boolean refresh() {
        DBRecord rec = this.equateMgr.getEquateRecord(this.key);
        if (rec == null) {
            return false;
        }
        this.record = rec;
        return true;
    }

    @Override
    public void addReference(Address refAddr, int opIndex) {
        this.checkDeleted();
        try {
            long value;
            long[] hashArray;
            Instruction instr = this.equateMgr.getProgram().getCodeManager().getInstructionAt(refAddr);
            long dynamicHash = instr == null ? 0L : ((hashArray = DynamicHash.calcConstantHash(instr, value = this.record.getLongValue(1))).length != 1 ? 0L : hashArray[0]);
            this.equateMgr.addReference(this.key, refAddr, (short)opIndex, dynamicHash);
        }
        catch (IOException e) {
            this.equateMgr.dbError(e);
        }
    }

    @Override
    public void addReference(long dynamicHash, Address refAddr) {
        this.checkDeleted();
        try {
            short opIndex = this.findOpIndex(refAddr, dynamicHash);
            this.equateMgr.addReference(this.key, refAddr, opIndex, dynamicHash);
        }
        catch (IOException e) {
            this.equateMgr.dbError(e);
        }
    }

    private short findOpIndex(Address refAddr, long dynamicHash) {
        long[] checkHash;
        Instruction instr = this.equateMgr.getProgram().getCodeManager().getInstructionAt(refAddr);
        if (instr == null) {
            return -1;
        }
        long value = this.record.getLongValue(1);
        for (long element : checkHash = DynamicHash.calcConstantHash(instr, value)) {
            if (element != dynamicHash) continue;
            return this.findScalarOpIndex(instr);
        }
        return -1;
    }

    private short findScalarOpIndex(Instruction instr) {
        int opIndex = -1;
        long value = this.record.getLongValue(1);
        int numOperands = instr.getNumOperands();
        for (int i = 0; i < numOperands; i = (int)((short)(i + 1))) {
            for (Object obj : instr.getOpObjects(i)) {
                if (!(obj instanceof Scalar) || ((Scalar)obj).getValue() != value) continue;
                if (opIndex >= 0) {
                    return -1;
                }
                opIndex = i;
            }
        }
        return (short)opIndex;
    }

    @Override
    public String getName() {
        this.checkIsValid();
        return this.record.getString(0);
    }

    @Override
    public String getDisplayName() {
        String equateName = this.getName();
        if (this.isEnumBased()) {
            UniversalID id;
            ProgramDataTypeManager dtm = this.equateMgr.getProgram().getDataTypeManager();
            Enum enoom = (Enum)dtm.findDataTypeForID(id = EquateManager.getDataTypeUUID(equateName));
            if (enoom == null || enoom.getName(this.getValue()) == null) {
                return EquateManager.formatNameForEquateError(this.getValue());
            }
            return enoom.getName(this.getValue());
        }
        return equateName;
    }

    @Override
    public UniversalID getEnumUUID() {
        String equateName = this.getName();
        if (this.isValidUUID()) {
            return EquateManager.getDataTypeUUID(equateName);
        }
        return null;
    }

    @Override
    public int getReferenceCount() {
        this.checkIsValid();
        try {
            return this.equateMgr.getReferenceCount(this.key);
        }
        catch (IOException e) {
            this.equateMgr.dbError(e);
            return 0;
        }
    }

    @Override
    public EquateReference[] getReferences() {
        this.checkIsValid();
        try {
            return this.equateMgr.getReferences(this.key);
        }
        catch (IOException e) {
            this.equateMgr.dbError(e);
            return new EquateReference[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EquateReference> getReferences(Address refAddr) {
        Lock lock = this.equateMgr.getLock();
        lock.acquire();
        try {
            if (this.checkIsValid()) {
                List<EquateReference> list = this.equateMgr.getReferences(this.key, refAddr);
                return list;
            }
        }
        catch (IOException e) {
            this.equateMgr.getProgram().dbError(e);
        }
        finally {
            lock.release();
        }
        return new ArrayList<EquateReference>();
    }

    @Override
    public long getValue() {
        this.checkIsValid();
        return this.record.getLongValue(1);
    }

    @Override
    public String getDisplayValue() {
        long val = this.getValue();
        return (val < 0L ? "-" : "") + "0x" + Long.toHexString(Math.abs(val));
    }

    @Override
    public void removeReference(Address refAddr, int opIndex) {
        this.checkDeleted();
        try {
            this.equateMgr.removeReference(this, refAddr, (short)opIndex);
        }
        catch (IOException e) {
            this.equateMgr.dbError(e);
        }
    }

    @Override
    public void removeReference(long dynamicHash, Address refAddr) {
        this.checkDeleted();
        try {
            this.equateMgr.removeReference(this, dynamicHash, refAddr);
        }
        catch (IOException e) {
            this.equateMgr.dbError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameEquate(String newName) throws DuplicateNameException, InvalidInputException {
        Lock lock = this.equateMgr.getLock();
        lock.acquire();
        try {
            this.checkDeleted();
            String oldName = this.getName();
            if (oldName.equals(newName)) {
                return;
            }
            try {
                this.equateMgr.getEquateDatabaseAdapter().getRecordKey(newName);
                throw new DuplicateNameException("Equate named " + newName + " already exists");
            }
            catch (NotFoundException notFoundException) {
            }
            catch (IOException e) {
                this.equateMgr.dbError(e);
                lock.release();
                return;
            }
            this.equateMgr.validateName(newName);
            this.record.setString(0, newName);
            this.updateRecord();
            this.equateMgr.equateNameChanged(oldName, newName);
        }
        finally {
            lock.release();
        }
    }

    private void updateRecord() {
        try {
            this.equateMgr.getEquateDatabaseAdapter().updateRecord(this.record);
        }
        catch (IOException e) {
            this.equateMgr.dbError(e);
        }
    }

    @Override
    public boolean isValidUUID() {
        String equateName = this.getDisplayName();
        return equateName != null && !equateName.contains("<BAD EQUATE>");
    }

    @Override
    public boolean isEnumBased() {
        return this.getName().startsWith("dtID");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Equate eq = (Equate)obj;
        if (this.getValue() != eq.getValue()) {
            return false;
        }
        return this.getName().equals(eq.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }
}

