/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Schema;
import ghidra.program.database.data.InstanceSettingsDBAdapterV0;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class InstanceSettingsDBAdapter {
    static final String INSTANCE_TABLE_NAME = "Instance Settings";
    static final Schema INSTANCE_SCHEMA = InstanceSettingsDBAdapterV0.V0_INSTANCE_SCHEMA;
    static final int INST_ADDR_COL = 0;
    static final int INST_NAME_COL = 1;
    static final int INST_LONG_VALUE_COL = 2;
    static final int INST_STRING_VALUE_COL = 3;
    static final int INST_BYTE_VALUE_COL = 4;

    InstanceSettingsDBAdapter() {
    }

    static InstanceSettingsDBAdapter getAdapter(DBHandle handle, int openMode, AddressMap addrMap, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        if (openMode == 0) {
            new InstanceSettingsDBAdapterV0(handle, true);
        }
        try {
            InstanceSettingsDBAdapterV0 adapter = new InstanceSettingsDBAdapterV0(handle, false);
            if (addrMap.isUpgraded()) {
                throw new VersionException(true);
            }
            return adapter;
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            InstanceSettingsDBAdapter adapter = InstanceSettingsDBAdapter.findReadOnlyAdapter(handle);
            if (openMode == 3) {
                adapter = InstanceSettingsDBAdapter.upgrade(handle, adapter, addrMap, monitor);
            }
            return adapter;
        }
    }

    private static InstanceSettingsDBAdapter findReadOnlyAdapter(DBHandle dbHandle) throws VersionException, IOException {
        return new InstanceSettingsDBAdapterV0(dbHandle, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InstanceSettingsDBAdapter upgrade(DBHandle dbHandle, InstanceSettingsDBAdapter oldAdapter, AddressMap addrMap, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        monitor.setMessage("Upgrading Instance Data Settings...");
        monitor.initialize((long)(2 * oldAdapter.getRecordCount()));
        int cnt = 0;
        AddressMap oldAddrMap = addrMap.getOldAddressMap();
        InstanceSettingsDBAdapterV0 tmpAdapter = null;
        try (DBHandle tmpHandle = new DBHandle();){
            tmpHandle.startTransaction();
            tmpAdapter = new InstanceSettingsDBAdapterV0(tmpHandle, true);
            RecordIterator iter = oldAdapter.getRecords();
            while (iter.hasNext()) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                DBRecord rec = iter.next();
                Address addr = oldAddrMap.decodeAddress(rec.getLongValue(0));
                rec.setLongValue(0, addrMap.getKey(addr, true));
                ((InstanceSettingsDBAdapter)tmpAdapter).updateInstanceRecord(rec);
                monitor.setProgress((long)(++cnt));
            }
            dbHandle.deleteTable(INSTANCE_TABLE_NAME);
            InstanceSettingsDBAdapterV0 newAdapter = new InstanceSettingsDBAdapterV0(dbHandle, true);
            iter = ((InstanceSettingsDBAdapter)tmpAdapter).getRecords();
            while (iter.hasNext()) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                DBRecord rec = iter.next();
                ((InstanceSettingsDBAdapter)newAdapter).updateInstanceRecord(rec);
                monitor.setProgress((long)(++cnt));
            }
            InstanceSettingsDBAdapterV0 instanceSettingsDBAdapterV0 = newAdapter;
            return instanceSettingsDBAdapterV0;
        }
    }

    abstract int getRecordCount();

    abstract DBRecord createInstanceRecord(long var1, String var3, String var4, long var5, byte[] var7) throws IOException;

    abstract Field[] getInstanceKeys(long var1) throws IOException;

    abstract boolean removeInstanceRecord(long var1) throws IOException;

    abstract DBRecord getInstanceRecord(long var1) throws IOException;

    abstract void updateInstanceRecord(DBRecord var1) throws IOException;

    abstract RecordIterator getRecords(long var1, long var3) throws IOException;

    abstract RecordIterator getRecords() throws IOException;

    abstract void delete(long var1, long var3, TaskMonitor var5) throws CancelledException, IOException;
}

