/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dmg;

import generic.jar.ResourceFile;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.ios.dmg.DmgClientFileSystem;
import ghidra.file.formats.ios.dmg.DmgConstants;
import ghidra.file.formats.ios.dmg.DmgDecryptorStream;
import ghidra.file.formats.ios.dmg.UDIFHeader;
import ghidra.file.formats.xar.XARUtil;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeByteProvider;
import ghidra.framework.Application;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import utilities.util.ArrayUtilities;

public class DmgClientFileSystemFactory
implements GFileSystemFactoryByteProvider<DmgClientFileSystem>,
GFileSystemProbeByteProvider {
    public boolean probe(ByteProvider byteProvider, FileSystemService fsService, TaskMonitor taskMonitor) throws IOException, CancelledException {
        if (!DmgClientFileSystemFactory.isDmgPresent()) {
            return false;
        }
        if (XARUtil.isXAR(byteProvider)) {
            return false;
        }
        return DmgClientFileSystemFactory.hasUDIF(byteProvider) || DmgClientFileSystemFactory.isEncrypted(byteProvider);
    }

    private static boolean isEncrypted(byte[] startBytes) {
        return ArrayUtilities.arrayRangesEquals((byte[])startBytes, (int)0, (byte[])DmgConstants.DMG_MAGIC_BYTES_v1, (int)0, (int)DmgConstants.DMG_MAGIC_BYTES_v1.length) || ArrayUtilities.arrayRangesEquals((byte[])startBytes, (int)0, (byte[])DmgConstants.DMG_MAGIC_BYTES_v2, (int)0, (int)DmgConstants.DMG_MAGIC_BYTES_v2.length);
    }

    private static boolean isEncrypted(ByteProvider bp) {
        try {
            byte[] startBytes = bp.readBytes(0L, 8L);
            return DmgClientFileSystemFactory.isEncrypted(startBytes);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static boolean hasUDIF(ByteProvider bp) {
        try {
            UDIFHeader udif = UDIFHeader.read(bp);
            return udif.isValid() && udif.hasGoodOffsets(bp);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public DmgClientFileSystem create(FSRLRoot targetFSRL, ByteProvider provider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        ByteProvider decryptedProvider;
        FSRL containerFSRL = provider.getFSRL();
        String dmgName = containerFSRL.getName();
        if (DmgClientFileSystemFactory.isEncrypted(provider)) {
            if (containerFSRL.getNestingDepth() < 2) {
                throw new CryptoException("Unable to decrypt DMG data because DMG crypto keys are specific to the container it is embedded in and this DMG was not in a container");
            }
            String containerName = containerFSRL.getName(1);
            decryptedProvider = fsService.getDerivedByteProvider(containerFSRL, null, "decrypted " + containerName, provider.length(), () -> new DmgDecryptorStream(containerName, dmgName, provider), monitor);
        } else {
            decryptedProvider = provider;
        }
        File decryptedDmgFile = File.createTempFile("ghidra_decrypted_dmg_file", Long.toString(System.currentTimeMillis()));
        monitor.setMessage("Copying DMG container to temp file");
        monitor.initialize(decryptedProvider.length());
        FSUtilities.copyByteProviderToFile((ByteProvider)decryptedProvider, (File)decryptedDmgFile, (TaskMonitor)monitor);
        DmgClientFileSystem fs = new DmgClientFileSystem(decryptedDmgFile, true, targetFSRL, fsService);
        try {
            fs.mount(monitor);
            return fs;
        }
        catch (IOException ioe) {
            Msg.error((Object)this, (Object)("Failed to mount DMG file system " + containerFSRL + ": "), (Throwable)ioe);
            fs.close();
            throw ioe;
        }
    }

    private static boolean isDmgPresent() {
        return DmgPresentHolder.DMG_PRESENT;
    }

    private static class DmgPresentHolder {
        static final boolean DMG_PRESENT = DmgPresentHolder.isDmgPresent();

        private DmgPresentHolder() {
        }

        private static boolean isDmgPresent() {
            ResourceFile dmgModule = Application.getModuleRootDir((String)"DMG");
            if (dmgModule == null) {
                Msg.debug(DmgClientFileSystemFactory.class, (Object)"The required \"DMG\" module is not installed.   You must install this module in order to open DMG filesystems.");
                return false;
            }
            return true;
        }
    }
}

