/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.dwarf4.LEB128;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class EncodedField
implements StructConverter {
    private long _fileOffset;
    private int fieldIndexDifference;
    private int fieldIndexDifferenceLength;
    private int accessFlags;
    private int accessFlagsLength;

    public EncodedField(BinaryReader reader) throws IOException {
        LEB128 leb128 = LEB128.readUnsignedValue((BinaryReader)reader);
        this._fileOffset = leb128.getOffset();
        this.fieldIndexDifference = leb128.asUInt32();
        this.fieldIndexDifferenceLength = leb128.getLength();
        leb128 = LEB128.readUnsignedValue((BinaryReader)reader);
        this.accessFlags = leb128.asUInt32();
        this.accessFlagsLength = leb128.getLength();
    }

    public long getFileOffset() {
        return this._fileOffset;
    }

    public int getFieldIndexDifference() {
        return this.fieldIndexDifference;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "encoded_field_" + this.fieldIndexDifferenceLength + "_" + this.accessFlagsLength;
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add((DataType)new ArrayDataType(BYTE, this.fieldIndexDifferenceLength, BYTE.getLength()), "field_idx_diff", null);
        structure.add((DataType)new ArrayDataType(BYTE, this.accessFlagsLength, BYTE.getLength()), "accessFlags", null);
        structure.setCategoryPath(new CategoryPath("/dex/encoded_field"));
        return structure;
    }
}

