/*
 * Decompiled with CFR 0.152.
 */
package ghidra.async.seq;

import ghidra.async.AsyncHandlerCanExit;
import ghidra.async.TypeSpec;
import ghidra.async.seq.AsyncSequenceActionConsumes;
import ghidra.async.seq.AsyncSequenceActionConsumesAndProduces;
import ghidra.async.seq.AsyncSequenceHandlerForProducer;
import ghidra.async.seq.AsyncSequenceHandlerForRunner;
import ghidra.async.seq.AsyncSequenceWithoutTemp;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

public class AsyncSequenceWithTemp<R, T> {
    private final CompletableFuture<T> tmpResult;
    private final CompletableFuture<R> seqResult;

    AsyncSequenceWithTemp(CompletableFuture<R> seqResult, CompletableFuture<T> tmpResult) {
        this.seqResult = seqResult;
        this.tmpResult = tmpResult;
    }

    public <U> AsyncSequenceWithTemp<R, U> then(AsyncSequenceActionConsumesAndProduces<R, T, U> action, TypeSpec<U> type) {
        return new AsyncSequenceWithTemp<R, T>(this.seqResult, this.tmpResult.thenCompose(result -> {
            HandlerForProducer handler = new HandlerForProducer(this.seqResult);
            try {
                action.accept(result, handler);
            }
            catch (Throwable e) {
                this.seqResult.completeExceptionally(e);
                throw e;
            }
            return handler.future;
        }));
    }

    public <U> AsyncSequenceWithTemp<R, U> then(Executor executor, AsyncSequenceActionConsumesAndProduces<R, T, U> action, TypeSpec<U> type) {
        return new AsyncSequenceWithTemp<R, T>(this.seqResult, this.tmpResult.thenComposeAsync(result -> {
            HandlerForProducer handler = new HandlerForProducer(this.seqResult);
            try {
                action.accept(result, handler);
            }
            catch (Throwable e) {
                this.seqResult.completeExceptionally(e);
                throw e;
            }
            return handler.future;
        }, executor));
    }

    public <U> AsyncSequenceWithoutTemp<R> then(AsyncSequenceActionConsumesAndProduces<R, T, U> action, AtomicReference<U> storage) {
        return new AsyncSequenceWithoutTemp<R>(this.seqResult, (CompletableFuture<Void>)this.tmpResult.thenCompose(result -> {
            HandlerForStorer handler = new HandlerForStorer(this.seqResult, storage);
            try {
                action.accept(result, handler);
            }
            catch (Throwable e) {
                this.seqResult.completeExceptionally(e);
                throw e;
            }
            return handler.future;
        }));
    }

    public <U> AsyncSequenceWithoutTemp<R> then(Executor executor, AsyncSequenceActionConsumesAndProduces<R, T, U> action, AtomicReference<U> storage) {
        return new AsyncSequenceWithoutTemp<R>(this.seqResult, (CompletableFuture<Void>)this.tmpResult.thenComposeAsync(result -> {
            HandlerForStorer handler = new HandlerForStorer(this.seqResult, storage);
            try {
                action.accept(result, handler);
            }
            catch (Throwable e) {
                this.seqResult.completeExceptionally(e);
                throw e;
            }
            return handler.future;
        }, executor));
    }

    public AsyncSequenceWithoutTemp<R> then(AsyncSequenceActionConsumes<R, T> action) {
        return new AsyncSequenceWithoutTemp<R>(this.seqResult, (CompletableFuture<Void>)this.tmpResult.thenCompose(result -> {
            HandlerForRunner<R> handler = new HandlerForRunner<R>(this.seqResult);
            try {
                action.accept(result, handler);
            }
            catch (Throwable e) {
                this.seqResult.completeExceptionally(e);
                throw e;
            }
            return handler.future;
        }));
    }

    public AsyncSequenceWithoutTemp<R> then(Executor executor, AsyncSequenceActionConsumes<R, T> action) {
        return new AsyncSequenceWithoutTemp<R>(this.seqResult, (CompletableFuture<Void>)this.tmpResult.thenComposeAsync(result -> {
            HandlerForRunner<R> handler = new HandlerForRunner<R>(this.seqResult);
            try {
                action.accept(result, handler);
            }
            catch (Throwable e) {
                this.seqResult.completeExceptionally(e);
                throw e;
            }
            return handler.future;
        }, executor));
    }

    public AsyncSequenceWithTemp<R, T> onExit(BiConsumer<? super R, Throwable> action) {
        this.seqResult.handle((result, exc) -> {
            action.accept((Object)result, (Throwable)exc);
            return result;
        });
        return this;
    }

    static class HandlerForRunner<R>
    extends AbstractHandler<R, Void>
    implements AsyncSequenceHandlerForRunner<R> {
        public HandlerForRunner(CompletableFuture<R> seqResult) {
            super(seqResult);
        }

        @Override
        public Void next(Void result, Throwable exc) {
            if (exc != null) {
                this.seqResult.completeExceptionally(exc);
            } else {
                this.future.complete(result);
            }
            return null;
        }
    }

    static class HandlerForStorer<R, T>
    extends AbstractHandlerForProducer<R, T, Void> {
        private final AtomicReference<T> storage;

        public HandlerForStorer(CompletableFuture<R> seqResult, AtomicReference<T> storage) {
            super(seqResult);
            this.storage = storage;
        }

        @Override
        public void proceedWithoutException(T futureResult) {
            this.storage.set(futureResult);
            this.future.complete(null);
        }
    }

    static class HandlerForProducer<R, T>
    extends AbstractHandlerForProducer<R, T, T> {
        public HandlerForProducer(CompletableFuture<R> seqResult) {
            super(seqResult);
        }

        @Override
        public void proceedWithoutException(T futureResult) {
            this.future.complete(futureResult);
        }
    }

    static abstract class AbstractHandlerForProducer<R, T, U>
    extends AbstractHandler<R, U>
    implements AsyncSequenceHandlerForProducer<R, T> {
        public AbstractHandlerForProducer(CompletableFuture<R> seqResult) {
            super(seqResult);
        }

        @Override
        public Void next(T result, Throwable exc) {
            if (exc != null) {
                this.seqResult.completeExceptionally(exc);
            } else {
                this.proceedWithoutException(result);
            }
            return null;
        }

        protected abstract void proceedWithoutException(T var1);
    }

    static abstract class AbstractHandler<R, T>
    implements AsyncHandlerCanExit<R> {
        final CompletableFuture<R> seqResult;
        final CompletableFuture<T> future = new CompletableFuture();

        public AbstractHandler(CompletableFuture<R> seqResult) {
            this.seqResult = seqResult;
        }

        @Override
        public Void exit(R result, Throwable exc) {
            if (exc != null) {
                this.seqResult.completeExceptionally(exc);
            } else {
                this.seqResult.complete(result);
            }
            return null;
        }
    }
}

