/*
 * Decompiled with CFR 0.152.
 */
package ghidra.async;

import ghidra.async.AsyncUtils;
import ghidra.util.Msg;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;

public class AsyncTimer {
    public static final AsyncTimer DEFAULT_TIMER = new AsyncTimer();
    protected Thread thread = new Thread(this::run);
    protected SortedMap<Long, Set<TimerPromise>> promises = new TreeMap<Long, Set<TimerPromise>>();
    protected long nextWake = Long.MAX_VALUE;
    protected boolean alive = true;

    public AsyncTimer() {
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        while (this.alive) {
            try {
                HashSet toComplete = new HashSet();
                AsyncTimer asyncTimer = this;
                synchronized (asyncTimer) {
                    long delta = this.nextWake - System.currentTimeMillis();
                    if (delta > 0L) {
                        this.wait(delta);
                        if (!this.alive) {
                            return;
                        }
                    }
                    long key = Long.MAX_VALUE;
                    while (!this.promises.isEmpty() && (key = this.promises.firstKey().longValue()) <= System.currentTimeMillis()) {
                        toComplete.addAll((Collection)this.promises.remove(key));
                    }
                    this.nextWake = key;
                }
                for (TimerPromise promise : toComplete) {
                    promise.complete(null);
                }
            }
            catch (Throwable e) {
                Msg.warn((Object)this, (Object)"Exception in timer thread", (Throwable)e);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.alive = false;
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> atSystemTime(long timeMillis) {
        if (timeMillis <= System.currentTimeMillis()) {
            return AsyncUtils.NIL;
        }
        AsyncTimer asyncTimer = this;
        synchronized (asyncTimer) {
            Set sameTime = this.promises.computeIfAbsent(timeMillis, k -> new HashSet());
            TimerPromise promise = new TimerPromise(timeMillis);
            sameTime.add(promise);
            if (timeMillis < this.nextWake) {
                this.nextWake = timeMillis;
                this.notify();
            }
            return promise;
        }
    }

    public Mark mark() {
        return new Mark(System.currentTimeMillis());
    }

    private class TimerPromise
    extends CompletableFuture<Void> {
        private final long time;

        TimerPromise(long time) {
            this.time = time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            AsyncTimer asyncTimer = AsyncTimer.this;
            synchronized (asyncTimer) {
                Set sameTime = (Set)AsyncTimer.this.promises.get(this.time);
                if (sameTime != null) {
                    sameTime.remove(this);
                    if (sameTime.isEmpty()) {
                        AsyncTimer.this.promises.remove(this.time);
                    }
                }
            }
            return super.cancel(mayInterruptIfRunning);
        }
    }

    public class Mark {
        protected final long mark;

        protected Mark(long mark) {
            this.mark = mark;
        }

        public CompletableFuture<Void> after(long intervalMillis) {
            return AsyncTimer.this.atSystemTime(this.mark + intervalMillis);
        }
    }
}

